/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import sun.misc.Unsafe;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS;
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final ReflectionFactory reflFactory;
    private Class cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean isEnum;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private InvalidClassException deserializeEx;
    private InvalidClassException serializeEx;
    private InvalidClassException defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Constructor cons;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;

    private static native void initNative();

    public static ObjectStreamClass lookup(Class<?> clazz) {
        return null;
    }

    public String getName() {
        return null;
    }

    public long getSerialVersionUID() {
        return 0L;
    }

    public Class<?> forClass() {
        return null;
    }

    public ObjectStreamField[] getFields() {
        return null;
    }

    public ObjectStreamField getField(String string) {
        return null;
    }

    public String toString() {
        return null;
    }

    static ObjectStreamClass lookup(Class clazz, boolean bl) {
        return null;
    }

    private ObjectStreamClass(final Class clazz) {
        this.cl = clazz;
        this.name = clazz.getName();
        this.isProxy = Proxy.isProxyClass(clazz);
        this.isEnum = Enum.class.isAssignableFrom(clazz);
        this.serializable = Serializable.class.isAssignableFrom(clazz);
        this.externalizable = Externalizable.class.isAssignableFrom(clazz);
        Class clazz2 = clazz.getSuperclass();
        this.superDesc = clazz2 != null ? ObjectStreamClass.lookup(clazz2, false) : null;
        this.localDesc = this;
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return null;
                }
            });
        } else {
            this.suid = new Long(0L);
            this.fields = NO_FIELDS;
        }
        try {
            this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this);
        }
        catch (InvalidClassException invalidClassException) {
            throw new InternalError();
        }
        if (this.deserializeEx == null) {
            if (this.isEnum) {
                this.deserializeEx = new InvalidClassException(this.name, "enum type");
            } else if (this.cons == null) {
                this.deserializeEx = new InvalidClassException(this.name, "no valid constructor");
            }
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getField() != null) continue;
            this.defaultSerializeEx = new InvalidClassException(this.name, "unmatched serializable field(s) declared");
        }
    }

    ObjectStreamClass() {
    }

    void initProxy(Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass) throws InvalidClassException {
    }

    void initNonProxy(ObjectStreamClass objectStreamClass, Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass2) throws InvalidClassException {
    }

    void readNonProxy(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    void writeNonProxy(ObjectOutputStream objectOutputStream) throws IOException {
    }

    ClassNotFoundException getResolveException() {
        return null;
    }

    void checkDeserialize() throws InvalidClassException {
    }

    void checkSerialize() throws InvalidClassException {
    }

    void checkDefaultSerialize() throws InvalidClassException {
    }

    ObjectStreamClass getSuperDesc() {
        return null;
    }

    ObjectStreamClass getLocalDesc() {
        return null;
    }

    ObjectStreamField[] getFields(boolean bl) {
        return null;
    }

    ObjectStreamField getField(String string, Class clazz) {
        return null;
    }

    boolean isProxy() {
        return false;
    }

    boolean isEnum() {
        return false;
    }

    boolean isExternalizable() {
        return false;
    }

    boolean isSerializable() {
        return false;
    }

    boolean hasBlockExternalData() {
        return false;
    }

    boolean hasWriteObjectData() {
        return false;
    }

    boolean isInstantiable() {
        return false;
    }

    boolean hasWriteObjectMethod() {
        return false;
    }

    boolean hasReadObjectMethod() {
        return false;
    }

    boolean hasReadObjectNoDataMethod() {
        return false;
    }

    boolean hasWriteReplaceMethod() {
        return false;
    }

    boolean hasReadResolveMethod() {
        return false;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException {
        return null;
    }

    void invokeWriteObject(Object object, ObjectOutputStream objectOutputStream) throws IOException, UnsupportedOperationException {
    }

    void invokeReadObject(Object object, ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, UnsupportedOperationException {
    }

    void invokeReadObjectNoData(Object object) throws IOException, UnsupportedOperationException {
    }

    Object invokeWriteReplace(Object object) throws IOException, UnsupportedOperationException {
        return null;
    }

    Object invokeReadResolve(Object object) throws IOException, UnsupportedOperationException {
        return null;
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        return null;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        return null;
    }

    int getPrimDataSize() {
        return 0;
    }

    int getNumObjFields() {
        return 0;
    }

    void getPrimFieldValues(Object object, byte[] byArray) {
    }

    void setPrimFieldValues(Object object, byte[] byArray) {
    }

    void getObjFieldValues(Object object, Object[] objectArray) {
    }

    void setObjFieldValues(Object object, Object[] objectArray) {
    }

    private void computeFieldOffsets() throws InvalidClassException {
    }

    private ObjectStreamClass getVariantFor(Class clazz) throws InvalidClassException {
        return null;
    }

    private static Constructor getExternalizableConstructor(Class clazz) {
        return null;
    }

    private static Constructor getSerializableConstructor(Class clazz) {
        return null;
    }

    private static Method getInheritableMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        return null;
    }

    private static Method getPrivateMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        return null;
    }

    private static boolean packageEquals(Class clazz, Class clazz2) {
        return false;
    }

    private static String getPackageName(Class clazz) {
        return null;
    }

    private static boolean classNamesEqual(String string, String string2) {
        return false;
    }

    static String getClassSignature(Class clazz) {
        return null;
    }

    private static String getMethodSignature(Class[] classArray, Class clazz) {
        return null;
    }

    private static void throwMiscException(Throwable throwable) throws IOException {
    }

    private static ObjectStreamField[] getSerialFields(Class clazz) throws InvalidClassException {
        return null;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class clazz) throws InvalidClassException {
        return null;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class clazz) {
        return null;
    }

    private static Long getDeclaredSUID(Class clazz) {
        return null;
    }

    private static long computeDefaultSUID(Class clazz) {
        return 0L;
    }

    private static native boolean hasStaticInitializer(Class var0);

    private static FieldReflector getReflector(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        return null;
    }

    private static ObjectStreamField[] matchFields(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        return null;
    }

    static void processQueue(ReferenceQueue<Class<?>> referenceQueue, ConcurrentMap<? extends WeakReference<Class<?>>, ?> concurrentMap) {
    }

    static /* synthetic */ Class access$000(ObjectStreamClass objectStreamClass) {
        return null;
    }

    static /* synthetic */ long access$100(Class clazz) {
        return 0L;
    }

    static /* synthetic */ boolean access$400(ObjectStreamClass objectStreamClass) {
        return false;
    }

    static /* synthetic */ Long access$502(ObjectStreamClass objectStreamClass, Long l) {
        return null;
    }

    static /* synthetic */ ObjectStreamField[] access$602(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        return null;
    }

    static /* synthetic */ Long access$700(Class clazz) {
        return null;
    }

    static /* synthetic */ ObjectStreamField[] access$800(Class clazz) throws InvalidClassException {
        return null;
    }

    static /* synthetic */ void access$900(ObjectStreamClass objectStreamClass) throws InvalidClassException {
    }

    static /* synthetic */ InvalidClassException access$1002(ObjectStreamClass objectStreamClass, InvalidClassException invalidClassException) {
        return null;
    }

    static /* synthetic */ InvalidClassException access$1102(ObjectStreamClass objectStreamClass, InvalidClassException invalidClassException) {
        return null;
    }

    static /* synthetic */ boolean access$1200(ObjectStreamClass objectStreamClass) {
        return false;
    }

    static /* synthetic */ Constructor access$1302(ObjectStreamClass objectStreamClass, Constructor constructor) {
        return null;
    }

    static /* synthetic */ Constructor access$1400(Class clazz) {
        return null;
    }

    static /* synthetic */ Constructor access$1500(Class clazz) {
        return null;
    }

    static /* synthetic */ Method access$1602(ObjectStreamClass objectStreamClass, Method method) {
        return null;
    }

    static /* synthetic */ Method access$1700(Class clazz, String string, Class[] classArray, Class clazz2) {
        return null;
    }

    static /* synthetic */ Method access$1802(ObjectStreamClass objectStreamClass, Method method) {
        return null;
    }

    static /* synthetic */ Method access$1902(ObjectStreamClass objectStreamClass, Method method) {
        return null;
    }

    static /* synthetic */ boolean access$2002(ObjectStreamClass objectStreamClass, boolean bl) {
        return false;
    }

    static /* synthetic */ Method access$1600(ObjectStreamClass objectStreamClass) {
        return null;
    }

    static /* synthetic */ Method access$2102(ObjectStreamClass objectStreamClass, Method method) {
        return null;
    }

    static /* synthetic */ Method access$2200(Class clazz, String string, Class[] classArray, Class clazz2) {
        return null;
    }

    static /* synthetic */ Method access$2302(ObjectStreamClass objectStreamClass, Method method) {
        return null;
    }

    static /* synthetic */ String access$2400(Class[] classArray, Class clazz) {
        return null;
    }

    private static class Caches {
        static final ConcurrentMap<WeakClassKey, Reference<?>> localDescs;
        static final ConcurrentMap<FieldReflectorKey, Reference<?>> reflectors;
        private static final ReferenceQueue<Class<?>> localDescsQueue;
        private static final ReferenceQueue<Class<?>> reflectorsQueue;

        private Caches() {
        }

        static /* synthetic */ ReferenceQueue access$200() {
            return null;
        }

        static /* synthetic */ ReferenceQueue access$2500() {
            return null;
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass objectStreamClass, boolean bl) {
            this.desc = objectStreamClass;
            this.hasData = bl;
        }
    }

    private static class EntryFuture {
        private static final Object unset;
        private final Thread owner = Thread.currentThread();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized boolean set(Object object) {
            return false;
        }

        synchronized Object get() {
            return null;
        }

        Thread getOwner() {
            return null;
        }
    }

    private static class FieldReflector {
        private static final Unsafe unsafe;
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private final long[] keys;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class[] types;

        FieldReflector(ObjectStreamField[] objectStreamFieldArray) {
            this.fields = objectStreamFieldArray;
            int n = objectStreamFieldArray.length;
            this.keys = new long[n];
            this.offsets = new int[n];
            this.typeCodes = new char[n];
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                Field field = objectStreamField.getField();
                this.keys[i] = field != null ? unsafe.objectFieldOffset(field) : -1L;
                this.offsets[i] = objectStreamField.getOffset();
                this.typeCodes[i] = objectStreamField.getTypeCode();
                if (objectStreamField.isPrimitive()) continue;
                arrayList.add(field != null ? field.getType() : null);
            }
            this.types = arrayList.toArray(new Class[arrayList.size()]);
            this.numPrimFields = n - this.types.length;
        }

        ObjectStreamField[] getFields() {
            return null;
        }

        void getPrimFieldValues(Object object, byte[] byArray) {
        }

        void setPrimFieldValues(Object object, byte[] byArray) {
        }

        void getObjFieldValues(Object object, Object[] objectArray) {
        }

        void setObjFieldValues(Object object, Object[] objectArray) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldReflectorKey
    extends WeakReference<Class<?>> {
        private final String sigs;
        private final int hash;
        private final boolean nullClass;

        FieldReflectorKey(Class<?> clazz, ObjectStreamField[] objectStreamFieldArray, ReferenceQueue<Class<?>> referenceQueue) {
            super(clazz, referenceQueue);
            this.nullClass = clazz == null;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                stringBuilder.append(objectStreamField.getName()).append(objectStreamField.getSignature());
            }
            this.sigs = stringBuilder.toString();
            this.hash = System.identityHashCode(clazz) + this.sigs.hashCode();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }
    }

    private static class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = ObjectStreamClass.getClassSignature(field.getType());
        }

        public MemberSignature(Constructor constructor) {
            this.member = constructor;
            this.name = constructor.getName();
            this.signature = ObjectStreamClass.access$2400(constructor.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method method) {
            this.member = method;
            this.name = method.getName();
            this.signature = ObjectStreamClass.access$2400(method.getParameterTypes(), method.getReturnType());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class WeakClassKey
    extends WeakReference<Class<?>> {
        private final int hash;

        WeakClassKey(Class<?> clazz, ReferenceQueue<Class<?>> referenceQueue) {
            super(clazz, referenceQueue);
            this.hash = System.identityHashCode(clazz);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }
    }
}

