/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OutputStream;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private final BlockDataOutputStream bout;
    private final HandleTable handles;
    private final ReplaceTable subs;
    private int protocol = 2;
    private int depth;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableReplace;
    private Object curObj;
    private ObjectStreamClass curDesc;
    private PutFieldImpl curPut;

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.verifySubclass();
        this.bout = new BlockDataOutputStream(outputStream);
        this.handles = new HandleTable(10, 3.0f);
        this.subs = new ReplaceTable(10, 3.0f);
        this.enableOverride = false;
        this.writeStreamHeader();
        this.bout.setBlockDataMode(true);
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bout = null;
        this.handles = null;
        this.subs = null;
        this.enableOverride = true;
    }

    public void useProtocolVersion(int n) throws IOException {
    }

    @Override
    public final void writeObject(Object object) throws IOException {
    }

    protected void writeObjectOverride(Object object) throws IOException {
    }

    public void writeUnshared(Object object) throws IOException {
    }

    public void defaultWriteObject() throws IOException {
    }

    public PutField putFields() throws IOException {
        return null;
    }

    public void writeFields() throws IOException {
    }

    public void reset() throws IOException {
    }

    protected void annotateClass(Class<?> clazz) throws IOException {
    }

    protected void annotateProxyClass(Class<?> clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return null;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        return false;
    }

    protected void writeStreamHeader() throws IOException {
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
    }

    @Override
    public void write(int n) throws IOException {
    }

    @Override
    public void write(byte[] byArray) throws IOException {
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    protected void drain() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void writeBoolean(boolean bl) throws IOException {
    }

    @Override
    public void writeByte(int n) throws IOException {
    }

    @Override
    public void writeShort(int n) throws IOException {
    }

    @Override
    public void writeChar(int n) throws IOException {
    }

    @Override
    public void writeInt(int n) throws IOException {
    }

    @Override
    public void writeLong(long l) throws IOException {
    }

    @Override
    public void writeFloat(float f) throws IOException {
    }

    @Override
    public void writeDouble(double d) throws IOException {
    }

    @Override
    public void writeBytes(String string) throws IOException {
    }

    @Override
    public void writeChars(String string) throws IOException {
    }

    @Override
    public void writeUTF(String string) throws IOException {
    }

    int getProtocolVersion() {
        return 0;
    }

    void writeTypeString(String string) throws IOException {
    }

    private void verifySubclass() {
    }

    private static boolean auditSubclass(Class clazz) {
        return false;
    }

    private void clear() {
    }

    private void writeObject0(Object object, boolean bl) throws IOException {
    }

    private void writeNull() throws IOException {
    }

    private void writeHandle(int n) throws IOException {
    }

    private void writeClass(Class clazz, boolean bl) throws IOException {
    }

    private void writeClassDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
    }

    private void writeProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
    }

    private void writeNonProxyDesc(ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
    }

    private void writeString(String string, boolean bl) throws IOException {
    }

    private void writeArray(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
    }

    private void writeEnum(Enum enum_, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
    }

    private void writeOrdinaryObject(Object object, ObjectStreamClass objectStreamClass, boolean bl) throws IOException {
    }

    private void writeExternalData(Externalizable externalizable) throws IOException {
    }

    private void writeSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
    }

    private void defaultWriteFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
    }

    private void writeFatalException(IOException iOException) throws IOException {
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    static /* synthetic */ BlockDataOutputStream access$000(ObjectOutputStream objectOutputStream) {
        return null;
    }

    static /* synthetic */ void access$100(ObjectOutputStream objectOutputStream, Object object, boolean bl) throws IOException {
    }

    static /* synthetic */ void access$200(float[] fArray, int n, byte[] byArray, int n2, int n3) {
    }

    static /* synthetic */ void access$300(double[] dArray, int n, byte[] byArray, int n2, int n3) {
    }

    private static class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private final OutputStream out;
        private final DataOutputStream dout;

        BlockDataOutputStream(OutputStream outputStream) {
            this.out = outputStream;
            this.dout = new DataOutputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            return false;
        }

        boolean getBlockDataMode() {
            return false;
        }

        public void write(int n) throws IOException {
        }

        public void write(byte[] byArray) throws IOException {
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        void write(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        }

        void drain() throws IOException {
        }

        private void writeBlockHeader(int n) throws IOException {
        }

        public void writeBoolean(boolean bl) throws IOException {
        }

        public void writeByte(int n) throws IOException {
        }

        public void writeChar(int n) throws IOException {
        }

        public void writeShort(int n) throws IOException {
        }

        public void writeInt(int n) throws IOException {
        }

        public void writeFloat(float f) throws IOException {
        }

        public void writeLong(long l) throws IOException {
        }

        public void writeDouble(double d) throws IOException {
        }

        public void writeBytes(String string) throws IOException {
        }

        public void writeChars(String string) throws IOException {
        }

        public void writeUTF(String string) throws IOException {
        }

        void writeBooleans(boolean[] blArray, int n, int n2) throws IOException {
        }

        void writeChars(char[] cArray, int n, int n2) throws IOException {
        }

        void writeShorts(short[] sArray, int n, int n2) throws IOException {
        }

        void writeInts(int[] nArray, int n, int n2) throws IOException {
        }

        void writeFloats(float[] fArray, int n, int n2) throws IOException {
        }

        void writeLongs(long[] lArray, int n, int n2) throws IOException {
        }

        void writeDoubles(double[] dArray, int n, int n2) throws IOException {
        }

        long getUTFLength(String string) {
            return 0L;
        }

        void writeUTF(String string, long l) throws IOException {
        }

        void writeLongUTF(String string) throws IOException {
        }

        void writeLongUTF(String string, long l) throws IOException {
        }

        private void writeUTFBody(String string) throws IOException {
        }
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits;
        static final ReferenceQueue<Class<?>> subclassAuditsQueue;

        private Caches() {
        }
    }

    private static class HandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        HandleTable(int n, float f) {
            this.loadFactor = f;
            this.spine = new int[n];
            this.next = new int[n];
            this.objs = new Object[n];
            this.threshold = (int)((float)n * f);
            this.clear();
        }

        int assign(Object object) {
            return 0;
        }

        int lookup(Object object) {
            return 0;
        }

        void clear() {
        }

        int size() {
            return 0;
        }

        private void insert(Object object, int n) {
        }

        private void growSpine() {
        }

        private void growEntries() {
        }

        private int hash(Object object) {
            return 0;
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        @Deprecated
        public abstract void write(ObjectOutput var1) throws IOException;
    }

    private class PutFieldImpl
    extends PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            this.primVals = new byte[objectStreamClass.getPrimDataSize()];
            this.objVals = new Object[objectStreamClass.getNumObjFields()];
        }

        public void put(String string, boolean bl) {
        }

        public void put(String string, byte by) {
        }

        public void put(String string, char c) {
        }

        public void put(String string, short s) {
        }

        public void put(String string, int n) {
        }

        public void put(String string, float f) {
        }

        public void put(String string, long l) {
        }

        public void put(String string, double d) {
        }

        public void put(String string, Object object) {
        }

        public void write(ObjectOutput objectOutput) throws IOException {
        }

        void writeFields() throws IOException {
        }

        private int getFieldOffset(String string, Class clazz) {
            return 0;
        }
    }

    private static class ReplaceTable {
        private final HandleTable htab;
        private Object[] reps;

        ReplaceTable(int n, float f) {
            this.htab = new HandleTable(n, f);
            this.reps = new Object[n];
        }

        void assign(Object object, Object object2) {
        }

        Object lookup(Object object) {
            return null;
        }

        void clear() {
        }

        int size() {
            return 0;
        }

        private void grow() {
        }
    }
}

