/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.StreamCorruptedException;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker;
    private static final HashMap primClasses;
    private final BlockDataInputStream bin;
    private final ValidationList vlist;
    private int depth;
    private boolean closed;
    private final HandleTable handles;
    private int passHandle = -1;
    private boolean defaultDataEnd = false;
    private byte[] primVals;
    private final boolean enableOverride;
    private boolean enableResolve;
    private CallbackContext curContext;

    public ObjectInputStream(InputStream inputStream) throws IOException {
        this.verifySubclass();
        this.bin = new BlockDataInputStream(inputStream);
        this.handles = new HandleTable(10);
        this.vlist = new ValidationList();
        this.enableOverride = false;
        this.readStreamHeader();
        this.bin.setBlockDataMode(true);
    }

    protected ObjectInputStream() throws IOException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.bin = null;
        this.handles = null;
        this.vlist = null;
        this.enableOverride = true;
    }

    @Override
    public final Object readObject() throws IOException, ClassNotFoundException {
        return null;
    }

    protected Object readObjectOverride() throws IOException, ClassNotFoundException {
        return null;
    }

    public Object readUnshared() throws IOException, ClassNotFoundException {
        return null;
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException {
    }

    public GetField readFields() throws IOException, ClassNotFoundException {
        return null;
    }

    public void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
    }

    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return null;
    }

    protected Class<?> resolveProxyClass(String[] stringArray) throws IOException, ClassNotFoundException {
        return null;
    }

    protected Object resolveObject(Object object) throws IOException {
        return null;
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        return false;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        return null;
    }

    @Override
    public int read() throws IOException {
        return 0;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return 0;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean readBoolean() throws IOException {
        return false;
    }

    @Override
    public byte readByte() throws IOException {
        return 0;
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return 0;
    }

    @Override
    public char readChar() throws IOException {
        return '\u0000';
    }

    @Override
    public short readShort() throws IOException {
        return 0;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return 0;
    }

    @Override
    public int readInt() throws IOException {
        return 0;
    }

    @Override
    public long readLong() throws IOException {
        return 0L;
    }

    @Override
    public float readFloat() throws IOException {
        return 0.0f;
    }

    @Override
    public double readDouble() throws IOException {
        return 0.0;
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return 0;
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return null;
    }

    @Override
    public String readUTF() throws IOException {
        return null;
    }

    private void verifySubclass() {
    }

    private static boolean auditSubclass(Class clazz) {
        return false;
    }

    private void clear() {
    }

    private Object readObject0(boolean bl) throws IOException {
        return null;
    }

    private Object checkResolve(Object object) throws IOException {
        return null;
    }

    String readTypeString() throws IOException {
        return null;
    }

    private Object readNull() throws IOException {
        return null;
    }

    private Object readHandle(boolean bl) throws IOException {
        return null;
    }

    private Class readClass(boolean bl) throws IOException {
        return null;
    }

    private ObjectStreamClass readClassDesc(boolean bl) throws IOException {
        return null;
    }

    private ObjectStreamClass readProxyDesc(boolean bl) throws IOException {
        return null;
    }

    private ObjectStreamClass readNonProxyDesc(boolean bl) throws IOException {
        return null;
    }

    private String readString(boolean bl) throws IOException {
        return null;
    }

    private Object readArray(boolean bl) throws IOException {
        return null;
    }

    private Enum readEnum(boolean bl) throws IOException {
        return null;
    }

    private Object readOrdinaryObject(boolean bl) throws IOException {
        return null;
    }

    private void readExternalData(Externalizable externalizable, ObjectStreamClass objectStreamClass) throws IOException {
    }

    private void readSerialData(Object object, ObjectStreamClass objectStreamClass) throws IOException {
    }

    private void skipCustomData() throws IOException {
    }

    private void defaultReadFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
    }

    private IOException readFatalException() throws IOException {
        return null;
    }

    private void handleReset() throws StreamCorruptedException {
    }

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    private static native ClassLoader latestUserDefinedLoader();

    static /* synthetic */ int access$000(ObjectInputStream objectInputStream) {
        return 0;
    }

    static /* synthetic */ HandleTable access$100(ObjectInputStream objectInputStream) {
        return null;
    }

    static /* synthetic */ BlockDataInputStream access$200(ObjectInputStream objectInputStream) {
        return null;
    }

    static /* synthetic */ Object access$300(ObjectInputStream objectInputStream, boolean bl) throws IOException {
        return null;
    }

    static /* synthetic */ int access$002(ObjectInputStream objectInputStream, int n) {
        return 0;
    }

    static /* synthetic */ boolean access$400(ObjectInputStream objectInputStream) {
        return false;
    }

    static /* synthetic */ void access$500(ObjectInputStream objectInputStream) throws StreamCorruptedException {
    }

    static /* synthetic */ void access$600(byte[] byArray, int n, float[] fArray, int n2, int n3) {
    }

    static /* synthetic */ void access$700(byte[] byArray, int n, double[] dArray, int n2, int n3) {
    }

    private class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = 1024;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = 256;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf = new byte[1024];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[256];
        private boolean blkmode = false;
        private int pos = 0;
        private int end = -1;
        private int unread = 0;
        private final PeekInputStream in;
        private final DataInputStream din;

        BlockDataInputStream(InputStream inputStream) {
            this.in = new PeekInputStream(inputStream);
            this.din = new DataInputStream(this);
        }

        boolean setBlockDataMode(boolean bl) throws IOException {
            return false;
        }

        boolean getBlockDataMode() {
            return false;
        }

        void skipBlockData() throws IOException {
        }

        private int readBlockHeader(boolean bl) throws IOException {
            return 0;
        }

        private void refill() throws IOException {
        }

        int currentBlockRemaining() {
            return 0;
        }

        int peek() throws IOException {
            return 0;
        }

        byte peekByte() throws IOException {
            return 0;
        }

        public int read() throws IOException {
            return 0;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return 0;
        }

        public long skip(long l) throws IOException {
            return 0L;
        }

        public int available() throws IOException {
            return 0;
        }

        public void close() throws IOException {
        }

        int read(byte[] byArray, int n, int n2, boolean bl) throws IOException {
            return 0;
        }

        public void readFully(byte[] byArray) throws IOException {
        }

        public void readFully(byte[] byArray, int n, int n2) throws IOException {
        }

        public void readFully(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        }

        public int skipBytes(int n) throws IOException {
            return 0;
        }

        public boolean readBoolean() throws IOException {
            return false;
        }

        public byte readByte() throws IOException {
            return 0;
        }

        public int readUnsignedByte() throws IOException {
            return 0;
        }

        public char readChar() throws IOException {
            return '\u0000';
        }

        public short readShort() throws IOException {
            return 0;
        }

        public int readUnsignedShort() throws IOException {
            return 0;
        }

        public int readInt() throws IOException {
            return 0;
        }

        public float readFloat() throws IOException {
            return 0.0f;
        }

        public long readLong() throws IOException {
            return 0L;
        }

        public double readDouble() throws IOException {
            return 0.0;
        }

        public String readUTF() throws IOException {
            return null;
        }

        public String readLine() throws IOException {
            return null;
        }

        void readBooleans(boolean[] blArray, int n, int n2) throws IOException {
        }

        void readChars(char[] cArray, int n, int n2) throws IOException {
        }

        void readShorts(short[] sArray, int n, int n2) throws IOException {
        }

        void readInts(int[] nArray, int n, int n2) throws IOException {
        }

        void readFloats(float[] fArray, int n, int n2) throws IOException {
        }

        void readLongs(long[] lArray, int n, int n2) throws IOException {
        }

        void readDoubles(double[] dArray, int n, int n2) throws IOException {
        }

        String readLongUTF() throws IOException {
            return null;
        }

        private String readUTFBody(long l) throws IOException {
            return null;
        }

        private long readUTFSpan(StringBuffer stringBuffer, long l) throws IOException {
            return 0L;
        }

        private int readUTFChar(StringBuffer stringBuffer, long l) throws IOException {
            return 0;
        }
    }

    private static class Caches {
        static final ConcurrentMap<ObjectStreamClass.WeakClassKey, Boolean> subclassAudits;
        static final ReferenceQueue<Class<?>> subclassAuditsQueue;

        private Caches() {
        }
    }

    private static class CallbackContext {
        private final Object obj;
        private final ObjectStreamClass desc;
        private final AtomicBoolean used = new AtomicBoolean();

        public CallbackContext(Object object, ObjectStreamClass objectStreamClass) {
            this.obj = object;
            this.desc = objectStreamClass;
        }

        public Object getObj() throws NotActiveException {
            return null;
        }

        public ObjectStreamClass getDesc() {
            return null;
        }

        private void checkAndSetUsed() throws NotActiveException {
        }

        public void setUsed() {
        }
    }

    public static abstract class GetField {
        public abstract ObjectStreamClass getObjectStreamClass();

        public abstract boolean defaulted(String var1) throws IOException;

        public abstract boolean get(String var1, boolean var2) throws IOException;

        public abstract byte get(String var1, byte var2) throws IOException;

        public abstract char get(String var1, char var2) throws IOException;

        public abstract short get(String var1, short var2) throws IOException;

        public abstract int get(String var1, int var2) throws IOException;

        public abstract long get(String var1, long var2) throws IOException;

        public abstract float get(String var1, float var2) throws IOException;

        public abstract double get(String var1, double var2) throws IOException;

        public abstract Object get(String var1, Object var2) throws IOException;
    }

    private class GetFieldImpl
    extends GetField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;
        private final int[] objHandles;

        GetFieldImpl(ObjectStreamClass objectStreamClass) {
            this.desc = objectStreamClass;
            this.primVals = new byte[objectStreamClass.getPrimDataSize()];
            this.objVals = new Object[objectStreamClass.getNumObjFields()];
            this.objHandles = new int[this.objVals.length];
        }

        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }

        public boolean defaulted(String string) throws IOException {
            return false;
        }

        public boolean get(String string, boolean bl) throws IOException {
            return false;
        }

        public byte get(String string, byte by) throws IOException {
            return 0;
        }

        public char get(String string, char c) throws IOException {
            return '\u0000';
        }

        public short get(String string, short s) throws IOException {
            return 0;
        }

        public int get(String string, int n) throws IOException {
            return 0;
        }

        public float get(String string, float f) throws IOException {
            return 0.0f;
        }

        public long get(String string, long l) throws IOException {
            return 0L;
        }

        public double get(String string, double d) throws IOException {
            return 0.0;
        }

        public Object get(String string, Object object) throws IOException {
            return null;
        }

        void readFields() throws IOException {
        }

        private int getFieldOffset(String string, Class clazz) {
            return 0;
        }
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        HandleTable(int n) {
            this.status = new byte[n];
            this.entries = new Object[n];
            this.deps = new HandleList[n];
        }

        int assign(Object object) {
            return 0;
        }

        void markDependency(int n, int n2) {
        }

        void markException(int n, ClassNotFoundException classNotFoundException) {
        }

        void finish(int n) {
        }

        void setObject(int n, Object object) {
        }

        Object lookupObject(int n) {
            return null;
        }

        ClassNotFoundException lookupException(int n) {
            return null;
        }

        void clear() {
        }

        int size() {
            return 0;
        }

        private void grow() {
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public void add(int n) {
            }

            public int get(int n) {
                return 0;
            }

            public int size() {
                return 0;
            }
        }
    }

    private static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb = -1;

        PeekInputStream(InputStream inputStream) {
            this.in = inputStream;
        }

        int peek() throws IOException {
            return 0;
        }

        public int read() throws IOException {
            return 0;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return 0;
        }

        void readFully(byte[] byArray, int n, int n2) throws IOException {
        }

        public long skip(long l) throws IOException {
            return 0L;
        }

        public int available() throws IOException {
            return 0;
        }

        public void close() throws IOException {
        }
    }

    private static class ValidationList {
        private Callback list;

        ValidationList() {
        }

        void register(ObjectInputValidation objectInputValidation, int n) throws InvalidObjectException {
        }

        void doCallbacks() throws InvalidObjectException {
        }

        public void clear() {
        }

        private static class Callback {
            final ObjectInputValidation obj;
            final int priority;
            Callback next;

            Callback(ObjectInputValidation objectInputValidation, int n, Callback callback) {
                this.obj = objectInputValidation;
                this.priority = n;
                this.next = callback;
            }
        }
    }
}

