/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;

public class FileOutputStream
extends OutputStream {
    private FileDescriptor fd;
    private FileChannel channel = null;
    private boolean append = false;

    public FileOutputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null, false);
    }

    public FileOutputStream(String string, boolean bl) throws FileNotFoundException {
        this(string != null ? new File(string) : null, bl);
    }

    public FileOutputStream(File file) throws FileNotFoundException {
        this(file, false);
    }

    public FileOutputStream(File file, boolean bl) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.append = bl;
        if (bl) {
            this.openAppend(string);
        } else {
            this.open(string);
        }
    }

    public FileOutputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkWrite(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    private native void open(String var1) throws FileNotFoundException;

    private native void openAppend(String var1) throws FileNotFoundException;

    public native void write(int var1) throws IOException;

    private native void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void write(byte[] byArray) throws IOException {
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
    }

    public void close() throws IOException {
    }

    public final FileDescriptor getFD() throws IOException {
        return null;
    }

    public FileChannel getChannel() {
        return null;
    }

    protected void finalize() throws IOException {
    }

    private native void close0() throws IOException;

    private static native void initIDs();
}

