/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private FileChannel channel = null;

    public FileInputStream(String string) throws FileNotFoundException {
        this(string != null ? new File(string) : null);
    }

    public FileInputStream(File file) throws FileNotFoundException {
        String string = file != null ? file.getPath() : null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(string);
        }
        if (string == null) {
            throw new NullPointerException();
        }
        this.fd = new FileDescriptor();
        this.open(string);
    }

    public FileInputStream(FileDescriptor fileDescriptor) {
        SecurityManager securityManager = System.getSecurityManager();
        if (fileDescriptor == null) {
            throw new NullPointerException();
        }
        if (securityManager != null) {
            securityManager.checkRead(fileDescriptor);
        }
        this.fd = fileDescriptor;
    }

    private native void open(String var1) throws FileNotFoundException;

    public native int read() throws IOException;

    private native int readBytes(byte[] var1, int var2, int var3) throws IOException;

    public int read(byte[] byArray) throws IOException {
        return 0;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return 0;
    }

    public native long skip(long var1) throws IOException;

    public native int available() throws IOException;

    public void close() throws IOException {
    }

    public final FileDescriptor getFD() throws IOException {
        return null;
    }

    public FileChannel getChannel() {
        return null;
    }

    private static native void initIDs();

    private native void close0() throws IOException;

    protected void finalize() throws IOException {
    }
}

