/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Serializable,
Comparable<File> {
    private static FileSystem fs;
    private String path;
    private transient int prefixLength;
    public static final char separatorChar;
    public static final String separator;
    public static final char pathSeparatorChar;
    public static final String pathSeparator;
    private static final Object tmpFileLock;
    private static int counter;
    private static String tmpdir;
    private static final long serialVersionUID = 301077366599181567L;
    static final /* synthetic */ boolean $assertionsDisabled;

    int getPrefixLength() {
        return 0;
    }

    private File(String string, int n) {
        this.path = string;
        this.prefixLength = n;
    }

    private File(String string, File file) {
        if (!$assertionsDisabled && file.path == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && file.path.equals("")) {
            throw new AssertionError();
        }
        this.path = fs.resolve(file.path, string);
        this.prefixLength = file.prefixLength;
    }

    public File(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        this.path = string != null ? (string.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string2)) : fs.resolve(fs.normalize(string), fs.normalize(string2))) : fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(File file, String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.path = file != null ? (file.path.equals("") ? fs.resolve(fs.getDefaultParent(), fs.normalize(string)) : fs.resolve(file.path, fs.normalize(string))) : fs.normalize(string);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public File(URI uRI) {
        if (!uRI.isAbsolute()) {
            throw new IllegalArgumentException("URI is not absolute");
        }
        if (uRI.isOpaque()) {
            throw new IllegalArgumentException("URI is not hierarchical");
        }
        String string = uRI.getScheme();
        if (string == null || !string.equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        if (uRI.getAuthority() != null) {
            throw new IllegalArgumentException("URI has an authority component");
        }
        if (uRI.getFragment() != null) {
            throw new IllegalArgumentException("URI has a fragment component");
        }
        if (uRI.getQuery() != null) {
            throw new IllegalArgumentException("URI has a query component");
        }
        String string2 = uRI.getPath();
        if (string2.equals("")) {
            throw new IllegalArgumentException("URI path component is empty");
        }
        string2 = fs.fromURIPath(string2);
        if (separatorChar != '/') {
            string2 = string2.replace('/', separatorChar);
        }
        this.path = fs.normalize(string2);
        this.prefixLength = fs.prefixLength(this.path);
    }

    public String getName() {
        return null;
    }

    public String getParent() {
        return null;
    }

    public File getParentFile() {
        return null;
    }

    public String getPath() {
        return null;
    }

    public boolean isAbsolute() {
        return false;
    }

    public String getAbsolutePath() {
        return null;
    }

    public File getAbsoluteFile() {
        return null;
    }

    public String getCanonicalPath() throws IOException {
        return null;
    }

    public File getCanonicalFile() throws IOException {
        return null;
    }

    private static String slashify(String string, boolean bl) {
        return null;
    }

    public URL toURL() throws MalformedURLException {
        return null;
    }

    public URI toURI() {
        return null;
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public boolean exists() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public long lastModified() {
        return 0L;
    }

    public long length() {
        return 0L;
    }

    public boolean createNewFile() throws IOException {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public void deleteOnExit() {
    }

    public String[] list() {
        return null;
    }

    public String[] list(FilenameFilter filenameFilter) {
        return null;
    }

    public File[] listFiles() {
        return null;
    }

    public File[] listFiles(FilenameFilter filenameFilter) {
        return null;
    }

    public File[] listFiles(FileFilter fileFilter) {
        return null;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean mkdirs() {
        return false;
    }

    public boolean renameTo(File file) {
        return false;
    }

    public boolean setLastModified(long l) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public static File[] listRoots() {
        return null;
    }

    private static File generateFile(String string, String string2, File file) throws IOException {
        return null;
    }

    private static String getTempDir() {
        return null;
    }

    private static boolean checkAndCreate(String string, SecurityManager securityManager) throws IOException {
        return false;
    }

    public static File createTempFile(String string, String string2, File file) throws IOException {
        return null;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        return null;
    }

    @Override
    public int compareTo(File file) {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return null;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

