/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] bitSizes;
    private int maxBitSize;
    private int scanlineStride;

    private static native void initIDs();

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int[] nArray) {
        this(n, n2, n3, n2, nArray);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
    }

    public SinglePixelPackedSampleModel(int n, int n2, int n3, int n4, int[] nArray) {
        super(n, n2, n3, nArray.length);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
        this.dataType = n;
        this.bitMasks = (int[])nArray.clone();
        this.scanlineStride = n4;
        this.bitOffsets = new int[this.numBands];
        this.bitSizes = new int[this.numBands];
        this.maxBitSize = 0;
        for (int i = 0; i < this.numBands; ++i) {
            int n5 = 0;
            int n6 = 0;
            int n7 = nArray[i];
            if (n7 != 0) {
                while ((n7 & 1) == 0) {
                    n7 >>>= 1;
                    ++n5;
                }
                while ((n7 & 1) == 1) {
                    n7 >>>= 1;
                    ++n6;
                }
                if (n7 != 0) {
                    throw new IllegalArgumentException("Mask " + nArray[i] + " must be contiguous");
                }
            }
            this.bitOffsets[i] = n5;
            this.bitSizes[i] = n6;
            if (n6 <= this.maxBitSize) continue;
            this.maxBitSize = n6;
        }
    }

    public int getNumDataElements() {
        return 0;
    }

    private long getBufferSize() {
        return 0L;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return null;
    }

    public DataBuffer createDataBuffer() {
        return null;
    }

    public int[] getSampleSize() {
        return null;
    }

    public int getSampleSize(int n) {
        return 0;
    }

    public int getOffset(int n, int n2) {
        return 0;
    }

    public int[] getBitOffsets() {
        return null;
    }

    public int[] getBitMasks() {
        return null;
    }

    public int getScanlineStride() {
        return 0;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        return null;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        return null;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        return null;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        return null;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        return 0;
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        return null;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

