/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class Raster {
    protected SampleModel sampleModel;
    protected DataBuffer dataBuffer;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected int numBands;
    protected int numDataElements;
    protected Raster parent;

    private static native void initIDs();

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, Point point) {
        return null;
    }

    public static WritableRaster createInterleavedRaster(int n, int n2, int n3, int n4, int n5, int[] nArray, Point point) {
        return null;
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, Point point) {
        return null;
    }

    public static WritableRaster createBandedRaster(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2, Point point) {
        return null;
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int[] nArray, Point point) {
        return null;
    }

    public static WritableRaster createPackedRaster(int n, int n2, int n3, int n4, int n5, Point point) {
        return null;
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int n4, int[] nArray, Point point) {
        return null;
    }

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, int[] nArray2, Point point) {
        return null;
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, int[] nArray, Point point) {
        return null;
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int n, int n2, int n3, Point point) {
        return null;
    }

    public static Raster createRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        return null;
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, Point point) {
        return null;
    }

    public static WritableRaster createWritableRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        return null;
    }

    protected Raster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, Raster raster) {
        if (sampleModel == null || dataBuffer == null || rectangle == null || point == null) {
            throw new NullPointerException("SampleModel, dataBuffer, aRegion and sampleModelTranslate cannot be null");
        }
        this.sampleModel = sampleModel;
        this.dataBuffer = dataBuffer;
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        this.width = rectangle.width;
        this.height = rectangle.height;
        if (this.width <= 0 || this.height <= 0) {
            throw new RasterFormatException("negative or zero " + (this.width <= 0 ? "width" : "height"));
        }
        if (this.minX + this.width < this.minX) {
            throw new RasterFormatException("overflow condition for X coordinates of Raster");
        }
        if (this.minY + this.height < this.minY) {
            throw new RasterFormatException("overflow condition for Y coordinates of Raster");
        }
        this.sampleModelTranslateX = point.x;
        this.sampleModelTranslateY = point.y;
        this.numBands = sampleModel.getNumBands();
        this.numDataElements = sampleModel.getNumDataElements();
        this.parent = raster;
    }

    public Raster getParent() {
        return null;
    }

    public final int getSampleModelTranslateX() {
        return 0;
    }

    public final int getSampleModelTranslateY() {
        return 0;
    }

    public WritableRaster createCompatibleWritableRaster() {
        return null;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return null;
    }

    public WritableRaster createCompatibleWritableRaster(Rectangle rectangle) {
        return null;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2, int n3, int n4) {
        return null;
    }

    public Raster createTranslatedChild(int n, int n2) {
        return null;
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return null;
    }

    public Rectangle getBounds() {
        return null;
    }

    public final int getMinX() {
        return 0;
    }

    public final int getMinY() {
        return 0;
    }

    public final int getWidth() {
        return 0;
    }

    public final int getHeight() {
        return 0;
    }

    public final int getNumBands() {
        return 0;
    }

    public final int getNumDataElements() {
        return 0;
    }

    public final int getTransferType() {
        return 0;
    }

    public DataBuffer getDataBuffer() {
        return null;
    }

    public SampleModel getSampleModel() {
        return null;
    }

    public Object getDataElements(int n, int n2, Object object) {
        return null;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        return null;
    }

    public int[] getPixel(int n, int n2, int[] nArray) {
        return null;
    }

    public float[] getPixel(int n, int n2, float[] fArray) {
        return null;
    }

    public double[] getPixel(int n, int n2, double[] dArray) {
        return null;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray) {
        return null;
    }

    public float[] getPixels(int n, int n2, int n3, int n4, float[] fArray) {
        return null;
    }

    public double[] getPixels(int n, int n2, int n3, int n4, double[] dArray) {
        return null;
    }

    public int getSample(int n, int n2, int n3) {
        return 0;
    }

    public float getSampleFloat(int n, int n2, int n3) {
        return 0.0f;
    }

    public double getSampleDouble(int n, int n2, int n3) {
        return 0.0;
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        return null;
    }

    public float[] getSamples(int n, int n2, int n3, int n4, int n5, float[] fArray) {
        return null;
    }

    public double[] getSamples(int n, int n2, int n3, int n4, int n5, double[] dArray) {
        return null;
    }
}

