/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public abstract class PackedColorModel
extends ColorModel {
    int[] maskArray;
    int[] maskOffsets;
    float[] scaleFactors;

    public PackedColorModel(ColorSpace colorSpace, int n, int[] nArray, int n2, boolean bl, int n3, int n4) {
        super(n, PackedColorModel.createBitsArray(nArray, n2), colorSpace, n2 != 0, bl, n3, n4);
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 32.");
        }
        this.maskArray = new int[this.numComponents];
        this.maskOffsets = new int[this.numComponents];
        this.scaleFactors = new float[this.numComponents];
        for (int i = 0; i < this.numColorComponents; ++i) {
            this.DecomposeMask(nArray[i], i, colorSpace.getName(i));
        }
        if (n2 != 0) {
            this.DecomposeMask(n2, this.numColorComponents, "alpha");
            if (this.nBits[this.numComponents - 1] == 1) {
                this.transparency = 2;
            }
        }
    }

    public PackedColorModel(ColorSpace colorSpace, int n, int n2, int n3, int n4, int n5, boolean bl, int n6, int n7) {
        super(n, PackedColorModel.createBitsArray(n2, n3, n4, n5), colorSpace, n5 != 0, bl, n6, n7);
        if (colorSpace.getType() != 5) {
            throw new IllegalArgumentException("ColorSpace must be TYPE_RGB.");
        }
        this.maskArray = new int[this.numComponents];
        this.maskOffsets = new int[this.numComponents];
        this.scaleFactors = new float[this.numComponents];
        this.DecomposeMask(n2, 0, "red");
        this.DecomposeMask(n3, 1, "green");
        this.DecomposeMask(n4, 2, "blue");
        if (n5 != 0) {
            this.DecomposeMask(n5, 3, "alpha");
            if (this.nBits[3] == 1) {
                this.transparency = 2;
            }
        }
    }

    public final int getMask(int n) {
        return 0;
    }

    public final int[] getMasks() {
        return null;
    }

    private void DecomposeMask(int n, int n2, String string) {
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return null;
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return false;
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    private static final int[] createBitsArray(int[] nArray, int n) {
        return null;
    }

    private static final int[] createBitsArray(int n, int n2, int n3, int n4) {
        return null;
    }

    private static final int countBits(int n) {
        return 0;
    }
}

