/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public class MultiPixelPackedSampleModel
extends SampleModel {
    int pixelBitStride;
    int bitMask;
    int pixelsPerDataElement;
    int dataElementSize;
    int dataBitOffset;
    int scanlineStride;

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, (n2 * n4 + DataBuffer.getDataTypeSize(n) - 1) / DataBuffer.getDataTypeSize(n), 0);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
    }

    public MultiPixelPackedSampleModel(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, 1);
        if (n != 0 && n != 1 && n != 3) {
            throw new IllegalArgumentException("Unsupported data type " + n);
        }
        this.dataType = n;
        this.pixelBitStride = n4;
        this.scanlineStride = n5;
        this.dataBitOffset = n6;
        this.dataElementSize = DataBuffer.getDataTypeSize(n);
        this.pixelsPerDataElement = this.dataElementSize / n4;
        if (this.pixelsPerDataElement * n4 != this.dataElementSize) {
            throw new RasterFormatException("MultiPixelPackedSampleModel does not allow pixels to span data element boundaries");
        }
        this.bitMask = (1 << n4) - 1;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return null;
    }

    public DataBuffer createDataBuffer() {
        return null;
    }

    public int getNumDataElements() {
        return 0;
    }

    public int[] getSampleSize() {
        return null;
    }

    public int getSampleSize(int n) {
        return 0;
    }

    public int getOffset(int n, int n2) {
        return 0;
    }

    public int getBitOffset(int n) {
        return 0;
    }

    public int getScanlineStride() {
        return 0;
    }

    public int getPixelBitStride() {
        return 0;
    }

    public int getDataBitOffset() {
        return 0;
    }

    public int getTransferType() {
        return 0;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        return null;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        return 0;
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        return null;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        return null;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

