/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.math.BigInteger;

public class IndexColorModel
extends ColorModel {
    private int[] rgb;
    private int map_size;
    private int transparent_index = -1;
    private boolean allgrayopaque;
    private BigInteger validBits;
    private static int[] opaqueBits;
    private static int[] alphaBits;
    private static final int CACHESIZE = 40;
    private int[] lookupcache = new int[40];

    private static native void initIDs();

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n3) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
        this.setTransparentPixel(n3);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        super(n, alphaBits, ColorSpace.getInstance(1000), true, false, 3, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        this.setRGBs(n2, byArray, byArray2, byArray3, byArray4);
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl) {
        this(n, n2, byArray, n3, bl, -1);
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
    }

    public IndexColorModel(int n, int n2, byte[] byArray, int n3, boolean bl, int n4) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, ColorModel.getDefaultTransferType(n));
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        this.map_size = n2;
        this.rgb = new int[this.calcRealMapSize(n, n2)];
        int n5 = n3;
        int n6 = 255;
        boolean bl2 = true;
        int n7 = 1;
        for (int i = 0; i < n2; ++i) {
            int n8 = byArray[n5++] & 0xFF;
            int n9 = byArray[n5++] & 0xFF;
            int n10 = byArray[n5++] & 0xFF;
            boolean bl3 = bl2 = bl2 && n8 == n9 && n9 == n10;
            if (bl && (n6 = byArray[n5++] & 0xFF) != 255) {
                if (n6 == 0) {
                    if (n7 == 1) {
                        n7 = 2;
                    }
                    if (this.transparent_index < 0) {
                        this.transparent_index = i;
                    }
                } else {
                    n7 = 3;
                }
                bl2 = false;
            }
            this.rgb[i] = n6 << 24 | n8 << 16 | n9 << 8 | n10;
        }
        this.allgrayopaque = bl2;
        this.setTransparency(n7);
        this.setTransparentPixel(n4);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, boolean bl, int n4, int n5) {
        super(n, opaqueBits, ColorSpace.getInstance(1000), false, false, 1, n5);
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        if (n5 != 0 && n5 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        this.setRGBs(n2, nArray, n3, bl);
        this.setTransparentPixel(n4);
    }

    public IndexColorModel(int n, int n2, int[] nArray, int n3, int n4, BigInteger bigInteger) {
        super(n, alphaBits, ColorSpace.getInstance(1000), true, false, 3, n4);
        if (n < 1 || n > 16) {
            throw new IllegalArgumentException("Number of bits must be between 1 and 16.");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Map size (" + n2 + ") must be >= 1");
        }
        if (n4 != 0 && n4 != 1) {
            throw new IllegalArgumentException("transferType must be eitherDataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT");
        }
        if (bigInteger != null) {
            for (int i = 0; i < n2; ++i) {
                if (bigInteger.testBit(i)) continue;
                this.validBits = bigInteger;
                break;
            }
        }
        this.setRGBs(n2, nArray, n3, true);
    }

    private void setRGBs(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
    }

    private void setRGBs(int n, int[] nArray, int n2, boolean bl) {
    }

    private int calcRealMapSize(int n, int n2) {
        return 0;
    }

    private BigInteger getAllValid() {
        return null;
    }

    public int getTransparency() {
        return 0;
    }

    public int[] getComponentSize() {
        return null;
    }

    public final int getMapSize() {
        return 0;
    }

    public final int getTransparentPixel() {
        return 0;
    }

    public final void getReds(byte[] byArray) {
    }

    public final void getGreens(byte[] byArray) {
    }

    public final void getBlues(byte[] byArray) {
    }

    public final void getAlphas(byte[] byArray) {
    }

    public final void getRGBs(int[] nArray) {
    }

    private void setTransparentPixel(int n) {
    }

    private void setTransparency(int n) {
    }

    public final int getRed(int n) {
        return 0;
    }

    public final int getGreen(int n) {
        return 0;
    }

    public final int getBlue(int n) {
        return 0;
    }

    public final int getAlpha(int n) {
        return 0;
    }

    public final int getRGB(int n) {
        return 0;
    }

    public synchronized Object getDataElements(int n, Object object) {
        return null;
    }

    private Object installpixel(Object object, int n) {
        return null;
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        return null;
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        return null;
    }

    public int getDataElement(int[] nArray, int n) {
        return 0;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        return null;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return null;
    }

    public boolean isCompatibleRaster(Raster raster) {
        return false;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return null;
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return false;
    }

    public BufferedImage convertToIntDiscrete(Raster raster, boolean bl) {
        return null;
    }

    public boolean isValid(int n) {
        return false;
    }

    public boolean isValid() {
        return false;
    }

    public BigInteger getValidPixels() {
        return null;
    }

    public void finalize() {
    }

    public String toString() {
        return null;
    }
}

