/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands = 1;
    protected int numBanks = 1;
    protected int scanlineStride;
    protected int pixelStride;

    private static native void initIDs();

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        super(n, n2, n3, nArray.length);
        this.dataType = n;
        this.pixelStride = n4;
        this.scanlineStride = n5;
        this.bandOffsets = (int[])nArray.clone();
        this.numBands = nArray.length;
        if (n4 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (this.numBands < 1) {
            throw new IllegalArgumentException("Must have at least one band.");
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        this.bankIndices = new int[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            this.bankIndices[i] = 0;
        }
    }

    public ComponentSampleModel(int n, int n2, int n3, int n4, int n5, int[] nArray, int[] nArray2) {
        super(n, n2, n3, nArray2.length);
        this.dataType = n;
        this.pixelStride = n4;
        this.scanlineStride = n5;
        this.bandOffsets = (int[])nArray2.clone();
        this.bankIndices = (int[])nArray.clone();
        if (n4 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (n < 0 || n > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        int n6 = nArray[0];
        if (n6 < 0) {
            throw new IllegalArgumentException("Index of bank 0 is less than 0 (" + n6 + ")");
        }
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] > n6) {
                n6 = nArray[i];
                continue;
            }
            if (nArray[i] >= 0) continue;
            throw new IllegalArgumentException("Index of bank " + i + " is less than 0 (" + n6 + ")");
        }
        this.numBanks = n6 + 1;
        this.numBands = nArray2.length;
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException("Length of bandOffsets must equal length of bankIndices.");
        }
    }

    private long getBufferSize() {
        return 0L;
    }

    int[] orderBands(int[] nArray, int n) {
        return null;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return null;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        return null;
    }

    public DataBuffer createDataBuffer() {
        return null;
    }

    public int getOffset(int n, int n2) {
        return 0;
    }

    public int getOffset(int n, int n2, int n3) {
        return 0;
    }

    public final int[] getSampleSize() {
        return null;
    }

    public final int getSampleSize(int n) {
        return 0;
    }

    public final int[] getBankIndices() {
        return null;
    }

    public final int[] getBandOffsets() {
        return null;
    }

    public final int getScanlineStride() {
        return 0;
    }

    public final int getPixelStride() {
        return 0;
    }

    public final int getNumDataElements() {
        return 0;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        return null;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        return null;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        return null;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        return 0;
    }

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        return 0.0f;
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        return 0.0;
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        return null;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
    }

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

