/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;

public abstract class ColorModel
implements Transparency {
    private long pData;
    protected int pixel_bits;
    int[] nBits;
    int transparency = 3;
    boolean supportsAlpha = true;
    boolean isAlphaPremultiplied = false;
    int numComponents = -1;
    int numColorComponents = -1;
    ColorSpace colorSpace = ColorSpace.getInstance(1000);
    int colorSpaceType = 5;
    int maxBits;
    boolean is_sRGB = true;
    protected int transferType;
    private static boolean loaded;
    private static ColorModel RGBdefault;
    static byte[] l8Tos8;
    static byte[] s8Tol8;
    static byte[] l16Tos8;
    static short[] s8Tol16;
    static Map g8Tos8Map;
    static Map lg16Toog8Map;
    static Map g16Tos8Map;
    static Map lg16Toog16Map;

    static void loadLibraries() {
    }

    private static native void initIDs();

    public static ColorModel getRGBdefault() {
        return null;
    }

    public ColorModel(int n) {
        this.pixel_bits = n;
        if (n < 1) {
            throw new IllegalArgumentException("Number of bits must be > 0");
        }
        this.numComponents = 4;
        this.numColorComponents = 3;
        this.maxBits = n;
        this.transferType = ColorModel.getDefaultTransferType(n);
    }

    protected ColorModel(int n, int[] nArray, ColorSpace colorSpace, boolean bl, boolean bl2, int n2, int n3) {
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpace.getType();
        this.numColorComponents = colorSpace.getNumComponents();
        this.numComponents = this.numColorComponents + (bl ? 1 : 0);
        this.supportsAlpha = bl;
        if (nArray.length < this.numComponents) {
            throw new IllegalArgumentException("Number of color/alpha components should be " + this.numComponents + " but length of bits array is " + nArray.length);
        }
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException("Unknown transparency: " + n2);
        }
        if (!this.supportsAlpha) {
            this.isAlphaPremultiplied = false;
            this.transparency = 1;
        } else {
            this.isAlphaPremultiplied = bl2;
            this.transparency = n2;
        }
        this.nBits = (int[])nArray.clone();
        this.pixel_bits = n;
        if (n <= 0) {
            throw new IllegalArgumentException("Number of pixel bits must be > 0");
        }
        this.maxBits = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                throw new IllegalArgumentException("Number of bits must be >= 0");
            }
            if (this.maxBits >= nArray[i]) continue;
            this.maxBits = nArray[i];
        }
        if (this.maxBits == 0) {
            throw new IllegalArgumentException("There must be at least one component with > 0 pixel bits.");
        }
        if (colorSpace != ColorSpace.getInstance(1000)) {
            this.is_sRGB = false;
        }
        this.transferType = n3;
    }

    public final boolean hasAlpha() {
        return false;
    }

    public final boolean isAlphaPremultiplied() {
        return false;
    }

    public final int getTransferType() {
        return 0;
    }

    public int getPixelSize() {
        return 0;
    }

    public int getComponentSize(int n) {
        return 0;
    }

    public int[] getComponentSize() {
        return null;
    }

    public int getTransparency() {
        return 0;
    }

    public int getNumComponents() {
        return 0;
    }

    public int getNumColorComponents() {
        return 0;
    }

    public abstract int getRed(int var1);

    public abstract int getGreen(int var1);

    public abstract int getBlue(int var1);

    public abstract int getAlpha(int var1);

    public int getRGB(int n) {
        return 0;
    }

    public int getRed(Object object) {
        return 0;
    }

    public int getGreen(Object object) {
        return 0;
    }

    public int getBlue(Object object) {
        return 0;
    }

    public int getAlpha(Object object) {
        return 0;
    }

    public int getRGB(Object object) {
        return 0;
    }

    public Object getDataElements(int n, Object object) {
        return null;
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        return null;
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        return null;
    }

    public int[] getUnnormalizedComponents(float[] fArray, int n, int[] nArray, int n2) {
        return null;
    }

    public float[] getNormalizedComponents(int[] nArray, int n, float[] fArray, int n2) {
        return null;
    }

    public int getDataElement(int[] nArray, int n) {
        return 0;
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        return null;
    }

    public int getDataElement(float[] fArray, int n) {
        return 0;
    }

    public Object getDataElements(float[] fArray, int n, Object object) {
        return null;
    }

    public float[] getNormalizedComponents(Object object, float[] fArray, int n) {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public final ColorSpace getColorSpace() {
        return null;
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        return null;
    }

    public boolean isCompatibleRaster(Raster raster) {
        return false;
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        return null;
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        return null;
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return false;
    }

    public void finalize() {
    }

    public WritableRaster getAlphaRaster(WritableRaster writableRaster) {
        return null;
    }

    public String toString() {
        return null;
    }

    static int getDefaultTransferType(int n) {
        return 0;
    }

    static boolean isLinearRGBspace(ColorSpace colorSpace) {
        return false;
    }

    static boolean isLinearGRAYspace(ColorSpace colorSpace) {
        return false;
    }

    static byte[] getLinearRGB8TosRGB8LUT() {
        return null;
    }

    static byte[] getsRGB8ToLinearRGB8LUT() {
        return null;
    }

    static byte[] getLinearRGB16TosRGB8LUT() {
        return null;
    }

    static short[] getsRGB8ToLinearRGB16LUT() {
        return null;
    }

    static byte[] getGray8TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        return null;
    }

    static byte[] getLinearGray16ToOtherGray8LUT(ICC_ColorSpace iCC_ColorSpace) {
        return null;
    }

    static byte[] getGray16TosRGB8LUT(ICC_ColorSpace iCC_ColorSpace) {
        return null;
    }

    static short[] getLinearGray16ToOtherGray16LUT(ICC_ColorSpace iCC_ColorSpace) {
        return null;
    }
}

