/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import sun.awt.color.ICC_Transform;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    ICC_Profile[] profileList;
    ColorSpace[] CSList;
    ICC_Transform thisTransform;
    ICC_Transform thisRasterTransform;
    ICC_Profile thisSrcProfile;
    ICC_Profile thisDestProfile;
    RenderingHints hints;
    boolean gotProfiles;
    float[] srcMinVals;
    float[] srcMaxVals;
    float[] dstMinVals;
    float[] dstMaxVals;

    public ColorConvertOp(RenderingHints renderingHints) {
        this.profileList = new ICC_Profile[0];
        this.hints = renderingHints;
    }

    public ColorConvertOp(ColorSpace colorSpace, RenderingHints renderingHints) {
        if (colorSpace == null) {
            throw new NullPointerException("ColorSpace cannot be null");
        }
        if (colorSpace instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[1];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
        } else {
            this.CSList = new ColorSpace[1];
            this.CSList[0] = colorSpace;
        }
        this.hints = renderingHints;
    }

    public ColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2, RenderingHints renderingHints) {
        if (colorSpace == null || colorSpace2 == null) {
            throw new NullPointerException("ColorSpaces cannot be null");
        }
        if (colorSpace instanceof ICC_ColorSpace && colorSpace2 instanceof ICC_ColorSpace) {
            this.profileList = new ICC_Profile[2];
            this.profileList[0] = ((ICC_ColorSpace)colorSpace).getProfile();
            this.profileList[1] = ((ICC_ColorSpace)colorSpace2).getProfile();
            this.getMinMaxValsFromColorSpaces(colorSpace, colorSpace2);
        } else {
            this.CSList = new ColorSpace[2];
            this.CSList[0] = colorSpace;
            this.CSList[1] = colorSpace2;
        }
        this.hints = renderingHints;
    }

    public ColorConvertOp(ICC_Profile[] iCC_ProfileArray, RenderingHints renderingHints) {
        if (iCC_ProfileArray == null) {
            throw new NullPointerException("Profiles cannot be null");
        }
        this.gotProfiles = true;
        this.profileList = new ICC_Profile[iCC_ProfileArray.length];
        for (int i = 0; i < iCC_ProfileArray.length; ++i) {
            this.profileList[i] = iCC_ProfileArray[i];
        }
        this.hints = renderingHints;
    }

    public final ICC_Profile[] getICC_Profiles() {
        return null;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return null;
    }

    private final BufferedImage ICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        return null;
    }

    private void updateBITransform(ICC_Profile iCC_Profile, ICC_Profile iCC_Profile2) {
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        return null;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return null;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return null;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return null;
    }

    private BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel, ColorSpace colorSpace) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return null;
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return null;
    }

    private int getRenderingIntent(ICC_Profile iCC_Profile) {
        return 0;
    }

    public final RenderingHints getRenderingHints() {
        return null;
    }

    private final BufferedImage nonICCBIFilter(BufferedImage bufferedImage, ColorSpace colorSpace, BufferedImage bufferedImage2, ColorSpace colorSpace2) {
        return null;
    }

    private final WritableRaster nonICCRasterFilter(Raster raster, WritableRaster writableRaster) {
        return null;
    }

    private void getMinMaxValsFromProfiles(ICC_Profile iCC_Profile, ICC_Profile iCC_Profile2) {
    }

    private void setMinMax(int n, int n2, float[] fArray, float[] fArray2) {
    }

    private void getMinMaxValsFromColorSpaces(ColorSpace colorSpace, ColorSpace colorSpace2) {
    }
}

