/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    private AffineTransform xform;
    RenderingHints hints;
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    public static final int TYPE_BILINEAR = 2;
    public static final int TYPE_BICUBIC = 3;
    int interpolationType = 1;

    public AffineTransformOp(AffineTransform affineTransform, RenderingHints renderingHints) {
        this.validateTransform(affineTransform);
        this.xform = (AffineTransform)affineTransform.clone();
        this.hints = renderingHints;
        if (renderingHints != null) {
            Object object = renderingHints.get(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = renderingHints.get(RenderingHints.KEY_RENDERING);
                if (object == RenderingHints.VALUE_RENDER_SPEED) {
                    this.interpolationType = 1;
                } else if (object == RenderingHints.VALUE_RENDER_QUALITY) {
                    this.interpolationType = 2;
                }
            } else if (object == RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                this.interpolationType = 1;
            } else if (object == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                this.interpolationType = 2;
            } else if (object == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                this.interpolationType = 3;
            }
        } else {
            this.interpolationType = 1;
        }
    }

    public AffineTransformOp(AffineTransform affineTransform, int n) {
        this.validateTransform(affineTransform);
        this.xform = (AffineTransform)affineTransform.clone();
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown interpolation type: " + n);
            }
        }
        this.interpolationType = n;
    }

    public final int getInterpolationType() {
        return 0;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return null;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        return null;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return null;
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return null;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return null;
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        return null;
    }

    public final AffineTransform getTransform() {
        return null;
    }

    public final RenderingHints getRenderingHints() {
        return null;
    }

    void validateTransform(AffineTransform affineTransform) {
    }
}

