/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;

class ArcIterator
implements PathIterator {
    double x;
    double y;
    double w;
    double h;
    double angStRad;
    double increment;
    double cv;
    AffineTransform affine;
    int index;
    int arcSegs;
    int lineSegs;

    ArcIterator(Arc2D arc2D, AffineTransform affineTransform) {
        this.w = arc2D.getWidth() / 2.0;
        this.h = arc2D.getHeight() / 2.0;
        this.x = arc2D.getX() + this.w;
        this.y = arc2D.getY() + this.h;
        this.angStRad = -Math.toRadians(arc2D.getAngleStart());
        this.affine = affineTransform;
        double d = -arc2D.getAngleExtent();
        if (d >= 360.0 || d <= -360.0) {
            this.arcSegs = 4;
            this.increment = 1.5707963267948966;
            this.cv = 0.5522847498307933;
            if (d < 0.0) {
                this.increment = -this.increment;
                this.cv = -this.cv;
            }
        } else {
            this.arcSegs = (int)Math.ceil(Math.abs(d) / 90.0);
            this.increment = Math.toRadians(d / (double)this.arcSegs);
            this.cv = ArcIterator.btan(this.increment);
            if (this.cv == 0.0) {
                this.arcSegs = 0;
            }
        }
        switch (arc2D.getArcType()) {
            case 0: {
                this.lineSegs = 0;
                break;
            }
            case 1: {
                this.lineSegs = 1;
                break;
            }
            case 2: {
                this.lineSegs = 2;
            }
        }
        if (this.w < 0.0 || this.h < 0.0) {
            this.lineSegs = -1;
            this.arcSegs = -1;
        }
    }

    public int getWindingRule() {
        return 0;
    }

    public boolean isDone() {
        return false;
    }

    public void next() {
    }

    private static double btan(double d) {
        return 0.0;
    }

    public int currentSegment(float[] fArray) {
        return 0;
    }

    public int currentSegment(double[] dArray) {
        return 0;
    }
}

