/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLine;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import sun.font.CoreMetrics;
import sun.font.Decoration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TextLayout
implements Cloneable {
    private int characterCount;
    private boolean isVerticalLine = false;
    private byte baseline;
    private float[] baselineOffsets;
    private TextLine textLine;
    private TextLine.TextLineMetrics lineMetrics = null;
    private float visibleAdvance;
    private int hashCodeCache;
    private OptInfo optInfo;
    private boolean cacheIsValid = false;
    private float justifyRatio;
    private static final float ALREADY_JUSTIFIED = -53.9f;
    private static float dx;
    private static float dy;
    private Rectangle2D naturalBounds = null;
    private Rectangle2D boundsRect = null;
    private boolean caretsInLigaturesAreAllowed = false;
    public static final CaretPolicy DEFAULT_CARET_POLICY;

    public TextLayout(String string, Font font, FontRenderContext fontRenderContext) {
        if (font == null) {
            throw new IllegalArgumentException("Null font passed to TextLayout constructor.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        char[] cArray = string.toCharArray();
        if (TextLayout.sameBaselineUpTo(font, cArray, 0, cArray.length) == cArray.length) {
            this.fastInit(cArray, font, null, fontRenderContext);
        } else {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, font);
            this.standardInit(attributedString.getIterator(), cArray, fontRenderContext);
        }
    }

    public TextLayout(String string, Map<? extends AttributedCharacterIterator.Attribute, ?> map, FontRenderContext fontRenderContext) {
        if (string == null) {
            throw new IllegalArgumentException("Null string passed to TextLayout constructor.");
        }
        if (map == null) {
            throw new IllegalArgumentException("Null map passed to TextLayout constructor.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("Zero length string passed to TextLayout constructor.");
        }
        char[] cArray = string.toCharArray();
        Font font = TextLayout.singleFont(cArray, 0, cArray.length, map);
        if (font != null) {
            this.fastInit(cArray, font, map, fontRenderContext);
        } else {
            AttributedString attributedString = new AttributedString(string, map);
            this.standardInit(attributedString.getIterator(), cArray, fontRenderContext);
        }
    }

    private static Font singleFont(char[] cArray, int n, int n2, Map map) {
        return null;
    }

    public TextLayout(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        Map<AttributedCharacterIterator.Attribute, Object> map;
        Font font;
        int n;
        if (attributedCharacterIterator == null) {
            throw new IllegalArgumentException("Null iterator passed to TextLayout constructor.");
        }
        int n2 = attributedCharacterIterator.getBeginIndex();
        if (n2 == (n = attributedCharacterIterator.getEndIndex())) {
            throw new IllegalArgumentException("Zero length iterator passed to TextLayout constructor.");
        }
        int n3 = n - n2;
        attributedCharacterIterator.first();
        char[] cArray = new char[n3];
        int n4 = 0;
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            cArray[n4++] = c;
            c = attributedCharacterIterator.next();
        }
        attributedCharacterIterator.first();
        if (attributedCharacterIterator.getRunLimit() == n && (font = TextLayout.singleFont(cArray, 0, n3, map = attributedCharacterIterator.getAttributes())) != null) {
            this.fastInit(cArray, font, map, fontRenderContext);
            return;
        }
        this.standardInit(attributedCharacterIterator, cArray, fontRenderContext);
    }

    TextLayout(TextLine textLine, byte by, float[] fArray, float f) {
        this.characterCount = textLine.characterCount();
        this.baseline = by;
        this.baselineOffsets = fArray;
        this.textLine = textLine;
        this.justifyRatio = f;
    }

    private void paragraphInit(byte by, CoreMetrics coreMetrics, Map map, char[] cArray) {
    }

    private void fastInit(char[] cArray, Font font, Map map, FontRenderContext fontRenderContext) {
    }

    private void initTextLine() {
    }

    private void standardInit(AttributedCharacterIterator attributedCharacterIterator, char[] cArray, FontRenderContext fontRenderContext) {
    }

    private void ensureCache() {
    }

    private void buildCache() {
    }

    private Rectangle2D getNaturalBounds() {
        return null;
    }

    protected Object clone() {
        return null;
    }

    private void checkTextHit(TextHitInfo textHitInfo) {
    }

    public TextLayout getJustifiedLayout(float f) {
        return null;
    }

    protected void handleJustify(float f) {
    }

    public byte getBaseline() {
        return 0;
    }

    public float[] getBaselineOffsets() {
        return null;
    }

    public float getAdvance() {
        return 0.0f;
    }

    public float getVisibleAdvance() {
        return 0.0f;
    }

    public float getAscent() {
        return 0.0f;
    }

    public float getDescent() {
        return 0.0f;
    }

    public float getLeading() {
        return 0.0f;
    }

    public Rectangle2D getBounds() {
        return null;
    }

    public boolean isLeftToRight() {
        return false;
    }

    public boolean isVertical() {
        return false;
    }

    public int getCharacterCount() {
        return 0;
    }

    private float[] getCaretInfo(int n, Rectangle2D rectangle2D, float[] fArray) {
        return null;
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        return null;
    }

    private float[] getCaretInfoTestInternal(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        return null;
    }

    public float[] getCaretInfo(TextHitInfo textHitInfo) {
        return null;
    }

    private int hitToCaret(TextHitInfo textHitInfo) {
        return 0;
    }

    private TextHitInfo caretToHit(int n) {
        return null;
    }

    private boolean caretIsValid(int n) {
        return false;
    }

    public TextHitInfo getNextRightHit(TextHitInfo textHitInfo) {
        return null;
    }

    public TextHitInfo getNextRightHit(int n, CaretPolicy caretPolicy) {
        return null;
    }

    public TextHitInfo getNextRightHit(int n) {
        return null;
    }

    public TextHitInfo getNextLeftHit(TextHitInfo textHitInfo) {
        return null;
    }

    public TextHitInfo getNextLeftHit(int n, CaretPolicy caretPolicy) {
        return null;
    }

    public TextHitInfo getNextLeftHit(int n) {
        return null;
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo textHitInfo) {
        return null;
    }

    private double[] getCaretPath(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        return null;
    }

    private double[] getCaretPath(int n, Rectangle2D rectangle2D, boolean bl) {
        return null;
    }

    private static GeneralPath pathToShape(double[] dArray, boolean bl) {
        return null;
    }

    public Shape getCaretShape(TextHitInfo textHitInfo, Rectangle2D rectangle2D) {
        return null;
    }

    public Shape getCaretShape(TextHitInfo textHitInfo) {
        return null;
    }

    private final TextHitInfo getStrongHit(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return null;
    }

    public byte getCharacterLevel(int n) {
        return 0;
    }

    public Shape[] getCaretShapes(int n, Rectangle2D rectangle2D, CaretPolicy caretPolicy) {
        return null;
    }

    public Shape[] getCaretShapes(int n, Rectangle2D rectangle2D) {
        return null;
    }

    public Shape[] getCaretShapes(int n) {
        return null;
    }

    private GeneralPath boundingShape(double[] dArray, double[] dArray2) {
        return null;
    }

    private GeneralPath caretBoundingShape(int n, int n2, Rectangle2D rectangle2D) {
        return null;
    }

    private GeneralPath leftShape(Rectangle2D rectangle2D) {
        return null;
    }

    private GeneralPath rightShape(Rectangle2D rectangle2D) {
        return null;
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return null;
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, Rectangle2D rectangle2D) {
        return null;
    }

    public Shape getVisualHighlightShape(TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return null;
    }

    public Shape getLogicalHighlightShape(int n, int n2, Rectangle2D rectangle2D) {
        return null;
    }

    public Shape getLogicalHighlightShape(int n, int n2) {
        return null;
    }

    public Shape getBlackBoxBounds(int n, int n2) {
        return null;
    }

    private float caretToPointDistance(float[] fArray, float f, float f2) {
        return 0.0f;
    }

    public TextHitInfo hitTestChar(float f, float f2, Rectangle2D rectangle2D) {
        return null;
    }

    public TextHitInfo hitTestChar(float f, float f2) {
        return null;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }

    public boolean equals(TextLayout textLayout) {
        return false;
    }

    public String toString() {
        return null;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
    }

    TextLine getTextLineForTesting() {
        return null;
    }

    private static int sameBaselineUpTo(Font font, char[] cArray, int n, int n2) {
        return 0;
    }

    static byte getBaselineFromGraphic(GraphicAttribute graphicAttribute) {
        return 0;
    }

    public Shape getOutline(AffineTransform affineTransform) {
        return null;
    }

    static /* synthetic */ TextHitInfo access$000(TextLayout textLayout, TextHitInfo textHitInfo, TextHitInfo textHitInfo2) {
        return null;
    }

    public static class CaretPolicy {
        public TextHitInfo getStrongCaret(TextHitInfo textHitInfo, TextHitInfo textHitInfo2, TextLayout textLayout) {
            return null;
        }
    }

    static class OptInfo
    implements Decoration.Label {
        private static final float MAGIC_ADVANCE = -12345.67f;
        private FontRenderContext frc;
        private char[] chars;
        private Font font;
        private CoreMetrics metrics;
        private Map attrs;
        private float advance;
        private Rectangle2D vb;
        private Decoration decoration;
        private String str;

        private OptInfo(FontRenderContext fontRenderContext, char[] cArray, Font font, CoreMetrics coreMetrics, Map map) {
            this.frc = fontRenderContext;
            this.chars = cArray;
            this.font = font;
            this.metrics = coreMetrics;
            this.attrs = map;
            if (map != null) {
                this.attrs = new HashMap(map);
            }
            this.advance = -12345.67f;
        }

        TextLine createTextLine() {
            return null;
        }

        float getAdvance() {
            return 0.0f;
        }

        public CoreMetrics getCoreMetrics() {
            return null;
        }

        public Rectangle2D getLogicalBounds() {
            return null;
        }

        public void handleDraw(Graphics2D graphics2D, float f, float f2) {
        }

        public Rectangle2D handleGetCharVisualBounds(int n) {
            return null;
        }

        public Rectangle2D handleGetVisualBounds() {
            return null;
        }

        public Shape handleGetOutline(float f, float f2) {
            return null;
        }

        boolean draw(Graphics2D graphics2D, float f, float f2) {
            return false;
        }

        Rectangle2D getVisualBounds() {
            return null;
        }

        Decoration getDecoration() {
            return null;
        }

        static OptInfo create(FontRenderContext fontRenderContext, char[] cArray, Font font, CoreMetrics coreMetrics, Map map) {
            return null;
        }
    }
}

