/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.TooManyListenersException;
import javax.swing.Timer;

public class DropTarget
implements DropTargetListener,
Serializable {
    private static final long serialVersionUID = -6283860791671019047L;
    private DropTargetContext dropTargetContext = this.createDropTargetContext();
    private Component component;
    private transient ComponentPeer componentPeer;
    private transient ComponentPeer nativePeer;
    int actions = 3;
    boolean active = true;
    private transient DropTargetAutoScroller autoScroller;
    private transient DropTargetListener dtListener;
    private transient FlavorMap flavorMap = SystemFlavorMap.getDefaultFlavorMap();

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl, FlavorMap flavorMap) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        this.component = component;
        this.setDefaultActions(n);
        if (dropTargetListener != null) {
            try {
                this.addDropTargetListener(dropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
        if (component != null) {
            component.setDropTarget(this);
            this.setActive(bl);
        }
        if (flavorMap != null) {
            this.flavorMap = flavorMap;
        }
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener, boolean bl) throws HeadlessException {
        this(component, n, dropTargetListener, bl, null);
    }

    public DropTarget() throws HeadlessException {
        this(null, 3, null, true, null);
    }

    public DropTarget(Component component, DropTargetListener dropTargetListener) throws HeadlessException {
        this(component, 3, dropTargetListener, true, null);
    }

    public DropTarget(Component component, int n, DropTargetListener dropTargetListener) throws HeadlessException {
        this(component, n, dropTargetListener, true);
    }

    public synchronized void setComponent(Component component) {
    }

    public synchronized Component getComponent() {
        return null;
    }

    public void setDefaultActions(int n) {
    }

    void doSetDefaultActions(int n) {
    }

    public int getDefaultActions() {
        return 0;
    }

    public synchronized void setActive(boolean bl) {
    }

    public boolean isActive() {
        return false;
    }

    public synchronized void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
    }

    public synchronized void removeDropTargetListener(DropTargetListener dropTargetListener) {
    }

    public synchronized void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public synchronized void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public synchronized void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public synchronized void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
    }

    public FlavorMap getFlavorMap() {
        return null;
    }

    public void setFlavorMap(FlavorMap flavorMap) {
    }

    public void addNotify(ComponentPeer componentPeer) {
    }

    public void removeNotify(ComponentPeer componentPeer) {
    }

    public DropTargetContext getDropTargetContext() {
        return null;
    }

    protected DropTargetContext createDropTargetContext() {
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }

    protected DropTargetAutoScroller createDropTargetAutoScroller(Component component, Point point) {
        return null;
    }

    protected void initializeAutoscrolling(Point point) {
    }

    protected void updateAutoscroll(Point point) {
    }

    protected void clearAutoscroll() {
    }

    protected static class DropTargetAutoScroller
    implements ActionListener {
        private Component component;
        private Autoscroll autoScroll;
        private Timer timer;
        private Point locn;
        private Point prev;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;

        protected DropTargetAutoScroller(Component component, Point point) {
            this.component = component;
            this.autoScroll = (Autoscroll)((Object)this.component);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Integer n = new Integer(100);
            Integer n2 = new Integer(100);
            try {
                n = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.initialDelay");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n2 = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.interval");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer = new Timer(n2, this);
            this.timer.setCoalesce(true);
            this.timer.setInitialDelay(n);
            this.locn = point;
            this.prev = point;
            try {
                this.hysteresis = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.timer.start();
        }

        private void updateRegion() {
        }

        protected synchronized void updateLocation(Point point) {
        }

        protected void stop() {
        }

        public synchronized void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

