/*
 * Decompiled with CFR 0.152.
 */
package java.awt.dnd;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.TooManyListenersException;

public abstract class DragGestureRecognizer
implements Serializable {
    private static final long serialVersionUID = 8996673345831063337L;
    protected DragSource dragSource;
    protected Component component;
    protected transient DragGestureListener dragGestureListener;
    protected int sourceActions;
    protected ArrayList<InputEvent> events = new ArrayList(1);

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (dragSource == null) {
            throw new IllegalArgumentException("null DragSource");
        }
        this.dragSource = dragSource;
        this.component = component;
        this.sourceActions = n & 0x40000003;
        try {
            if (dragGestureListener != null) {
                this.addDragGestureListener(dragGestureListener);
            }
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component, int n) {
        this(dragSource, component, n, null);
    }

    protected DragGestureRecognizer(DragSource dragSource, Component component) {
        this(dragSource, component, 0);
    }

    protected DragGestureRecognizer(DragSource dragSource) {
        this(dragSource, null);
    }

    protected abstract void registerListeners();

    protected abstract void unregisterListeners();

    public DragSource getDragSource() {
        return null;
    }

    public synchronized Component getComponent() {
        return null;
    }

    public synchronized void setComponent(Component component) {
    }

    public synchronized int getSourceActions() {
        return 0;
    }

    public synchronized void setSourceActions(int n) {
    }

    public InputEvent getTriggerEvent() {
        return null;
    }

    public void resetRecognizer() {
    }

    public synchronized void addDragGestureListener(DragGestureListener dragGestureListener) throws TooManyListenersException {
    }

    public synchronized void removeDragGestureListener(DragGestureListener dragGestureListener) {
    }

    protected synchronized void fireDragGestureRecognized(int n, Point point) {
    }

    protected synchronized void appendEvent(InputEvent inputEvent) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }
}

