/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;

abstract class TexturePaintContext
implements PaintContext {
    public static ColorModel xrgbmodel;
    public static ColorModel argbmodel;
    ColorModel colorModel;
    int bWidth;
    int bHeight;
    int maxWidth;
    WritableRaster outRas;
    double xOrg;
    double yOrg;
    double incXAcross;
    double incYAcross;
    double incXDown;
    double incYDown;
    int colincx;
    int colincy;
    int colincxerr;
    int colincyerr;
    int rowincx;
    int rowincy;
    int rowincxerr;
    int rowincyerr;
    private static WeakReference xrgbRasRef;
    private static WeakReference argbRasRef;
    private static WeakReference byteRasRef;

    public static PaintContext getContext(BufferedImage bufferedImage, AffineTransform affineTransform, RenderingHints renderingHints, Rectangle rectangle) {
        return null;
    }

    public static boolean isFilterableICM(ColorModel colorModel) {
        return false;
    }

    public static boolean isFilterableDCM(ColorModel colorModel) {
        return false;
    }

    public static boolean isMaskOK(int n, boolean bl) {
        return false;
    }

    public static ColorModel getInternedColorModel(ColorModel colorModel) {
        return null;
    }

    TexturePaintContext(ColorModel colorModel, AffineTransform affineTransform, int n, int n2, int n3) {
        this.colorModel = TexturePaintContext.getInternedColorModel(colorModel);
        this.bWidth = n;
        this.bHeight = n2;
        this.maxWidth = n3;
        try {
            affineTransform = affineTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            affineTransform.setToScale(0.0, 0.0);
        }
        this.incXAcross = TexturePaintContext.mod(affineTransform.getScaleX(), n);
        this.incYAcross = TexturePaintContext.mod(affineTransform.getShearY(), n2);
        this.incXDown = TexturePaintContext.mod(affineTransform.getShearX(), n);
        this.incYDown = TexturePaintContext.mod(affineTransform.getScaleY(), n2);
        this.xOrg = affineTransform.getTranslateX();
        this.yOrg = affineTransform.getTranslateY();
        this.colincx = (int)this.incXAcross;
        this.colincy = (int)this.incYAcross;
        this.colincxerr = TexturePaintContext.fractAsInt(this.incXAcross);
        this.colincyerr = TexturePaintContext.fractAsInt(this.incYAcross);
        this.rowincx = (int)this.incXDown;
        this.rowincy = (int)this.incYDown;
        this.rowincxerr = TexturePaintContext.fractAsInt(this.incXDown);
        this.rowincyerr = TexturePaintContext.fractAsInt(this.incYDown);
    }

    static int fractAsInt(double d) {
        return 0;
    }

    static double mod(double d, double d2) {
        return 0.0;
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return null;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        return null;
    }

    static synchronized WritableRaster makeRaster(ColorModel colorModel, Raster raster, int n, int n2) {
        return null;
    }

    static synchronized void dropRaster(ColorModel colorModel, Raster raster) {
    }

    static synchronized WritableRaster makeByteRaster(Raster raster, int n, int n2) {
        return null;
    }

    static synchronized void dropByteRaster(Raster raster) {
    }

    public abstract WritableRaster makeRaster(int var1, int var2);

    public abstract void setRaster(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16);

    public static int blend(int[] nArray, int n, int n2) {
        return 0;
    }

    static class Any
    extends TexturePaintContext {
        WritableRaster srcRas;
        boolean filter;

        public Any(WritableRaster writableRaster, ColorModel colorModel, AffineTransform affineTransform, int n, boolean bl) {
            super(colorModel, affineTransform, writableRaster.getWidth(), writableRaster.getHeight(), n);
            this.srcRas = writableRaster;
            this.filter = bl;
        }

        public WritableRaster makeRaster(int n, int n2) {
            return null;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        }
    }

    static class Byte
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        byte[] inData;
        int inOff;
        int inSpan;
        byte[] outData;
        int outOff;
        int outSpan;

        public Byte(ByteInterleavedRaster byteInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n) {
            super(colorModel, affineTransform, byteInterleavedRaster.getWidth(), byteInterleavedRaster.getHeight(), n);
            this.srcRas = byteInterleavedRaster;
            this.inData = byteInterleavedRaster.getDataStorage();
            this.inSpan = byteInterleavedRaster.getScanlineStride();
            this.inOff = byteInterleavedRaster.getDataOffset(0);
        }

        public WritableRaster makeRaster(int n, int n2) {
            return null;
        }

        public void dispose() {
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        }
    }

    static class ByteFilter
    extends TexturePaintContext {
        ByteInterleavedRaster srcRas;
        int[] inPalette = new int[256];
        byte[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;

        public ByteFilter(ByteInterleavedRaster byteInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n) {
            super(colorModel.getTransparency() == 1 ? xrgbmodel : argbmodel, affineTransform, byteInterleavedRaster.getWidth(), byteInterleavedRaster.getHeight(), n);
            ((IndexColorModel)colorModel).getRGBs(this.inPalette);
            this.srcRas = byteInterleavedRaster;
            this.inData = byteInterleavedRaster.getDataStorage();
            this.inSpan = byteInterleavedRaster.getScanlineStride();
            this.inOff = byteInterleavedRaster.getDataOffset(0);
        }

        public WritableRaster makeRaster(int n, int n2) {
            return null;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        }
    }

    static class Int
    extends TexturePaintContext {
        IntegerInterleavedRaster srcRas;
        int[] inData;
        int inOff;
        int inSpan;
        int[] outData;
        int outOff;
        int outSpan;
        boolean filter;

        public Int(IntegerInterleavedRaster integerInterleavedRaster, ColorModel colorModel, AffineTransform affineTransform, int n, boolean bl) {
            super(colorModel, affineTransform, integerInterleavedRaster.getWidth(), integerInterleavedRaster.getHeight(), n);
            this.srcRas = integerInterleavedRaster;
            this.inData = integerInterleavedRaster.getDataStorage();
            this.inSpan = integerInterleavedRaster.getScanlineStride();
            this.inOff = integerInterleavedRaster.getDataOffset(0);
            this.filter = bl;
        }

        public WritableRaster makeRaster(int n, int n2) {
            return null;
        }

        public void setRaster(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16) {
        }
    }
}

