/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import sun.font.Font2D;
import sun.font.Font2DHandle;
import sun.font.FontLineMetrics;
import sun.font.FontManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Serializable {
    private Hashtable fRequestedAttributes;
    private static final Map EMPTY_MAP;
    private static final TransformAttribute IDENT_TX_ATTRIBUTE;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int TYPE1_FONT = 1;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private transient FontPeer peer;
    private transient long pData;
    private transient Font2DHandle font2DHandle;
    private transient int superscript;
    private transient float width = 1.0f;
    private transient boolean createdFont = false;
    private transient double[] matrix;
    private transient boolean nonIdentityTx;
    private static final AffineTransform identityTx;
    private static final long serialVersionUID = -4206021311591459213L;
    private static SoftReference cacheRef;
    private static final float[] ssinfo;
    private int fontSerializedDataVersion = 1;
    private static double[] cachedMat;
    private transient SoftReference flmref;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;

    @Deprecated
    public FontPeer getPeer() {
        return null;
    }

    final FontPeer getPeer_NoClientCode() {
        return null;
    }

    private Hashtable getRequestedAttributes() {
        return null;
    }

    private void initializeFont(Hashtable hashtable) {
    }

    private Font2D getFont2D() {
        return null;
    }

    private Font2DHandle getFont2DHandleForCreatedFont() {
        return null;
    }

    public Font(String string, int n, int n2) {
        this.name = string != null ? string : "Default";
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = n2;
        this.pointSize = n2;
    }

    private Font(String string, int n, float f) {
        this.name = string != null ? string : "Default";
        this.style = (n & 0xFFFFFFFC) == 0 ? n : 0;
        this.size = (int)((double)f + 0.5);
        this.pointSize = f;
    }

    private Font(File file, int n, boolean bl) throws FontFormatException {
        this.createdFont = true;
        this.font2DHandle = FontManager.createFont2D((File)file, (int)n, (boolean)bl).handle;
        this.name = this.font2DHandle.font2D.getFontName(Locale.getDefault());
        this.style = 0;
        this.size = 1;
        this.pointSize = 1.0f;
    }

    private Font(Map map, boolean bl, Font2DHandle font2DHandle) {
        this.createdFont = bl;
        if (bl) {
            this.font2DHandle = font2DHandle;
        }
        this.initFromMap(map);
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        this.initFromMap(map);
    }

    private void initFromMap(Map map) {
    }

    public static Font getFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        return null;
    }

    private static Font get(Key key) {
        return null;
    }

    public static Font createFont(int n, InputStream inputStream) throws FontFormatException, IOException {
        return null;
    }

    public static Font createFont(int n, File file) throws FontFormatException, IOException {
        return null;
    }

    public AffineTransform getTransform() {
        return null;
    }

    public String getFamily() {
        return null;
    }

    final String getFamily_NoClientCode() {
        return null;
    }

    public String getFamily(Locale locale) {
        return null;
    }

    public String getPSName() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getFontName() {
        return null;
    }

    public String getFontName(Locale locale) {
        return null;
    }

    public int getStyle() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public float getSize2D() {
        return 0.0f;
    }

    public boolean isPlain() {
        return false;
    }

    public boolean isBold() {
        return false;
    }

    public boolean isItalic() {
        return false;
    }

    public boolean isTransformed() {
        return false;
    }

    public static Font getFont(String string) {
        return null;
    }

    public static Font decode(String string) {
        return null;
    }

    public static Font getFont(String string, Font font) {
        return null;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }

    public String toString() {
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }

    public int getNumGlyphs() {
        return 0;
    }

    public int getMissingGlyphCode() {
        return 0;
    }

    private double[] getMatrix() {
        return null;
    }

    public byte getBaselineFor(char c) {
        return 0;
    }

    public Map<TextAttribute, ?> getAttributes() {
        return null;
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        return null;
    }

    public Font deriveFont(int n, float f) {
        return null;
    }

    public Font deriveFont(int n, AffineTransform affineTransform) {
        return null;
    }

    public Font deriveFont(float f) {
        return null;
    }

    public Font deriveFont(AffineTransform affineTransform) {
        return null;
    }

    public Font deriveFont(int n) {
        return null;
    }

    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> map) {
        return null;
    }

    public boolean canDisplay(char c) {
        return false;
    }

    public boolean canDisplay(int n) {
        return false;
    }

    public int canDisplayUpTo(String string) {
        return 0;
    }

    public int canDisplayUpTo(char[] cArray, int n, int n2) {
        return 0;
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n, int n2) {
        return 0;
    }

    public float getItalicAngle() {
        return 0.0f;
    }

    public boolean hasUniformLineMetrics() {
        return false;
    }

    private FontLineMetrics defaultLineMetrics(FontRenderContext fontRenderContext) {
        return null;
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        return null;
    }

    public LineMetrics getLineMetrics(String string, int n, int n2, FontRenderContext fontRenderContext) {
        return null;
    }

    public LineMetrics getLineMetrics(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        return null;
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return null;
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        return null;
    }

    public Rectangle2D getStringBounds(String string, int n, int n2, FontRenderContext fontRenderContext) {
        return null;
    }

    public Rectangle2D getStringBounds(char[] cArray, int n, int n2, FontRenderContext fontRenderContext) {
        return null;
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n, int n2, FontRenderContext fontRenderContext) {
        return null;
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        return null;
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return null;
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return null;
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return null;
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return null;
    }

    public GlyphVector layoutGlyphVector(FontRenderContext fontRenderContext, char[] cArray, int n, int n2, int n3) {
        return null;
    }

    private static void applyTransform(AffineTransform affineTransform, Map map) {
    }

    private static void applyStyle(int n, Map map) {
    }

    private static void applySize(float f, Map map) {
    }

    private static native void initIDs();

    private native void pDispose();

    protected void finalize() throws Throwable {
    }

    private static class Key {
        String family = "Dialog";
        float weight = 1.0f;
        float posture = 0.0f;
        float size = 12.0f;
        int superscript = 0;
        float width = 1.0f;
        double[] txdata = null;
        Map attrs;
        int hashCode = 0;

        Key(Map map) {
            float f;
            this.attrs = map;
            Object v = map.get(TextAttribute.FAMILY);
            if (v != null) {
                this.family = (String)v;
            }
            this.hashCode = this.family.hashCode();
            v = map.get(TextAttribute.WEIGHT);
            if (v != null && v != TextAttribute.WEIGHT_REGULAR && (f = ((Float)v).floatValue()) == TextAttribute.WEIGHT_BOLD.floatValue()) {
                this.weight = f;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.weight);
            }
            if ((v = map.get(TextAttribute.POSTURE)) != null && v != TextAttribute.POSTURE_REGULAR && (f = ((Float)v).floatValue()) == TextAttribute.POSTURE_OBLIQUE.floatValue()) {
                this.posture = f;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.posture);
            }
            if ((v = map.get(TextAttribute.SIZE)) != null) {
                this.size = ((Float)v).floatValue();
                if (this.size != 12.0f) {
                    this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.size);
                }
            }
            if ((v = map.get(TextAttribute.TRANSFORM)) != null) {
                AffineTransform affineTransform;
                AffineTransform affineTransform2 = null;
                if (v instanceof TransformAttribute) {
                    TransformAttribute transformAttribute = (TransformAttribute)v;
                    if (!transformAttribute.isIdentity()) {
                        affineTransform2 = transformAttribute.getTransform();
                    }
                } else if (v instanceof AffineTransform && !(affineTransform = (AffineTransform)v).isIdentity()) {
                    affineTransform2 = affineTransform;
                }
                if (affineTransform2 != null) {
                    this.txdata = new double[6];
                    affineTransform2.getMatrix(this.txdata);
                    this.hashCode = this.hashCode << 3 ^ new Double(this.txdata[0]).hashCode();
                }
            }
            if ((v = map.get(TextAttribute.SUPERSCRIPT)) != null && v instanceof Integer) {
                this.superscript = (Integer)v;
                this.hashCode = this.hashCode << 3 ^ this.superscript;
            }
            if ((v = map.get(TextAttribute.WIDTH)) != null && v instanceof Float) {
                this.width = ((Float)v).floatValue();
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.width);
            }
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object object) {
            return false;
        }
    }
}

