/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import com.sun.javafx.runtime.annotation.Def;
import com.sun.javafx.runtime.annotation.Inherited;
import com.sun.javafx.runtime.annotation.Package;
import com.sun.javafx.runtime.annotation.Protected;
import com.sun.javafx.runtime.annotation.Public;
import com.sun.javafx.runtime.annotation.PublicInitable;
import com.sun.javafx.runtime.annotation.PublicReadable;
import com.sun.javafx.runtime.annotation.SourceName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javafx.reflect.FXFunctionType;
import javafx.reflect.FXJavaArrayType;
import javafx.reflect.FXLocal;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceType;
import javafx.reflect.FXType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlatformUtils {
    PlatformUtils() {
    }

    static Type[] getGenericParameterTypes(Method m) {
        return m.getGenericParameterTypes();
    }

    static Type getGenericReturnType(Method m) {
        return m.getGenericReturnType();
    }

    static boolean isSynthetic(Field fld) {
        return fld.isSynthetic();
    }

    static boolean isSynthetic(Method m) {
        return m.isSynthetic();
    }

    static int checkInherited(Method m) {
        return m.getAnnotation(Inherited.class) != null ? 1 : 0;
    }

    static String getCanonicalName(Class cls) {
        return cls.getCanonicalName();
    }

    static String getSourceNameFromAnnotation(Field fld) {
        SourceName sname = fld.getAnnotation(SourceName.class);
        return sname == null ? null : sname.value();
    }

    static Annotation getAnnotation(FXLocal.ClassType ctype, Class clas) {
        Class cls = ctype.refClass;
        return cls.getAnnotation(clas);
    }

    static <T extends Annotation> T getAnnotation(FXLocal.VarMember vmem, Class<T> clas) {
        Field fld = vmem.fld;
        if (fld != null) {
            return fld.getAnnotation(clas);
        }
        Method getter = vmem.getter;
        if (getter != null) {
            return getter.getAnnotation(clas);
        }
        return null;
    }

    static int checkPublic(FXLocal.ClassType ctype) {
        if (ctype.isJfxType()) {
            return -1;
        }
        return PlatformUtils.getAnnotation(ctype, Public.class) != null ? 1 : 0;
    }

    static int checkPackage(FXLocal.ClassType ctype) {
        if (!ctype.isJfxType()) {
            return -1;
        }
        return PlatformUtils.getAnnotation(ctype, Package.class) != null ? 1 : 0;
    }

    static boolean isProtected(FXLocal.ClassType ctype) {
        return PlatformUtils.getAnnotation(ctype, Protected.class) != null;
    }

    static int checkAccess(FXLocal.VarMember vmem, Class ann) {
        if (!vmem.getDeclaringClass().isJfxType()) {
            return -1;
        }
        return PlatformUtils.getAnnotation(vmem, ann) != null ? 1 : 0;
    }

    static boolean checkAccessAnnotations(FXLocal.VarMember vmem) {
        if (PlatformUtils.getAnnotation(vmem, Public.class) != null) {
            vmem.flags |= 4;
        }
        if (PlatformUtils.getAnnotation(vmem, Protected.class) != null) {
            vmem.flags |= 8;
        }
        if (PlatformUtils.getAnnotation(vmem, Package.class) != null) {
            vmem.flags |= 0x10;
        }
        if (PlatformUtils.getAnnotation(vmem, PublicInitable.class) != null) {
            vmem.flags |= 0x20;
        }
        if (PlatformUtils.getAnnotation(vmem, PublicReadable.class) != null) {
            vmem.flags |= 0x40;
        }
        return true;
    }

    static int checkDef(FXLocal.VarMember vmem) {
        return PlatformUtils.checkAccess(vmem, Def.class);
    }

    static int checkAccess(FXLocal.FunctionMember fmem, Class ann) {
        if (!fmem.getDeclaringClass().isJfxType()) {
            return -1;
        }
        return fmem.method.getAnnotation(ann) != null ? 1 : 0;
    }

    static int checkPublic(FXLocal.FunctionMember fmem) {
        return PlatformUtils.checkAccess(fmem, Public.class);
    }

    static int checkProtected(FXLocal.FunctionMember fmem) {
        return PlatformUtils.checkAccess(fmem, Protected.class);
    }

    static int checkPackage(FXLocal.FunctionMember fmem) {
        return PlatformUtils.checkAccess(fmem, Package.class);
    }

    static Object resolveGeneric(FXLocal.Context context, Type typ) {
        String rawName;
        if (typ instanceof ParameterizedType) {
            ParameterizedType ptyp = (ParameterizedType)typ;
            Type raw = ptyp.getRawType();
            Type[] targs = ptyp.getActualTypeArguments();
            if (raw instanceof Class) {
                rawName = ((Class)raw).getName();
                if ("com.sun.javafx.runtime.sequence.Sequence".equals(rawName) && targs.length == 1) {
                    return new FXSequenceType(context.makeTypeRef(targs[0]));
                }
                if ("com.sun.javafx.runtime.location.ObjectVariable".equals(rawName) && targs.length == 1) {
                    return context.makeTypeRef(targs[0]);
                }
                if ("com.sun.javafx.runtime.location.SequenceVariable".equals(rawName) && targs.length == 1) {
                    return new FXSequenceType(context.makeTypeRef(targs[0]));
                }
                if (rawName.startsWith("com.sun.javafx.functions.Function")) {
                    FXType[] prtypes = new FXType[targs.length - 1];
                    int i = prtypes.length;
                    while (--i >= 0) {
                        prtypes[i] = context.makeTypeRef(targs[i + 1]);
                    }
                    FXType rettype = targs[0] == Void.class ? FXPrimitiveType.voidType : context.makeTypeRef(targs[0]);
                    return new FXFunctionType(prtypes, rettype);
                }
            }
            typ = raw;
        }
        if (typ instanceof WildcardType) {
            FXPrimitiveType ptype;
            WildcardType wtyp = (WildcardType)typ;
            Type[] upper = wtyp.getUpperBounds();
            Type[] lower = wtyp.getLowerBounds();
            Object object = typ = lower.length > 0 ? lower[0] : wtyp.getUpperBounds()[0];
            if (typ instanceof Class && (ptype = context.getPrimitiveType(rawName = ((Class)typ).getName())) != null) {
                return ptype;
            }
            return context.makeTypeRef((Type)typ);
        }
        if (typ instanceof GenericArrayType) {
            FXType elType = context.makeTypeRef(((GenericArrayType)typ).getGenericComponentType());
            return new FXJavaArrayType(elType);
        }
        if (typ instanceof TypeVariable) {
            typ = Object.class;
        }
        return typ;
    }
}

