/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXSequenceType;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;

public class FXSequenceValue
implements FXValue {
    FXValue[] values;
    int nvalues;
    FXValue sequence;
    FXSequenceType type;

    public FXSequenceValue(FXValue[] values, int nvalues, FXType elementType) {
        this.values = values;
        this.nvalues = nvalues;
        this.type = new FXSequenceType(elementType);
    }

    protected FXSequenceValue(int nvalues, FXSequenceType type) {
        this.nvalues = nvalues;
        this.type = type;
    }

    public int getItemCount() {
        return this.nvalues;
    }

    public boolean isNull() {
        return this.nvalues == 0;
    }

    public FXValue getItem(int index) {
        return index >= 0 && index < this.nvalues ? this.values[index] : null;
    }

    public FXSequenceType getType() {
        return this.type;
    }

    public String getValueString() {
        if (this.nvalues == 0) {
            return "";
        }
        String str0 = this.getItem(0).getValueString();
        if (this.nvalues == 1) {
            return str0;
        }
        StringBuilder buf = new StringBuilder(str0);
        for (int i = 1; i < this.nvalues; ++i) {
            buf.append(' ');
            buf.append(this.getItem(i).getValueString());
        }
        return buf.toString();
    }
}

