/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import com.sun.javafx.functions.Function;
import com.sun.javafx.runtime.FXBase;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import javafx.reflect.FXChangeListener;
import javafx.reflect.FXChangeListenerID;
import javafx.reflect.FXClassType;
import javafx.reflect.FXContext;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXFunctionType;
import javafx.reflect.FXFunctionValue;
import javafx.reflect.FXJavaArrayType;
import javafx.reflect.FXLocation;
import javafx.reflect.FXMemberFilter;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceType;
import javafx.reflect.FXSequenceValue;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;
import javafx.reflect.FXVarMember;
import javafx.reflect.FXVarMemberLocation;
import javafx.reflect.PlatformUtils;

public class FXLocal {
    public static Context getContext() {
        return Context.instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends FXClassType {
        Class refClass;
        Class refInterface;
        protected static int VOFF_INITIALIZED = 65536;
        static final String[] SYSTEM_METHOD_EXCLUDES = new String[]{"addDependent$", "complete$", "count$", "getAsBoolean$", "getAsByte$", "getAsChar$", "getAsDouble$", "getAsFloat$", "getAsInt$", "getAsLong$", "getAsShort$", "getDepChain$internal$", "getThisRef$internal$", "getListenerCount$", "getType$", "initialize$", "isInitialized$", "javafx$run$", "makeInitMap$", "notifyDependents$", "postInit$", "printBits$", "printBitsAction$", "removeDependent$", "restrictSet$", "setDepChain$internal$", "setThisRef$internal$", "switchDependence$", "userInit$", "getFlags$", "setFlags$", "varChangeBits$", "varTestBits$", "VCNT$"};
        static final String[] SYSTEM_METHOD_PREFIXES = new String[]{"applyDefaults$", "get$", "elem$", "initVars$", "invalidate$", "invoke$", "onReplace$", "seq$", "set$", "size$", "update$", "DCNT$", "DEP$", "FCNT$", "GETMAP$", "VOFF$"};
        static final String[] SYSTEM_METHOD_SUFFIXES = new String[]{"$impl"};
        static Object[] NO_ARGS = new Object[0];
        static final String[] SYSTEM_VAR_PREFIXES = new String[]{"DCNT$", "DEP$", "FCNT$", "VFLG$", "VCNT$", "VOFF$", "MAP$", "$script$"};
        VarMember[] variables;

        public ClassType(Context context, int modifiers, Class refClass, Class refInterface) {
            super(context, modifiers);
            this.refClass = refClass;
            this.refInterface = refInterface;
            this.name = PlatformUtils.getCanonicalName(refClass);
        }

        public Class getJavaImplementationClass() {
            return this.refClass;
        }

        public Class getJavaInterfaceClass() {
            return this.refInterface;
        }

        @Override
        public Context getReflectionContext() {
            return (Context)super.getReflectionContext();
        }

        @Override
        public int hashCode() {
            return (this.name != null ? this.name : this.refClass.getName()).hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ClassType && this.refClass == ((ClassType)obj).refClass;
        }

        void getSuperClasses(boolean all, SortedClassArray result) {
            ClassType cl;
            Class s;
            boolean isMixin = this.isMixin();
            Class cls = isMixin ? this.refInterface : this.refClass;
            Class<?>[] interfaces = cls.getInterfaces();
            Context context = this.getReflectionContext();
            if (!isMixin && (s = cls.getSuperclass()) != null && result.insert(cl = context.makeClassRef(s)) && all) {
                cl.getSuperClasses(all, result);
            }
            for (int i = 0; i < interfaces.length; ++i) {
                ClassType cl2;
                Class<?> iface = interfaces[i];
                String iname = iface.getName();
                if (iname.equals("com.sun.javafx.runtime.FXObject") || iname.equals("com.sun.javafx.runtime.FXMixin") || !result.insert(cl2 = context.makeClassRef(iface)) || !all) continue;
                cl2.getSuperClasses(all, result);
            }
        }

        @Override
        public List<FXClassType> getSuperClasses(boolean all) {
            SortedClassArray result = new SortedClassArray();
            if (all) {
                result.insert(this);
            }
            this.getSuperClasses(all, result);
            return result;
        }

        @Override
        public FXFunctionMember getFunction(String name, FXType ... argType) {
            int nargs = argType.length;
            Class[] ctypes = new Class[nargs];
            for (int i = 0; i < nargs; ++i) {
                ctypes[i] = Context.asClass(argType[i]);
            }
            try {
                Method meth;
                try {
                    meth = this.refClass.getMethod(name, ctypes);
                }
                catch (NoSuchMethodException ex) {
                    if (this.isMixin()) {
                        meth = null;
                    }
                    throw ex;
                }
                if (this.isMixin() && (meth == null || (meth.getModifiers() & 8) == 0)) {
                    meth = this.refInterface.getMethod(name, ctypes);
                }
                return this.asFunctionMember(meth, this.getReflectionContext());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        private Method[] filter(Method[] methods, Class declaringClass) {
            ArrayList<Method> result = new ArrayList<Method>();
            for (Method m : methods) {
                if (m.getDeclaringClass() != declaringClass) continue;
                result.add(m);
            }
            return result.toArray(new Method[0]);
        }

        @Override
        protected void getFunctions(FXMemberFilter filter, FXClassType.SortedMemberArray<? super FXFunctionMember> result) {
            Method[] methods;
            Class cls = this.refClass;
            Context context = this.getReflectionContext();
            try {
                methods = cls.getDeclaredMethods();
            }
            catch (SecurityException e) {
                methods = this.filter(cls.getMethods(), cls);
            }
            block4: for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (PlatformUtils.isSynthetic(m) || PlatformUtils.checkInherited(m) > 0) continue;
                String mname = m.getName();
                for (String exclude : SYSTEM_METHOD_EXCLUDES) {
                    if (mname.equals(exclude)) continue block4;
                }
                for (String prefix : SYSTEM_METHOD_PREFIXES) {
                    if (mname.startsWith(prefix)) continue block4;
                }
                for (String suffix : SYSTEM_METHOD_SUFFIXES) {
                    if (mname.endsWith(suffix)) continue block4;
                }
                if (this.isMixin()) {
                    try {
                        m = this.refInterface.getDeclaredMethod(m.getName(), m.getParameterTypes());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                FXFunctionMember mref = this.asFunctionMember(m, context);
                if (filter == null || !filter.accept(mref)) continue;
                result.insert(mref);
            }
        }

        FXFunctionMember asFunctionMember(Method m, Context context) {
            Type[] ptypes = PlatformUtils.getGenericParameterTypes(m);
            FXType[] prtypes = new FXType[ptypes.length];
            for (int j = 0; j < ptypes.length; ++j) {
                prtypes[j] = context.makeTypeRef(ptypes[j]);
            }
            Type gret = PlatformUtils.getGenericReturnType(m);
            FXFunctionType type = new FXFunctionType(prtypes, context.makeTypeRef(gret));
            return new FunctionMember(m, this, type);
        }

        private Field[] filter(Field[] fields, Class declaringClass) {
            ArrayList<Field> result = new ArrayList<Field>();
            for (Field f : fields) {
                if (f.getDeclaringClass() != declaringClass) continue;
                result.add(f);
            }
            return result.toArray(new Field[0]);
        }

        protected static Method getMethodOrNull(Class cls, String name, Class ... types) {
            Method method = null;
            try {
                method = cls.getMethod(name, types);
            }
            catch (Throwable ex) {
                // empty catch block
            }
            return method;
        }

        protected static int callMethodIntOrDefault(Method method, int deflt) {
            if (method != null) {
                try {
                    deflt = (Integer)method.invoke(null, NO_ARGS);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return deflt;
        }

        private void ensureVOffInitialized() {
            if ((this.modifiers & VOFF_INITIALIZED) == 0) {
                try {
                    this.refClass.getMethod("VCNT$", new Class[0]).invoke(null, NO_ARGS);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.modifiers |= VOFF_INITIALIZED;
            }
        }

        @Override
        protected void getVariables(FXMemberFilter filter, FXClassType.SortedMemberArray<? super FXVarMember> result) {
            Field[] fields;
            VarMember[] varTable = this.variables;
            if (varTable != null) {
                String requiredName = filter.getRequiredName();
                if (requiredName != null) {
                    VarMember v = varTable[ClassType.searchVariable(varTable, requiredName)];
                    if (v != null) {
                        result.insert(v);
                    }
                } else {
                    int i = varTable.length;
                    while (--i >= 0) {
                        VarMember v = varTable[i];
                        if (v == null || !filter.accept(v)) continue;
                        result.insert(v);
                    }
                }
                return;
            }
            Context ctxt = this.getReflectionContext();
            Class cls = this.refClass;
            ArrayList<VarMember> varList = new ArrayList<VarMember>();
            try {
                fields = cls.getDeclaredFields();
            }
            catch (SecurityException e) {
                fields = this.filter(cls.getFields(), cls);
            }
            block5: for (Field fld : fields) {
                int offset;
                if (PlatformUtils.isSynthetic(fld)) continue;
                String fname = fld.getName();
                String sname = PlatformUtils.getSourceNameFromAnnotation(fld);
                if (sname == null) {
                    int dollar = fname.lastIndexOf(36);
                    if (dollar == -1) {
                        sname = fname;
                    } else {
                        for (String prefix : SYSTEM_VAR_PREFIXES) {
                            if (fname.startsWith(prefix)) continue block5;
                        }
                        if (fname.endsWith("$internal$")) continue;
                        sname = fname.substring(dollar + 1);
                    }
                }
                FXType tr = ctxt.makeTypeRef(fld.getGenericType());
                this.ensureVOffInitialized();
                try {
                    Field field = cls.getField("VOFF" + fname);
                    offset = field.getInt(null);
                }
                catch (Throwable ex) {
                    offset = -1;
                }
                VarMember ref = new VarMember(sname, this, tr, offset);
                ref.fld = fld;
                varList.add(ref);
                if (filter == null || !filter.accept(ref)) continue;
                result.insert(ref);
            }
            int nvars = varList.size();
            int varTableSize = 8;
            while (4 * nvars > 3 * varTableSize) {
                varTableSize += varTableSize;
            }
            varTable = new VarMember[varTableSize];
            while (--nvars >= 0) {
                VarMember v;
                varTable[ClassType.searchVariable((VarMember[])varTable, (String)v.name)] = v = (VarMember)varList.get(nvars);
            }
            this.variables = varTable;
        }

        static int searchVariable(VarMember[] variables, String name) {
            int hash = name.hashCode();
            int size = variables.length;
            int h = 12347 * hash + hash;
            int mask = size - 1;
            int i = h & mask;
            VarMember v;
            while ((v = variables[i]) != null && !v.name.equals(name)) {
                i = i + 53 & mask;
            }
            return i;
        }

        @Override
        public ObjectValue allocate() {
            Class cls = this.refClass;
            Context context = this.getReflectionContext();
            try {
                Object instance;
                if (this.isJfxType()) {
                    Class[] types = new Class[]{Boolean.TYPE};
                    Constructor cons = cls.getDeclaredConstructor(types);
                    Object[] args = new Object[]{Boolean.TRUE};
                    instance = cons.newInstance(args);
                } else {
                    instance = cls.newInstance();
                }
                return new ObjectValue(instance, this);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public FXClassType getDeclaringClass() {
            return null;
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        Annotation getAnnotation(Class clas) {
            Class cls = this.refClass;
            return cls.getAnnotation(clas);
        }

        @Override
        public boolean isPublic() {
            int p = PlatformUtils.checkPublic(this);
            if (p >= 0) {
                return p > 0;
            }
            Class cls = this.refClass;
            return (cls.getModifiers() & 1) != 0;
        }

        @Override
        public boolean isProtected() {
            return PlatformUtils.isProtected(this);
        }

        @Override
        public boolean isPackage() {
            int p = PlatformUtils.checkPackage(this);
            if (p >= 0) {
                return p > 0;
            }
            Class cls = this.refClass;
            return (cls.getModifiers() & 1) == 0;
        }
    }

    public static class Context
    extends FXContext {
        static Context instance = new Context();
        static final String LOCATION_PREFIX = "com.sun.javafx.runtime.location.";
        static final int LOCATION_PREFIX_LENGTH = "com.sun.javafx.runtime.location.".length();
        static final String VARIABLE_STRING = "Variable";
        static final int VARIABLE_STRING_LENGTH = "Variable".length();

        private Context() {
        }

        public static Context getInstance() {
            return instance;
        }

        public ObjectValue mirrorOf(Object obj) {
            return new ObjectValue(obj, this);
        }

        public Value mirrorOf(Object val, FXType type) {
            if (type instanceof ClassType) {
                return new ObjectValue(val, (ClassType)type);
            }
            if (type instanceof FXPrimitiveType) {
                return ((FXPrimitiveType)type).mirrorOf(val);
            }
            if (type instanceof FXSequenceType && val instanceof Sequence) {
                Sequence seq = (Sequence)val;
                return new SequenceValue(seq, (FXSequenceType)type, this);
            }
            if (type instanceof FXFunctionType && val instanceof Function) {
                FXFunctionType ftype = (FXFunctionType)type;
                return new FunctionValue((Function)val, ftype, this);
            }
            return new MiscValue(val, type);
        }

        public ObjectValue mirrorOf(String val) {
            return new ObjectValue((Object)val, this);
        }

        public ClassType findClass(String cname) {
            ClassLoader loader;
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException ex) {
                loader = this.getClass().getClassLoader();
            }
            return this.findClass(cname, loader);
        }

        public ClassType findClass(String cname, ClassLoader loader) {
            String n = cname;
            Exception ex0 = null;
            while (true) {
                try {
                    Class<?> cl = Class.forName(n, false, loader);
                    return this.makeClassRef(cl);
                }
                catch (Exception ex) {
                    int dot;
                    if (ex0 == null) {
                        ex0 = ex;
                    }
                    if ((dot = n.lastIndexOf(46)) >= 0) {
                        n = n.substring(0, dot) + '$' + n.substring(dot + 1);
                        continue;
                    }
                    throw new RuntimeException(ex0);
                }
                break;
            }
        }

        public FXType makeTypeRef(Type typ) {
            Object t = PlatformUtils.resolveGeneric(this, typ);
            if (t instanceof FXType) {
                return (FXType)t;
            }
            Class clas = (Class)t;
            if (clas.isArray()) {
                FXType elType = this.makeTypeRef(clas.getComponentType());
                return new FXJavaArrayType(elType);
            }
            String rawName = clas.getName();
            int rawLength = rawName.length();
            if (rawLength > LOCATION_PREFIX_LENGTH + VARIABLE_STRING_LENGTH && rawName.startsWith(LOCATION_PREFIX) && rawName.endsWith(VARIABLE_STRING)) {
                FXPrimitiveType ptype;
                if ((rawName = rawName.substring(LOCATION_PREFIX_LENGTH, rawLength - VARIABLE_STRING_LENGTH)).endsWith("Sequence")) {
                    FXPrimitiveType ptype2;
                    int newLength = rawName.length() - "Sequence".length();
                    if (newLength != 0) {
                        rawName = rawName.substring(0, newLength - 1);
                    }
                    if ((ptype2 = this.getPrimitiveType(rawName)) != null) {
                        return new FXSequenceType(ptype2);
                    }
                }
                if ((ptype = this.getPrimitiveType(rawName)) != null) {
                    return ptype;
                }
            }
            if (typ == Byte.TYPE) {
                return FXPrimitiveType.byteType;
            }
            if (typ == Short.TYPE) {
                return FXPrimitiveType.shortType;
            }
            if (typ == Integer.TYPE) {
                return FXPrimitiveType.integerType;
            }
            if (typ == Long.TYPE) {
                return FXPrimitiveType.longType;
            }
            if (typ == Float.TYPE) {
                return FXPrimitiveType.floatType;
            }
            if (typ == Double.TYPE) {
                return FXPrimitiveType.doubleType;
            }
            if (typ == Character.TYPE) {
                return FXPrimitiveType.charType;
            }
            if (typ == Boolean.TYPE) {
                return FXPrimitiveType.booleanType;
            }
            if (typ == Void.TYPE) {
                return FXPrimitiveType.voidType;
            }
            return this.makeClassRef(clas);
        }

        public ClassType makeClassRef(Class cls) {
            int modifiers = 0;
            try {
                Class<?>[] interfaces = cls.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    String iname = interfaces[i].getName();
                    if (iname.equals("com.sun.javafx.runtime.FXObject")) {
                        modifiers |= 2;
                        continue;
                    }
                    if (!iname.equals("com.sun.javafx.runtime.FXMixin")) continue;
                    modifiers |= 1;
                }
                Class<?> clsInterface = null;
                if (modifiers & true) {
                    String cname = cls.getName();
                    if (cname.endsWith("$Mixin")) {
                        cname = cname.substring(0, cname.length() - "$Mixin".length());
                        clsInterface = cls;
                        if ((cls = Class.forName(cname, false, cls.getClassLoader())) == null) {
                            throw new RuntimeException("Missing mixin class " + cname);
                        }
                    } else {
                        String intfName = cname + "$Mixin";
                        clsInterface = Class.forName(intfName, false, cls.getClassLoader());
                        if (clsInterface == null) {
                            throw new RuntimeException("Missing mixin interface " + intfName);
                        }
                    }
                }
                return new ClassType(this, modifiers, cls, clsInterface);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public static Class asClass(FXType type) {
            if (type instanceof FXPrimitiveType) {
                return ((FXPrimitiveType)type).clas;
            }
            if (type instanceof JavaArrayType) {
                return ((JavaArrayType)type).getJavaClass();
            }
            if (type instanceof FXSequenceType) {
                return Sequence.class;
            }
            ClassType ctyp = (ClassType)type;
            return ctyp.isMixin() ? ctyp.refInterface : ctyp.refClass;
        }

        public Value makeSequenceValue(FXValue[] values, int nvalues, FXType elementType) {
            return new SequenceValue(values, nvalues, elementType, this);
        }
    }

    static class FunctionMember
    extends FXFunctionMember {
        Method method;
        FXClassType owner;
        String name;
        FXFunctionType type;

        FunctionMember(Method method, ClassType owner, FXFunctionType type) {
            this.method = method;
            this.owner = owner;
            this.name = method.getName();
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public FXClassType getDeclaringClass() {
            return this.owner;
        }

        public boolean isStatic() {
            return (this.method.getModifiers() & 8) != 0;
        }

        public FXFunctionType getType() {
            return this.type;
        }

        Object unwrap(FXValue value) {
            if (value == null) {
                return null;
            }
            return ((Value)value).asObject();
        }

        public FXValue invoke(FXObjectValue obj, FXValue ... arg) {
            int alen = arg.length;
            Object[] rargs = new Object[alen];
            for (int i = 0; i < alen; ++i) {
                rargs[i] = this.unwrap(arg[i]);
            }
            try {
                Object result = this.method.invoke(this.unwrap(obj), rargs);
                Context context = (Context)this.owner.getReflectionContext();
                if (result == null && this.getType().getReturnType() == FXPrimitiveType.voidType) {
                    return null;
                }
                return context.mirrorOf(result, this.getType().getReturnType());
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean isPublic() {
            int p = PlatformUtils.checkPublic(this);
            if (p >= 0) {
                return p > 0;
            }
            return (this.method.getModifiers() & 1) != 0;
        }

        public boolean isProtected() {
            int p = PlatformUtils.checkProtected(this);
            if (p >= 0) {
                return p > 0;
            }
            return (this.method.getModifiers() & 4) != 0;
        }

        public boolean isPackage() {
            int mask;
            int p = PlatformUtils.checkPackage(this);
            if (p >= 0) {
                return p > 0;
            }
            int mods = this.method.getModifiers();
            return (mods & (mask = 7)) == 0;
        }
    }

    public static class FunctionValue
    extends FXFunctionValue
    implements Value {
        Function val;
        FXFunctionType ftype;
        Context context;

        public FunctionValue(Function val, FXFunctionType ftype, Context context) {
            this.val = val;
            this.ftype = ftype;
            this.context = context;
        }

        public FXValue apply(FXValue ... arg) {
            int nargs = arg.length;
            if (nargs > 8) {
                throw new IllegalArgumentException();
            }
            Object[] rargs = nargs > 2 ? new Object[nargs] : null;
            Object arg1 = null;
            Object arg2 = null;
            for (int i = 0; i < nargs; ++i) {
                Object targ = ((Value)arg[i]).asObject();
                if (i == 0) {
                    arg1 = targ;
                    continue;
                }
                if (i == 1) {
                    arg2 = targ;
                    continue;
                }
                rargs[i - 2] = targ;
            }
            Object result = this.val.invoke$(arg1, arg2, rargs);
            return this.context.mirrorOf(result, this.ftype.getReturnType());
        }

        public FXFunctionType getType() {
            return this.ftype;
        }

        public boolean isNull() {
            return false;
        }

        public String getValueString() {
            return this.ftype.toString() + "{...}";
        }

        public Function asObject() {
            return this.val;
        }
    }

    static class JavaArrayType
    extends FXJavaArrayType {
        Class cls;

        JavaArrayType(FXType componentType, Class cls) {
            super(componentType);
            this.cls = cls;
        }

        public Class getJavaClass() {
            return this.cls;
        }
    }

    static class MiscValue
    implements Value {
        Object val;
        FXType type;

        public MiscValue(Object value, FXType type) {
            this.val = value;
            this.type = type;
        }

        public String getValueString() {
            return this.val == null ? "(null)" : this.val.toString();
        }

        public FXType getType() {
            return this.type;
        }

        public boolean isNull() {
            return this.val == null;
        }

        public Object asObject() {
            return this.val;
        }

        public FXValue getItem(int index) {
            return this;
        }

        public int getItemCount() {
            return this.isNull() ? 0 : 1;
        }
    }

    public static class ObjectValue
    extends FXObjectValue
    implements Value {
        Object obj;
        ClassType type;
        ClassType classType;
        int count;
        FXVarMember[] initMembers;
        FXValue[] initValues;

        public ObjectValue(Object obj, Context context) {
            this.type = context.makeClassRef(obj.getClass());
            this.obj = obj;
            if (obj instanceof FXObject) {
                this.count = ((FXObject)obj).count$();
            }
        }

        public ObjectValue(Object obj, ClassType type) {
            this.type = type;
            this.obj = obj;
            if (obj instanceof FXObject) {
                this.count = ((FXObject)obj).count$();
            }
        }

        public FXClassType getType() {
            return this.type;
        }

        public FXClassType getClassType() {
            if (this.classType == null) {
                if (this.obj == null) {
                    this.classType = this.type;
                } else {
                    Class<?> cls = this.obj.getClass();
                    this.classType = this.type.getJavaImplementationClass() == cls ? this.type : this.type.getReflectionContext().makeClassRef(cls);
                }
            }
            return this.classType;
        }

        public boolean isNull() {
            return this.obj == null;
        }

        public String getValueString() {
            if (this.obj == null) {
                return null;
            }
            return this.obj.toString();
        }

        public ObjectValue initialize() {
            if (this.obj instanceof FXObject) {
                FXObject instance = (FXObject)this.obj;
                if (this.initMembers == null) {
                    instance.initialize$(true);
                } else {
                    int count = this.count();
                    instance.initVars$();
                    for (int offset = 0; offset < count; ++offset) {
                        instance.varChangeBits$(offset, 0, 8);
                        if (this.initMembers[offset] != null) {
                            this.initMembers[offset].setValue(this, this.initValues[offset]);
                            continue;
                        }
                        instance.applyDefaults$(offset);
                    }
                    instance.complete$();
                }
            }
            return this;
        }

        public Object asObject() {
            return this.obj;
        }

        private int count() {
            return this.obj instanceof FXObject ? ((FXObject)this.obj).count$() : 0;
        }

        public void initVar(FXVarMember attr, FXValue value) {
            int offset = attr.getOffset();
            if (offset == -1) {
                attr.setValue(this, value);
            } else {
                if (this.initMembers == null) {
                    int count = this.count();
                    this.initMembers = new FXVarMember[count];
                    this.initValues = new FXValue[count];
                }
                this.initMembers[offset] = attr;
                this.initValues[offset] = value;
                int flag = attr.getType() instanceof FXSequenceType ? 136 : 8;
                ((FXObject)this.obj).setFlags$(offset, flag);
            }
        }
    }

    static class SequenceValue
    extends FXSequenceValue
    implements Value {
        Sequence seq;
        Context context;

        public SequenceValue(FXValue[] values, int nvalues, FXType elementType, Context context) {
            super(values, nvalues, elementType);
            this.context = context;
        }

        public SequenceValue(Sequence seq, FXSequenceType sequenceType, Context context) {
            super(seq.size(), sequenceType);
            this.seq = seq;
            this.context = context;
        }

        public FXValue getItem(int index) {
            if (index < 0 || index >= this.nvalues) {
                return null;
            }
            if (this.values == null) {
                this.values = new FXValue[this.nvalues];
            }
            if (this.values[index] == null && this.seq != null) {
                this.values[index] = this.context.mirrorOf(this.seq.get(index), this.type.getComponentType());
            }
            return this.values[index];
        }

        public Sequence asObject() {
            if (this.seq == null) {
                FXType elementType = this.type.getComponentType();
                Object[] objs = new Object[this.nvalues];
                for (int i = 0; i < this.nvalues; ++i) {
                    objs[i] = ((Value)this.values[i]).asObject();
                }
                return Sequences.make(TypeInfo.getTypeInfo(Context.asClass(elementType)), objs);
            }
            return this.seq;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SortedClassArray
    extends AbstractList<FXClassType> {
        ClassType[] buffer = new ClassType[4];
        int sz;

        SortedClassArray() {
        }

        @Override
        public FXClassType get(int index) {
            if (index >= this.sz) {
                throw new IndexOutOfBoundsException();
            }
            return this.buffer[index];
        }

        @Override
        public int size() {
            return this.sz;
        }

        boolean insert(ClassType cl) {
            int i;
            String clname = cl.getName();
            for (i = 0; i < this.sz; ++i) {
                int cmp;
                ClassType c = this.buffer[i];
                String cname = c.getName();
                int n = cname == clname ? 0 : (cname == null ? -1 : (cmp = cname == null ? 1 : cname.compareTo(clname)));
                if (cmp > 0) break;
                if (cmp != 0) continue;
                if (c.refClass != cl.refClass) break;
                return false;
            }
            if (this.sz == this.buffer.length) {
                ClassType[] tmp = new ClassType[2 * this.sz];
                System.arraycopy(this.buffer, 0, tmp, 0, this.sz);
                this.buffer = tmp;
            }
            System.arraycopy(this.buffer, i, this.buffer, i + 1, this.sz - i);
            this.buffer[i] = cl;
            ++this.sz;
            return true;
        }
    }

    public static interface Value
    extends FXValue {
        public Object asObject();
    }

    static class VarMember
    extends FXVarMember {
        Field fld;
        Method getter;
        Method setter;
        FXType type;
        String name;
        ClassType owner;
        int offset;
        static final int GETTER_SETTER_SET = 1;
        static final int ACCESS_FLAGS_SET = 2;
        static final int IS_PUBLIC = 4;
        static final int IS_PROTECTED = 8;
        static final int IS_PACKAGE = 16;
        static final int IS_PUBLIC_INIT = 32;
        static final int IS_PUBLIC_READ = 64;
        int flags;
        static final Object[] noObjects = new Object[0];

        public VarMember(String name, ClassType owner, FXType type, int offset) {
            this.name = name;
            this.type = type;
            this.owner = owner;
            this.offset = offset;
        }

        public FXType getType() {
            return this.type;
        }

        public int getOffset() {
            return this.offset;
        }

        private void checkGetterSetter() {
            String set;
            String get;
            boolean isJfx;
            if ((this.flags & 1) != 0) {
                return;
            }
            Class cls = this.owner.refInterface;
            if (cls == null) {
                cls = this.owner.refClass;
            }
            if (isJfx = this.owner.isJfxType()) {
                get = "get$";
                set = "set$";
            } else {
                get = "get";
                set = "set";
            }
            Method g = ClassType.getMethodOrNull(cls, get + this.name, new Class[0]);
            String xname = this.name;
            if (g == null && isJfx) {
                xname = cls.getSimpleName() + "$" + this.name;
                g = ClassType.getMethodOrNull(cls, get + xname, new Class[0]);
            }
            this.getter = g;
            this.flags |= 1;
            if (g != null) {
                Class<?> rtype = g.getReturnType();
                this.setter = ClassType.getMethodOrNull(cls, set + xname, rtype);
            }
        }

        public FXValue getValue(FXObjectValue obj) {
            Object robj = obj == null ? null : ((ObjectValue)obj).obj;
            try {
                this.checkGetterSetter();
                if (this.fld != null || this.getter != null) {
                    Object val;
                    Context context = this.owner.getReflectionContext();
                    if (this.getter != null) {
                        val = this.getter.invoke(robj, new Object[0]);
                    } else {
                        this.fld.setAccessible(true);
                        val = this.fld.get(robj);
                    }
                    return context.mirrorOf(val, this.type);
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (this.fld != null) {
                    throw new RuntimeException("Illegal access of field " + this.fld);
                }
                throw new RuntimeException("Illegal access of field getter " + this.getter);
            }
            throw new UnsupportedOperationException("Not supported yet - " + this.type + "[" + this.type.getClass().getName() + "]");
        }

        public FXLocation getLocation(FXObjectValue obj) {
            return new VarMemberLocation(obj, this);
        }

        protected void initVar(FXObjectValue instance, FXValue value) {
            instance.initVar(this, value);
        }

        public void initValue(FXObjectValue instance, FXValue value) {
            instance.initVar(this, value);
        }

        public void setValue(FXObjectValue obj, FXValue value) {
            Object robj = obj == null ? null : ((ObjectValue)obj).obj;
            try {
                if (this.type instanceof FXSequenceType && robj instanceof FXObject) {
                    Sequences.set((FXObject)robj, this.offset, (Sequence)((Value)value).asObject());
                    return;
                }
                this.checkGetterSetter();
                if (this.fld != null || this.setter != null) {
                    if (this.setter != null) {
                        Object[] args = new Object[]{((Value)value).asObject()};
                        this.setter.invoke(robj, args);
                        return;
                    }
                    if (this.fld != null) {
                        this.fld.setAccessible(true);
                        this.fld.set(robj, ((Value)value).asObject());
                        return;
                    }
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String getName() {
            return this.name;
        }

        public FXClassType getDeclaringClass() {
            return this.owner;
        }

        private void checkAccessFlags() {
            if ((this.flags & 2) != 0) {
                return;
            }
            this.flags |= 2;
            this.checkGetterSetter();
            if (!this.getDeclaringClass().isJfxType() || !PlatformUtils.checkAccessAnnotations(this)) {
                int mask;
                int mods;
                int n = mods = this.getter != null ? this.getter.getModifiers() : this.fld.getModifiers();
                if ((mods & 1) != 0) {
                    this.flags |= 4;
                }
                if ((mods & 4) != 0) {
                    this.flags |= 8;
                }
                if ((mods & (mask = 7)) == 0) {
                    this.flags |= 0x10;
                }
            }
        }

        public boolean isStatic() {
            this.checkGetterSetter();
            int mods = this.getter != null ? this.getter.getModifiers() : this.fld.getModifiers();
            return (mods & 8) != 0;
        }

        public boolean isPublic() {
            this.checkAccessFlags();
            return (this.flags & 4) != 0;
        }

        public boolean isProtected() {
            this.checkAccessFlags();
            return (this.flags & 8) != 0;
        }

        public boolean isPackage() {
            this.checkAccessFlags();
            return (this.flags & 0x10) != 0;
        }

        public boolean isPublicInit() {
            this.checkAccessFlags();
            return (this.flags & 0x20) != 0;
        }

        public boolean isPublicRead() {
            this.checkAccessFlags();
            return (this.flags & 0x40) != 0;
        }

        public boolean isDef() {
            int d = PlatformUtils.checkDef(this);
            if (d >= 0) {
                return d > 0;
            }
            return this.fld != null && (this.fld.getModifiers() & 0x10) != 0;
        }

        public FXChangeListenerID addChangeListener(FXObjectValue instance, FXChangeListener listener) {
            if (!this.owner.isAssignableFrom(instance.getType())) {
                throw new IllegalArgumentException("not an instance of " + this.owner);
            }
            FXObject src = (FXObject)((Value)((Object)instance)).asObject();
            ListenerAdapter adapter = new ListenerAdapter(listener);
            src.addDependent$(this.offset, adapter, 0);
            return adapter;
        }

        public void removeChangeListener(FXObjectValue instance, FXChangeListenerID id) {
            if (!this.owner.isAssignableFrom(instance.getType())) {
                throw new IllegalArgumentException("not an instance of " + this.owner);
            }
            FXObject src = (FXObject)((Value)((Object)instance)).asObject();
            src.removeDependent$(this.offset, (ListenerAdapter)id);
        }

        static class ListenerAdapter
        extends FXBase
        implements FXChangeListenerID {
            final FXChangeListener listener;

            ListenerAdapter(FXChangeListener listener) {
                this.listener = listener;
            }

            public boolean update$(FXObject src, int depNum, int startPos, int endPos, int newLength, int phase) {
                if ((phase & 8) == 8) {
                    this.listener.onChange();
                }
                return true;
            }
        }
    }

    public static class VarMemberLocation
    extends FXVarMemberLocation {
        VarMember var;

        public VarMemberLocation(FXObjectValue object, VarMember var) {
            super(object, var);
            this.var = var;
        }
    }
}

