/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXBooleanValue;
import javafx.reflect.FXClassType;
import javafx.reflect.FXDoubleValue;
import javafx.reflect.FXFloatValue;
import javafx.reflect.FXIntegerValue;
import javafx.reflect.FXLocal;
import javafx.reflect.FXLongValue;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceBuilder;
import javafx.reflect.FXSequenceValue;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;

public abstract class FXContext {
    public static final String MIXIN_SUFFIX = "$Mixin";
    public static final String FXOBJECT_NAME = "com.sun.javafx.runtime.FXObject";
    public static final String FXMIXIN_NAME = "com.sun.javafx.runtime.FXMixin";
    public static final String FXBASE_NAME = "com.sun.javafx.runtime.FXBase";
    FXType anyType = this.findClass("java.lang.Object");

    public static FXContext getInstance() {
        return FXLocal.getContext();
    }

    protected FXContext() {
    }

    public abstract FXClassType findClass(String var1);

    public FXType getAnyType() {
        return this.anyType;
    }

    public FXPrimitiveType getPrimitiveType(String typeName) {
        if (typeName.startsWith("java.lang.")) {
            typeName = typeName.substring(10);
        } else if (typeName.indexOf(46) >= 0) {
            return null;
        }
        if (typeName.equals("Boolean")) {
            return this.getBooleanType();
        }
        if (typeName.equals("Character")) {
            return this.getCharacterType();
        }
        if (typeName.equals("Byte")) {
            return this.getByteType();
        }
        if (typeName.equals("Short")) {
            return this.getShortType();
        }
        if (typeName.equals("Integer") || typeName.equals("Int")) {
            return this.getIntegerType();
        }
        if (typeName.equals("Long")) {
            return this.getLongType();
        }
        if (typeName.equals("Float")) {
            return this.getFloatType();
        }
        if (typeName.equals("Double")) {
            return this.getDoubleType();
        }
        if (typeName.equals("Void")) {
            return FXPrimitiveType.voidType;
        }
        return null;
    }

    public FXPrimitiveType getBooleanType() {
        return FXPrimitiveType.booleanType;
    }

    public FXPrimitiveType getCharacterType() {
        return FXPrimitiveType.charType;
    }

    public FXPrimitiveType getByteType() {
        return FXPrimitiveType.byteType;
    }

    public FXPrimitiveType getShortType() {
        return FXPrimitiveType.shortType;
    }

    public FXPrimitiveType getIntegerType() {
        return FXPrimitiveType.integerType;
    }

    public FXPrimitiveType getLongType() {
        return FXPrimitiveType.longType;
    }

    public FXPrimitiveType getFloatType() {
        return FXPrimitiveType.floatType;
    }

    public FXPrimitiveType getDoubleType() {
        return FXPrimitiveType.doubleType;
    }

    public FXPrimitiveType getNumberType() {
        return this.getFloatType();
    }

    public FXClassType getStringType() {
        return this.findClass("java.lang.String");
    }

    public FXPrimitiveType getVoidType() {
        return FXPrimitiveType.voidType;
    }

    public FXSequenceBuilder makeSequenceBuilder(FXType elementType) {
        return new FXSequenceBuilder(this, elementType);
    }

    public FXValue makeSequence(FXType elementType, FXValue ... values) {
        FXSequenceBuilder builder = this.makeSequenceBuilder(elementType);
        for (int i = 0; i < values.length; ++i) {
            builder.append(values[i]);
        }
        return builder.getSequence();
    }

    public FXValue makeSequenceValue(FXValue[] values, int nvalues, FXType elementType) {
        return new FXSequenceValue(values, nvalues, elementType);
    }

    public FXLocal.Value mirrorOf(boolean value) {
        return new FXBooleanValue(value, this.getBooleanType());
    }

    public FXLocal.Value mirrorOf(char value) {
        return new FXIntegerValue(value, this.getCharacterType());
    }

    public FXLocal.Value mirrorOf(byte value) {
        return new FXIntegerValue(value, this.getByteType());
    }

    public FXLocal.Value mirrorOf(short value) {
        return new FXIntegerValue(value, this.getShortType());
    }

    public FXLocal.Value mirrorOf(int value) {
        return new FXIntegerValue(value, this.getIntegerType());
    }

    public FXLocal.Value mirrorOf(long value) {
        return new FXLongValue(value, this.getLongType());
    }

    public FXLocal.Value mirrorOf(float value) {
        return new FXFloatValue(value, this.getFloatType());
    }

    public FXLocal.Value mirrorOf(double value) {
        return new FXDoubleValue(value, this.getDoubleType());
    }

    public abstract FXValue mirrorOf(String var1);
}

