/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.util;

import com.sun.javafx.runtime.util.Linkable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Linkables {
    public static <T extends Linkable<T>> boolean isUnused(T element) {
        return element.getPrev() == null && element.getNext() == null;
    }

    public static <T extends Linkable<T>> Linkable<T> findLast(Linkable<T> host) {
        T next;
        Linkable<T> cur = host;
        while ((next = cur.getNext()) != null) {
            cur = next;
        }
        return cur;
    }

    public static <T extends Linkable<T>> void addAfter(Linkable<T> existing, T element) {
        T next = existing.getNext();
        existing.setNext(element);
        element.setPrev(existing);
        element.setNext(next);
        if (next != null) {
            next.setPrev(element);
        }
    }

    public static <T extends Linkable<T>> void addAtEnd(Linkable<T> host, T element) {
        Linkables.addAfter(Linkables.findLast(host), element);
    }

    public static <T extends Linkable<T>> boolean remove(T element) {
        T next = element.getNext();
        Linkable<T> prev = element.getPrev();
        if (next == null && prev == null) {
            return false;
        }
        if (prev != null) {
            prev.setNext(next);
        }
        if (next != null) {
            next.setPrev(prev);
        }
        element.setNext(null);
        element.setPrev(null);
        return true;
    }

    public static <T extends Linkable<T>> int size(Linkable<T> first) {
        int size = 0;
        for (Linkable<T> cur = first; cur != null; cur = cur.getNext()) {
            ++size;
        }
        return size;
    }
}

