/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.util;

import com.sun.javafx.runtime.util.backport.ResourceBundle;
import com.sun.javafx.runtime.util.backport.ResourceBundleEnumeration;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FXPropertyResourceBundle
extends ResourceBundle {
    private static final String CHARTAG = "@charset \"";
    private static final List<String> FORMAT_FXPROPERTIES = Collections.unmodifiableList(Arrays.asList("javafx.properties"));
    private ConcurrentMap<String, Object> lookup = new ConcurrentHashMap<String, Object>();
    private static Logger logger = null;
    private static final int CRETURN = 13;
    private static final int NEWLINE = 10;
    private static final int FSLASH = 47;
    private static final int DQUOTE = 34;
    private static final int SQUOTE = 39;
    private static final int EQUAL = 61;
    private static final int BSLASH = 92;
    private static final int SUBST = 65533;
    private static final int BOM = 65279;
    private static final Locale ROOTLOCALE = new Locale("");

    public FXPropertyResourceBundle(InputStream is, String resourceName) throws IOException {
        this(FXPropertyResourceBundle.getReader(is), resourceName);
    }

    public FXPropertyResourceBundle(Reader reader, String resourceName) throws IOException {
        this.initialize(reader, resourceName);
    }

    @Override
    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return true;
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.lookup.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        ResourceBundle parent = this.parent;
        return new ResourceBundleEnumeration(this.lookup.keySet(), parent != null ? parent.getKeys() : null);
    }

    @Override
    protected Set<String> handleKeySet() {
        return this.lookup.keySet();
    }

    private void initialize(Reader reader, String resourceName) throws IOException {
        int c;
        BufferedReader br = new BufferedReader(reader);
        int lineNum = 1;
        StringBuilder sb = new StringBuilder();
        String key = null;
        boolean foundEqual = false;
        boolean firstChar = true;
        int quote = 0;
        block13: while ((c = this.getCodePoint(br)) != -1) {
            switch (c) {
                case 13: {
                    br.mark(8);
                    if (this.getCodePoint(br) != 10) {
                        br.reset();
                    }
                }
                case 10: {
                    ++lineNum;
                    if (quote == 0) continue block13;
                    sb.appendCodePoint(10);
                    continue block13;
                }
                case 47: {
                    if (quote != 0) {
                        sb.appendCodePoint(c);
                        continue block13;
                    }
                    lineNum += this.skipComments(br, resourceName);
                    continue block13;
                }
                case 34: 
                case 39: {
                    if (quote == 0) {
                        if (key == null && foundEqual || key != null && !foundEqual) {
                            FXPropertyResourceBundle.logPropertySyntaxError(c, lineNum, resourceName);
                            continue block13;
                        }
                        quote = c;
                        continue block13;
                    }
                    if (c != 39 && c != 34) {
                        sb.appendCodePoint(c);
                        continue block13;
                    }
                    if (quote != c) {
                        sb.appendCodePoint(c);
                        continue block13;
                    }
                    quote = 0;
                    if (!foundEqual && key == null) {
                        try {
                            key = FXPropertyResourceBundle.convertEscapes(sb.toString());
                        }
                        catch (IllegalArgumentException e) {
                            FXPropertyResourceBundle.logPropertySyntaxError(e.getMessage(), lineNum, resourceName);
                        }
                        sb.setLength(0);
                        continue block13;
                    }
                    if (foundEqual && key != null) {
                        try {
                            this.lookup.put(key, FXPropertyResourceBundle.convertEscapes(sb.toString()));
                        }
                        catch (IllegalArgumentException e) {
                            FXPropertyResourceBundle.logPropertySyntaxError(e.getMessage(), lineNum, resourceName);
                        }
                        sb.setLength(0);
                        key = null;
                        foundEqual = false;
                        continue block13;
                    }
                    FXPropertyResourceBundle.logPropertySyntaxError(c, lineNum, resourceName);
                    continue block13;
                }
                case 61: {
                    if (quote != 0) {
                        sb.appendCodePoint(c);
                        continue block13;
                    }
                    if (foundEqual) {
                        FXPropertyResourceBundle.logPropertySyntaxError(c, lineNum, resourceName);
                        continue block13;
                    }
                    if (key == null) {
                        FXPropertyResourceBundle.logPropertySyntaxError(c, lineNum, resourceName);
                        continue block13;
                    }
                    foundEqual = true;
                    continue block13;
                }
                case 92: {
                    if (quote != 0) {
                        sb.appendCodePoint(c);
                        sb.appendCodePoint(this.getCodePoint(br));
                        continue block13;
                    }
                    FXPropertyResourceBundle.logPropertySyntaxError(c, lineNum, resourceName);
                    continue block13;
                }
                case 65279: {
                    if (firstChar) {
                        firstChar = false;
                        continue block13;
                    }
                    FXPropertyResourceBundle.logPropertySyntaxError(c, lineNum, resourceName);
                    continue block13;
                }
            }
            if (quote != 0) {
                sb.appendCodePoint(c);
                continue;
            }
            if (Character.isWhitespace(c) || c == 65533) continue;
            FXPropertyResourceBundle.logPropertySyntaxError(c, lineNum, resourceName);
        }
        br.close();
    }

    private int getCodePoint(BufferedReader br) throws IOException {
        int c = br.read();
        if (Character.isHighSurrogate((char)c)) {
            return Character.toCodePoint((char)c, (char)br.read());
        }
        return c;
    }

    private int skipComments(BufferedReader br, String resourceName) throws IOException {
        int newlines = 0;
        block0 : switch ((char)this.getCodePoint(br)) {
            case '*': {
                while (true) {
                    int i;
                    if ((char)(i = this.getCodePoint(br)) == '\n') {
                        ++newlines;
                        continue;
                    }
                    if ((char)i == '*') {
                        if ((char)this.getCodePoint(br) != '/') continue;
                        break block0;
                    }
                    if (i == -1) break;
                }
                FXPropertyResourceBundle.log(Level.WARNING, "non-closing comment at the end of " + resourceName);
                break;
            }
            case '/': {
                int i;
                do {
                    if ((char)(i = this.getCodePoint(br)) != '\n') continue;
                    ++newlines;
                    break block0;
                } while (i != -1);
                break;
            }
        }
        return newlines;
    }

    private static String convertEscapes(String str) {
        int x = str.indexOf(92);
        if (x == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        if (x != 0) {
            sb.append(str, 0, x);
        }
        int len = str.length();
        try {
            while (x < len) {
                char c;
                if ((c = str.charAt(x++)) != '\\') {
                    sb.append(c);
                    continue;
                }
                int top = x - 1;
                c = str.charAt(x++);
                int n = -1;
                switch (c) {
                    case 'u': {
                        n = 0;
                        for (int i = 0; i < 4; ++i) {
                            if (!('0' <= (c = str.charAt(x++)) && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F')) {
                                throw new IllegalArgumentException("illegal escape sequence '" + str.substring(top, x) + "'");
                            }
                            n = (n << 4) + Character.digit(c, 16);
                        }
                        break;
                    }
                    case 'b': {
                        n = 8;
                        break;
                    }
                    case 't': {
                        n = 9;
                        break;
                    }
                    case 'n': {
                        n = 10;
                        break;
                    }
                    case 'f': {
                        n = 12;
                        break;
                    }
                    case 'r': {
                        n = 13;
                        break;
                    }
                    case '\"': {
                        n = 34;
                        break;
                    }
                    case '\'': {
                        n = 39;
                        break;
                    }
                    case '\\': {
                        n = c;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        n = Character.digit(c, 8);
                        char leadChar = c;
                        if (x >= len || '0' > (c = str.charAt(x)) || c > '7') break;
                        n = (n << 3) + Character.digit(c, 8);
                        if (++x >= len) break;
                        c = str.charAt(x);
                        if (leadChar > '3' || '0' > c || c > '7') break;
                        n = (n << 3) + Character.digit(c, 8);
                        ++x;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal escape sequence '" + str.substring(top, x) + "'");
                    }
                }
                if (n == -1) continue;
                sb.append((char)n);
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("illegal escape sequence: " + str);
        }
        return sb.toString();
    }

    private static Reader getReader(InputStream is) throws IOException {
        BufferedInputStream bis;
        Charset charset;
        block10: {
            charset = null;
            bis = new BufferedInputStream(is);
            bis.mark(256);
            byte[] ba = new byte[CHARTAG.length()];
            if (bis.read(ba, 0, CHARTAG.length()) == ba.length) {
                String possibleCharsetTag = new String(ba, "UTF-8");
                if (possibleCharsetTag.equals(CHARTAG)) {
                    StringBuilder sb = new StringBuilder();
                    boolean found = false;
                    while (true) {
                        byte b;
                        if ((b = (byte)bis.read()) == 13 || b == 10) {
                            if (!found) {
                                FXPropertyResourceBundle.log(Level.WARNING, "Incorrect format in @charset tag");
                            }
                            break block10;
                        }
                        if (b != 34) {
                            sb.append((char)b);
                            continue;
                        }
                        found = true;
                        if ((char)bis.read() == ';') {
                            try {
                                charset = Charset.forName(sb.toString());
                            }
                            catch (Exception e) {
                                FXPropertyResourceBundle.log(Level.WARNING, "charset '" + sb.toString() + "' was not available");
                            }
                            continue;
                        }
                        FXPropertyResourceBundle.log(Level.WARNING, "Incorrect format in @charset tag");
                    }
                }
                bis.reset();
            }
        }
        if (charset == null) {
            charset = Charset.forName("UTF-8");
        }
        return new InputStreamReader((InputStream)bis, charset);
    }

    private static void logPropertySyntaxError(int c, int lineNum, String resourceName) {
        FXPropertyResourceBundle.logPropertySyntaxError(String.format("'%c' (U+%04X) is incorrectly placed", c, c), lineNum, resourceName);
    }

    private static void logPropertySyntaxError(String message, int lineNum, String resourceName) {
        FXPropertyResourceBundle.logPropertySyntaxError(String.format("%s in line %d of %s", message, lineNum, resourceName));
    }

    private static void logPropertySyntaxError(String message) {
        FXPropertyResourceBundle.log(Level.WARNING, message);
        throw new IllegalArgumentException(message);
    }

    private static void log(Level l, String msg) {
        if (logger == null) {
            logger = Logger.getLogger("com.sun.javafx.runtime.util.FXPropertyResourceBundle");
        }
        logger.log(l, msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FXPropertiesControl
    extends ResourceBundle.Control {
        static final FXPropertiesControl INSTANCE = new FXPropertiesControl();

        private FXPropertiesControl() {
        }

        @Override
        public List<String> getFormats(String baseName) {
            if (baseName == null) {
                throw new NullPointerException();
            }
            return FORMAT_FXPROPERTIES;
        }

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            if (baseName == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reloadFlag) throws IllegalAccessException, InstantiationException, IOException {
            if (locale.equals(ROOTLOCALE)) {
                return FxEchoBackResourceBundle.INSTANCE;
            }
            String bundleName = this.toBundleName(baseName, locale);
            FXPropertyResourceBundle bundle = null;
            final String resourceName = this.toResourceName(bundleName, "fxproperties");
            final ClassLoader loader = classLoader;
            final boolean reload = reloadFlag;
            InputStream stream = null;
            try {
                stream = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        InputStream is = null;
                        if (reload) {
                            URLConnection connection;
                            URL url = loader.getResource(resourceName);
                            if (url != null && (connection = url.openConnection()) != null) {
                                connection.setUseCaches(false);
                                is = connection.getInputStream();
                            }
                        } else {
                            is = loader.getResourceAsStream(resourceName);
                        }
                        return is;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (IOException)e.getException();
            }
            if (stream != null) {
                try {
                    bundle = new FXPropertyResourceBundle(stream, resourceName);
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FxEchoBackResourceBundle
    extends ResourceBundle {
        private static final Set<String> keyset = new HashSet<String>();
        static final FxEchoBackResourceBundle INSTANCE = new FxEchoBackResourceBundle();

        private FxEchoBackResourceBundle() {
        }

        @Override
        public boolean containsKey(String key) {
            return true;
        }

        @Override
        protected Object handleGetObject(String key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return key;
        }

        @Override
        public Enumeration<String> getKeys() {
            return new ResourceBundleEnumeration(keyset, null);
        }

        @Override
        protected Set<String> handleKeySet() {
            return keyset;
        }
    }
}

