/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubSequence<T>
extends AbstractSequence<T> {
    protected final Sequence<? extends T> sequence;
    protected final int size;
    private final int startPos;
    private final int step;

    public SubSequence(Sequence<T> sequence, int startPos, int endPos) {
        this(sequence, endPos - startPos, startPos, 1);
    }

    private SubSequence(Sequence<T> sequence, int size, int startPos, int step) {
        super(sequence.getElementType());
        this.startPos = startPos;
        this.step = step;
        this.sequence = sequence;
        this.size = size;
    }

    static <T> Sequence make(Sequence<T> sequence, int size, int start, int step) {
        if (size <= 0) {
            return sequence.getElementType().emptySequence;
        }
        if (sequence instanceof SubSequence) {
            SubSequence sseq = (SubSequence)sequence;
            start = sseq.startPos + sseq.step * start;
            step = sseq.step * step;
            sequence = sseq.sequence;
        }
        sequence.incrementSharing();
        return new SubSequence<T>(sequence, size, start, step);
    }

    @Override
    public T get(int position) {
        if (position < 0 || position >= this.size) {
            return this.getDefaultValue();
        }
        return this.sequence.get(this.startPos + this.step * position);
    }

    @Override
    public boolean getAsBoolean(int position) {
        if (position < 0 || position >= this.size) {
            return false;
        }
        return this.sequence.getAsBoolean(this.startPos + this.step * position);
    }

    @Override
    public char getAsChar(int position) {
        if (position < 0 || position >= this.size) {
            return '\u0000';
        }
        return this.sequence.getAsChar(this.startPos + this.step * position);
    }

    @Override
    public byte getAsByte(int position) {
        if (position < 0 || position >= this.size) {
            return 0;
        }
        return this.sequence.getAsByte(this.startPos + this.step * position);
    }

    @Override
    public short getAsShort(int position) {
        if (position < 0 || position >= this.size) {
            return 0;
        }
        return this.sequence.getAsShort(this.startPos + this.step * position);
    }

    @Override
    public int getAsInt(int position) {
        if (position < 0 || position >= this.size) {
            return 0;
        }
        return this.sequence.getAsInt(this.startPos + this.step * position);
    }

    @Override
    public long getAsLong(int position) {
        if (position < 0 || position >= this.size) {
            return 0L;
        }
        return this.sequence.getAsLong(this.startPos + this.step * position);
    }

    @Override
    public float getAsFloat(int position) {
        if (position < 0 || position >= this.size) {
            return 0.0f;
        }
        return this.sequence.getAsFloat(this.startPos + this.step * position);
    }

    @Override
    public double getAsDouble(int position) {
        if (position < 0 || position >= this.size) {
            return 0.0;
        }
        return this.sequence.getAsDouble(this.startPos + this.step * position);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.step == 1) {
            this.sequence.toArray(this.startPos + sourceOffset, length, dest, destOffset);
        } else {
            int j = this.startPos + this.step * sourceOffset;
            int i = 0;
            while (i < length) {
                dest[i + destOffset] = this.sequence.get(j);
                ++i;
                j += this.step;
            }
        }
    }
}

