/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShortArraySequence
extends ArraySequence<Short> {
    short[] array;

    public ShortArraySequence(int initialSize, TypeInfo<Short> ti) {
        super(ti);
        this.array = new short[initialSize];
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public ShortArraySequence(int initialSize) {
        this(initialSize, TypeInfo.Short);
    }

    public ShortArraySequence() {
        this(16, TypeInfo.Short);
    }

    public ShortArraySequence(TypeInfo<Short> ti, short ... values) {
        this(ti, values, false);
    }

    public ShortArraySequence(TypeInfo<Short> ti, short[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = new short[values.length];
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
    }

    public ShortArraySequence(short[] values, int startPos, int size) {
        super(TypeInfo.Short);
        this.array = new short[size];
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
    }

    public ShortArraySequence(Sequence<? extends Short> seq) {
        super(TypeInfo.Short);
        int size = seq.size();
        this.array = new short[size];
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return new short[size];
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (short[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Short getRawArrayElementAsObject(int index) {
        return this.array[index];
    }

    public ShortArraySequence makeNew(int initializeSize) {
        return new ShortArraySequence(initializeSize, this.getElementType());
    }

    @Override
    public short getAsShort(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return 0;
        }
        return this.array[position];
    }

    public void add(short element) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = element;
    }

    @Override
    public void add(Sequence<? extends Short> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, short[] dest, int destOffset) {
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    protected ShortArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        ShortArraySequence copy = new ShortArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    public void replace(int position, short value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, short value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Short> values, int sourceOffset, int length, int startPos) {
        values.toArray(sourceOffset, length, this.array, startPos);
    }

    public static short extractOldElement(ArraySequence<Short> buffer, Sequence<? extends Short> oldValue, int startPos, int endPos, int k) {
        if (oldValue != null) {
            return oldValue.get(k);
        }
        if (k >= 0) {
            int alen;
            if (k >= startPos) {
                k += buffer.gapEnd - endPos;
            }
            if (k < (alen = buffer.getRawArrayLength())) {
                return buffer.getRawArrayElementAsObject(k);
            }
        }
        return (Short)buffer.getDefaultValue();
    }

    public static short extractNewElement(ArraySequence<Short> buffer, int loIndex, Sequence<? extends Short> newElements, int k) {
        if (newElements != null) {
            return newElements.get(k);
        }
        if (k >= 0 && (k += loIndex) < buffer.gapStart) {
            return buffer.get(k);
        }
        return (Short)buffer.getDefaultValue();
    }
}

