/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.NumericTypeInfo;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.BooleanArraySequence;
import com.sun.javafx.runtime.sequence.ByteArraySequence;
import com.sun.javafx.runtime.sequence.CharArraySequence;
import com.sun.javafx.runtime.sequence.DoubleArraySequence;
import com.sun.javafx.runtime.sequence.FloatArraySequence;
import com.sun.javafx.runtime.sequence.IntArraySequence;
import com.sun.javafx.runtime.sequence.IntRangeSequence;
import com.sun.javafx.runtime.sequence.LongArraySequence;
import com.sun.javafx.runtime.sequence.NumberRangeSequence;
import com.sun.javafx.runtime.sequence.ObjectArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequenceProxy;
import com.sun.javafx.runtime.sequence.SequenceRef;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.javafx.runtime.sequence.ShortArraySequence;
import com.sun.javafx.runtime.sequence.SingletonSequence;
import com.sun.javafx.runtime.sequence.SubSequence;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencesBase {
    public static final int UNDEFINED_MARKER_INT = -1000;

    public static <T> Sequence<T> fromArray(TypeInfo<T> ti, T[] values) {
        if (values == null) {
            return ti.emptySequence;
        }
        return new ObjectArraySequence<T>(ti, values);
    }

    public static Sequence<Long> fromArray(long[] values) {
        if (values == null) {
            return TypeInfo.Long.emptySequence;
        }
        return new LongArraySequence(values, 0, values.length);
    }

    public static Sequence<Integer> fromArray(int[] values) {
        if (values == null) {
            return TypeInfo.Integer.emptySequence;
        }
        return new IntArraySequence(values, 0, values.length);
    }

    public static Sequence<Short> fromArray(short[] values) {
        if (values == null) {
            return TypeInfo.Short.emptySequence;
        }
        return new ShortArraySequence(values, 0, values.length);
    }

    public static Sequence<Character> fromArray(char[] values) {
        if (values == null) {
            return TypeInfo.Character.emptySequence;
        }
        return new CharArraySequence(values, 0, values.length);
    }

    public static Sequence<Byte> fromArray(byte[] values) {
        if (values == null) {
            return TypeInfo.Byte.emptySequence;
        }
        return new ByteArraySequence(values, 0, values.length);
    }

    public static Sequence<Double> fromArray(double[] values) {
        if (values == null) {
            return TypeInfo.Double.emptySequence;
        }
        return new DoubleArraySequence(values, 0, values.length);
    }

    public static Sequence<Float> fromArray(float[] values) {
        if (values == null) {
            return TypeInfo.Float.emptySequence;
        }
        return new FloatArraySequence(values, 0, values.length);
    }

    public static Sequence<Boolean> fromArray(boolean[] values) {
        if (values == null) {
            return TypeInfo.Boolean.emptySequence;
        }
        return new BooleanArraySequence(values, 0, values.length);
    }

    public static <T> T[] toArray(Sequence<? extends T> seq) {
        T[] unboxed = Util.newObjectArray(seq.size());
        int i = 0;
        for (T val : seq) {
            unboxed[i++] = val;
        }
        return unboxed;
    }

    public static long[] toLongArray(Sequence<? extends Number> seq) {
        int size = seq.size();
        long[] unboxed = new long[size];
        int i = size;
        while (--i >= 0) {
            unboxed[i] = seq.getAsLong(i);
        }
        return unboxed;
    }

    public static int[] toIntArray(Sequence<? extends Number> seq) {
        int size = seq.size();
        int[] unboxed = new int[size];
        int i = size;
        while (--i >= 0) {
            unboxed[i] = seq.getAsInt(i);
        }
        return unboxed;
    }

    public static short[] toShortArray(Sequence<? extends Number> seq) {
        int size = seq.size();
        short[] unboxed = new short[size];
        int i = size;
        while (--i >= 0) {
            unboxed[i] = seq.getAsShort(i);
        }
        return unboxed;
    }

    public static byte[] toByteArray(Sequence<? extends Number> seq) {
        int size = seq.size();
        byte[] unboxed = new byte[size];
        int i = size;
        while (--i >= 0) {
            unboxed[i] = seq.getAsByte(i);
        }
        return unboxed;
    }

    public static double[] toDoubleArray(Sequence<? extends Number> seq) {
        int size = seq.size();
        double[] unboxed = new double[size];
        int i = size;
        while (--i >= 0) {
            unboxed[i] = seq.getAsDouble(i);
        }
        return unboxed;
    }

    public static float[] toFloatArray(Sequence<? extends Number> seq) {
        int size = seq.size();
        float[] unboxed = new float[size];
        int i = size;
        while (--i >= 0) {
            unboxed[i] = seq.getAsFloat(i);
        }
        return unboxed;
    }

    public static boolean[] toBooleanArray(Sequence<? extends Boolean> seq) {
        int size = seq.size();
        boolean[] unboxed = new boolean[size];
        int i = size;
        while (--i >= 0) {
            unboxed[i] = seq.getAsBoolean(i);
        }
        return unboxed;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static <T> ObjectArraySequence<T> forceNonSharedObjectArraySequence(TypeInfo<T> typeInfo, Sequence<? extends T> value) {
        if (!(value instanceof ObjectArraySequence)) ** GOTO lbl-1000
        arr /* !! */  = (ObjectArraySequence<T>)value;
        if (!arr /* !! */ .isShared()) {
            return arr /* !! */ ;
        }
        if (arr /* !! */ .array.length == 0) {
            arr /* !! */  = new ObjectArraySequence<T>(typeInfo, arr /* !! */ .array, true);
        } else lbl-1000:
        // 2 sources

        {
            arr /* !! */  = new ObjectArraySequence<T>(typeInfo, value);
        }
        arr /* !! */ .incrementSharing();
        return arr /* !! */ ;
    }

    public static <T> ArraySequence<T> forceNonSharedArraySequence(TypeInfo<T> typeInfo, Sequence<? extends T> value) {
        ArraySequence<? extends T> arr;
        if (value instanceof ArraySequence && !(arr = (ArraySequence<? extends T>)value).isShared()) {
            return arr;
        }
        arr = typeInfo.emptySequence.makeNew(0);
        arr.add(value);
        arr.incrementSharing();
        return arr;
    }

    public static <T> T incrementSharing(T value) {
        if (value instanceof ArraySequence) {
            ((ArraySequence)value).incrementSharing();
        }
        return value;
    }

    public static <T> Sequence<T> make(TypeInfo<T> ti, T ... values) {
        if (values == null || values.length == 0) {
            return ti.emptySequence;
        }
        return new ObjectArraySequence<T>(ti, values);
    }

    public static <T> Sequence<T> make(TypeInfo<T> ti, T[] values, int size) {
        if (values == null || size <= 0) {
            return ti.emptySequence;
        }
        return new ObjectArraySequence<T>(ti, values, 0, size);
    }

    public static <T> Sequence<T> makeViaHandoff(TypeInfo<T> ti, T[] values) {
        return new ObjectArraySequence<T>(ti, values, true);
    }

    public static <T> Sequence<T> make(TypeInfo<T> ti, List<? extends T> values) {
        if (values == null || values.size() == 0) {
            return ti.emptySequence;
        }
        return new ObjectArraySequence<T>(ti, values);
    }

    public static Sequence<Integer> range(int lower, int upper) {
        return new IntRangeSequence(lower, upper);
    }

    public static Sequence<Integer> range(int lower, int upper, int step) {
        return new IntRangeSequence(lower, upper, step);
    }

    public static Sequence<Integer> rangeExclusive(int lower, int upper) {
        return new IntRangeSequence(lower, upper, true);
    }

    public static Sequence<Integer> rangeExclusive(int lower, int upper, int step) {
        return new IntRangeSequence(lower, upper, step, true);
    }

    public static Sequence<Float> range(float lower, float upper) {
        return new NumberRangeSequence(lower, upper, 1.0f);
    }

    public static Sequence<Float> range(float lower, float upper, float step) {
        return new NumberRangeSequence(lower, upper, step);
    }

    public static Sequence<Float> rangeExclusive(float lower, float upper) {
        return new NumberRangeSequence(lower, upper, 1.0f, true);
    }

    public static Sequence<Float> rangeExclusive(float lower, float upper, float step) {
        return new NumberRangeSequence(lower, upper, step, true);
    }

    public static <T> Sequence<T> filter(Sequence<T> seq, BitSet bits) {
        int cardinality = bits.cardinality();
        if (cardinality == 0) {
            return seq.getEmptySequence();
        }
        if (cardinality == seq.size() && bits.nextClearBit(0) == seq.size()) {
            return seq;
        }
        ObjectArraySequence<T> result = new ObjectArraySequence<T>(cardinality, seq.getElementType());
        int i = bits.nextSetBit(0);
        boolean next = false;
        while (i >= 0) {
            result.add(seq.get(i));
            i = bits.nextSetBit(i + 1);
        }
        return result;
    }

    public static <T> Sequence<T> subsequence(Sequence<T> seq, int start, int end) {
        if (start >= end) {
            return seq.getEmptySequence();
        }
        if (start <= 0 && end >= seq.size()) {
            return seq;
        }
        start = Math.max(start, 0);
        end = Math.min(end, seq.size());
        return SubSequence.make(seq, end - start, start, 1);
    }

    public static int calculateIntRangeSize(int lower, int upper, int step, boolean exclusive) {
        if (step == 0) {
            return 0;
        }
        if (Math.abs((long)lower - (long)upper) + (long)(exclusive ? 0 : 1) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range sequence too big");
        }
        if (upper == lower) {
            return exclusive ? 0 : 1;
        }
        int size = Math.max(0, (upper - lower) / step + 1);
        if (exclusive) {
            boolean tooBig;
            boolean bl = step > 0 ? lower + (size - 1) * step >= upper : (tooBig = lower + (size - 1) * step <= upper);
            if (tooBig && size > 0) {
                --size;
            }
        }
        return size;
    }

    public static int calculateFloatRangeSize(float lower, float upper, float step, boolean exclusive) {
        long sz;
        if (step == 0.0f) {
            return 0;
        }
        if (upper == lower) {
            return exclusive ? 0 : 1;
        }
        long l = sz = upper < lower && step > 0.0f || upper > lower && step < 0.0f ? 0L : Math.max(0L, (long)((upper - lower) / step) + 1L);
        if (exclusive) {
            boolean tooBig;
            boolean bl = step > 0.0f ? lower + (float)(sz - 1L) * step >= upper : (tooBig = lower + (float)(sz - 1L) * step <= upper);
            if (tooBig && sz > 0L) {
                --sz;
            }
        }
        if (sz > Integer.MAX_VALUE || sz < 0L) {
            throw new IllegalArgumentException("Range sequence too big");
        }
        return (int)sz;
    }

    public static <T> Sequence<T> singleton(TypeInfo<T> ti, T t) {
        if (t == null) {
            return ti.emptySequence;
        }
        return new SingletonSequence<T>(ti, t);
    }

    public static <T> Sequence<T> emptySequence(Class<T> clazz) {
        return TypeInfo.getTypeInfo(clazz).emptySequence;
    }

    public static <T> Sequence<T> reverse(Sequence<T> sequence) {
        int ssize = sequence.size();
        return SubSequence.make(sequence, ssize, ssize - 1, -1);
    }

    public static <T> Sequence<T> fromCollection(TypeInfo<T> ti, Collection<T> values) {
        if (values == null) {
            return ti.emptySequence;
        }
        return new ObjectArraySequence<Object>(ti, values.toArray());
    }

    public static <T> Sequence<T> upcast(Sequence<? extends T> sequence) {
        return sequence;
    }

    public static Sequence<? extends Object> convertObjectToSequence(Object obj) {
        if (obj instanceof Sequence) {
            return (Sequence)obj;
        }
        return SequencesBase.singleton(TypeInfo.Object, obj);
    }

    public static <T extends Number, V extends Number> Sequence<T> convertNumberSequence(NumericTypeInfo<T> toType, NumericTypeInfo<V> fromType, Sequence<? extends V> seq) {
        if (Sequences.size(seq) == 0) {
            return toType.emptySequence;
        }
        int length = seq.size();
        Number[] toArray = toType.makeArray(length);
        int i = 0;
        for (Number val : seq) {
            toArray[i++] = toType.asPreferred(fromType, val);
        }
        return new ObjectArraySequence<Number>((TypeInfo<Number>)toType, (T[])toArray, 0, length);
    }

    public static <V extends Number> Sequence<Character> convertNumberToCharSequence(NumericTypeInfo<V> fromType, Sequence<? extends V> seq) {
        if (Sequences.size(seq) == 0) {
            return TypeInfo.Character.emptySequence;
        }
        int length = seq.size();
        Character[] toArray = new Character[length];
        int i = 0;
        for (Number val : seq) {
            toArray[i++] = Character.valueOf((char)val.intValue());
        }
        return new ObjectArraySequence<Character>(TypeInfo.Character, (T[])toArray, 0, length);
    }

    public static <V extends Number> Sequence<V> convertCharToNumberSequence(NumericTypeInfo<V> targetType, Sequence<? extends Character> seq) {
        if (Sequences.size(seq) == 0) {
            return targetType.emptySequence;
        }
        int length = seq.size();
        Number[] toArray = targetType.makeArray(length);
        int i = 0;
        for (Character c : seq) {
            toArray[i++] = targetType.asPreferred(TypeInfo.Integer, Integer.valueOf(c.charValue()));
        }
        return new ObjectArraySequence<Number>((TypeInfo<Number>)targetType, (T[])toArray, 0, length);
    }

    public static int size(Object seq) {
        if (seq instanceof Sequence) {
            return ((Sequence)seq).size();
        }
        return seq == null ? 0 : 1;
    }

    public static int size(Sequence seq) {
        return seq == null ? 0 : seq.size();
    }

    public static <T> Iterator<T> iterator(Sequence<T> seq) {
        return seq == null ? TypeInfo.Object.emptySequence.iterator() : seq.iterator();
    }

    public static <T> Iterator<T> iterator(Sequence<T> seq, int startPos, int endPos) {
        return seq == null ? TypeInfo.Object.emptySequence.iterator() : seq.iterator(startPos, endPos);
    }

    public static <T> boolean isEqual(Sequence<?> one, Sequence<?> other) {
        int oneSize = SequencesBase.size(one);
        int otherSize = SequencesBase.size(other);
        if (oneSize == 0) {
            return otherSize == 0;
        }
        if (oneSize != otherSize) {
            return false;
        }
        Iterator<?> it1 = one.iterator();
        Iterator<?> it2 = other.iterator();
        while (it1.hasNext()) {
            if (it1.next().equals(it2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean isEqualByContentIdentity(Sequence<? extends T> one, Sequence<? extends T> other) {
        int oneSize = SequencesBase.size(one);
        if (oneSize == 0) {
            return SequencesBase.size(other) == 0;
        }
        if (oneSize != SequencesBase.size(other)) {
            return false;
        }
        Iterator<T> it1 = one.iterator();
        Iterator<T> it2 = other.iterator();
        while (it1.hasNext()) {
            if (it1.next() == it2.next()) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean sliceEqual(Sequence<? extends T> seq, int startPos, int endPos, Sequence<? extends T> slice) {
        int size = SequencesBase.size(slice);
        if (endPos - startPos != size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (seq.get(startPos + i).equals(slice.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T> Sequence<? extends T> forceNonNull(TypeInfo<T> typeInfo, Sequence<? extends T> seq) {
        return seq == null ? typeInfo.emptySequence : seq;
    }

    public static <T> T getSingleValue(Sequence<T> seq) {
        if (seq == null || seq.size() != 1) {
            return null;
        }
        return seq.get(0);
    }

    public static <T extends Comparable> int binarySearch(Sequence<? extends T> seq, T key) {
        if (seq.isEmpty()) {
            return -1;
        }
        int length = seq.size();
        Object[] array = Util.newComparableArray((int)length);
        seq.toArray(0, length, array, 0);
        return Arrays.binarySearch(array, key);
    }

    public static <T> int binarySearch(Sequence<? extends T> seq, T key, Comparator<? super T> c) {
        if (seq.isEmpty()) {
            return -1;
        }
        int length = seq.size();
        Object[] array = Util.newObjectArray(length);
        seq.toArray(0, length, array, 0);
        return Arrays.binarySearch(array, key, c);
    }

    public static <T> int indexByIdentity(Sequence<? extends T> seq, T key) {
        return SequencesBase.nextIndexByIdentity(seq, key, 0);
    }

    public static <T> int indexOf(Sequence<? extends T> seq, T key) {
        return SequencesBase.nextIndexOf(seq, key, 0);
    }

    public static <T extends Comparable> T max(Sequence<T> seq) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.max");
        }
        Comparable result = (Comparable)seq.get(0);
        for (Comparable val : seq) {
            if (result.compareTo(val) >= 0) continue;
            result = val;
        }
        return (T)result;
    }

    public static <T> T max(Sequence<T> seq, Comparator<? super T> c) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.max");
        }
        if (c == null) {
            return SequencesBase.max(seq);
        }
        T result = seq.get(0);
        for (T val : seq) {
            if (c.compare(result, val) >= 0) continue;
            result = val;
        }
        return result;
    }

    public static <T extends Comparable> T min(Sequence<T> seq) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.min");
        }
        Comparable result = (Comparable)seq.get(0);
        for (Comparable val : seq) {
            if (result.compareTo(val) <= 0) continue;
            result = val;
        }
        return (T)result;
    }

    public static <T> T min(Sequence<T> seq, Comparator<? super T> c) {
        if (seq == null || seq.isEmpty()) {
            throw new IllegalArgumentException("empty sequence passed to Sequences.min");
        }
        if (c == null) {
            return SequencesBase.min(seq);
        }
        T result = seq.get(0);
        for (T val : seq) {
            if (c.compare(result, val) <= 0) continue;
            result = val;
        }
        return result;
    }

    public static <T> int nextIndexByIdentity(Sequence<? extends T> seq, T key, int pos) {
        int i;
        if (seq == null) {
            return -1;
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Iterator<T> it = seq.iterator();
        for (i = 0; i < pos && it.hasNext(); ++i) {
            it.next();
        }
        while (it.hasNext()) {
            if (it.next() == key) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int nextIndexOf(Sequence<? extends T> seq, T key, int pos) {
        int i;
        if (seq == null) {
            return -1;
        }
        if (key == null) {
            throw new NullPointerException();
        }
        Iterator<T> it = seq.iterator();
        for (i = 0; i < pos && it.hasNext(); ++i) {
            it.next();
        }
        while (it.hasNext()) {
            if (it.next().equals(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T extends Comparable> Sequence<? extends T> sort(Sequence<T> seq) {
        if (seq.isEmpty()) {
            return seq.getEmptySequence();
        }
        int length = seq.size();
        Object[] array = Util.newComparableArray((int)length);
        seq.toArray(0, length, array, 0);
        Arrays.sort(array);
        return Sequences.make(seq.getElementType(), array);
    }

    public static <T> Sequence<? extends T> sort(Sequence<T> seq, Comparator<? super T> c) {
        if (seq.isEmpty()) {
            return seq.getEmptySequence();
        }
        int length = seq.size();
        Object[] array = Util.newObjectArray(length);
        seq.toArray(0, length, array, 0);
        Arrays.sort(array, c);
        return Sequences.make(seq.getElementType(), array);
    }

    public static <T> Sequence<T> shuffle(Sequence<T> seq) {
        T[] array = SequencesBase.toArray(seq);
        List<T> list = Arrays.asList(array);
        Collections.shuffle(list);
        return Sequences.make(seq.getElementType(), list);
    }

    public static <T> T getFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return (T)instance.elem$(varNum, k);
    }

    public static <T> Sequence<? extends T> getNewElements(Sequence<? extends T> current, int startPos, int inserted) {
        return Sequences.subsequence(current, startPos, startPos + inserted);
    }

    public static <T> Sequence<? extends T> replaceSlice(Sequence<? extends T> oldValue, T newValue, int startPos, int endPos) {
        if (SequencesBase.preReplaceSlice(oldValue, newValue, startPos, endPos)) {
            return SequencesBase.replaceSliceInternal(oldValue, newValue, startPos, endPos, false);
        }
        return oldValue;
    }

    private static <T> boolean preReplaceSlice(Sequence<? extends T> oldValue, T newValue, int startPos, int endPos) {
        if (newValue == null) {
            return SequencesBase.preReplaceSlice(oldValue, (Sequence)null, startPos, endPos);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        return endPos != startPos + 1 || !newValue.equals(oldValue.get(startPos));
    }

    private static <T> Sequence<? extends T> replaceSliceInternal(Sequence<? extends T> oldValue, T newValue, int startPos, int endPos, boolean hasTrigger) {
        if (newValue == null) {
            return SequencesBase.replaceSliceInternal(oldValue, (Sequence)null, startPos, endPos, hasTrigger);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        ObjectArraySequence<T> arr = SequencesBase.forceNonSharedObjectArraySequence(oldValue.getElementType(), oldValue);
        arr.replace(startPos, endPos, newValue, hasTrigger);
        if (hasTrigger) {
            arr.clearOldValues(endPos - startPos);
        }
        return arr;
    }

    public static <T> void replaceSlice(FXObject instance, int varNum, T newValue, int startPos, int endPos) {
        boolean wasUninitialized = instance.varTestBits$(varNum, 16, 0);
        instance.varChangeBits$(varNum, 24, 24);
        if (instance.varTestBits$(varNum, 768, 768)) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 24, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        if (SequencesBase.preReplaceSlice(oldValue, newValue, startPos, endPos) || wasUninitialized) {
            int newLength = newValue == null ? 0 : 1;
            instance.invalidate$(varNum, startPos, endPos, newLength, 65);
            Sequence<T> arr = SequencesBase.replaceSliceInternal(oldValue, newValue, startPos, endPos, true);
            instance.seq$(varNum, arr);
            instance.invalidate$(varNum, startPos, endPos, newLength, 92);
        }
    }

    public static <T> Sequence<? extends T> replaceSlice(Sequence<? extends T> oldValue, Sequence<? extends T> newValues, int startPos, int endPos) {
        int inserted;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        int n = inserted = newValues == null ? 0 : newValues.size();
        if (startPos == 0 && endPos == oldSize && !(newValues instanceof SequenceRef) && !(newValues instanceof SequenceProxy)) {
            if (newValues == null) {
                newValues = oldValue.getEmptySequence();
            }
            newValues.incrementSharing();
            return newValues;
        }
        ArraySequence<T> arr = SequencesBase.forceNonSharedArraySequence(oldValue.getElementType(), oldValue);
        arr.replace(startPos, endPos, newValues, 0, inserted, false);
        return arr;
    }

    private static <T> boolean preReplaceSlice(Sequence<? extends T> oldValue, Sequence<? extends T> newValues, int startPos, int endPos) {
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        return !(newValues == null ? startPos == endPos : SequencesBase.sliceEqual(oldValue, startPos, endPos, newValues));
    }

    private static <T> Sequence<? extends T> replaceSliceInternal(Sequence<? extends T> oldValue, Sequence<? extends T> newValues, int startPos, int endPos, boolean hasTrigger) {
        int inserted;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        int n = inserted = newValues == null ? 0 : newValues.size();
        if (startPos == 0 && endPos == oldSize && !(newValues instanceof SequenceRef) && !(newValues instanceof SequenceProxy)) {
            if (newValues == null) {
                newValues = oldValue.getEmptySequence();
            }
            newValues.incrementSharing();
            return newValues;
        }
        ArraySequence<T> arr = SequencesBase.forceNonSharedArraySequence(oldValue.getElementType(), oldValue);
        arr.replace(startPos, endPos, newValues, 0, inserted, hasTrigger);
        if (hasTrigger) {
            arr.clearOldValues(endPos - startPos);
        }
        return arr;
    }

    public static <T> void replaceSlice(FXObject instance, int varNum, Sequence<? extends T> newValues, int startPos, int endPos) {
        boolean wasUninitialized = instance.varTestBits$(varNum, 16, 0);
        instance.varChangeBits$(varNum, 24, 24);
        if (instance.varTestBits$(varNum, 768, 768)) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 24, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        if (SequencesBase.preReplaceSlice(oldValue, newValues, startPos, endPos) || wasUninitialized) {
            int newLength = newValues == null ? 0 : newValues.size();
            instance.invalidate$(varNum, startPos, endPos, newLength, 65);
            Sequence<? extends T> arr = SequencesBase.replaceSliceInternal(oldValue, newValues, startPos, endPos, true);
            instance.seq$(varNum, arr);
            instance.invalidate$(varNum, startPos, endPos, newLength, 92);
        }
    }

    public static <T> Sequence<? extends T> set(Sequence<? extends T> oldValue, Sequence<? extends T> newValue) {
        if (newValue instanceof SequenceRef || newValue instanceof SequenceProxy) {
            return SequencesBase.replaceSlice(oldValue, newValue, 0, oldValue.size());
        }
        newValue.incrementSharing();
        return newValue;
    }

    public static <T> Sequence<? extends T> set(FXObject instance, int varNum, Sequence<? extends T> newValue) {
        SequencesBase.replaceSlice(instance, varNum, newValue, 0, instance.size$(varNum));
        return newValue;
    }

    public static <T> Sequence<? extends T> set(Sequence<? extends T> oldValue, T newValue, int index) {
        return SequencesBase.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static <T> T set(FXObject instance, int varNum, T newValue, int index) {
        SequencesBase.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static <T> ArraySequence<? extends T> copy(Sequence<? extends T> oldValue) {
        ArraySequence<T> arr = oldValue.getElementType().emptySequence.makeNew(0);
        arr.add(oldValue);
        arr.incrementSharing();
        return arr;
    }

    public static <T> Sequence<? extends T> insert(Sequence<? extends T> oldValue, T newValue) {
        if (newValue == null) {
            return oldValue;
        }
        int oldSize = oldValue.size();
        ObjectArraySequence<T> arr = SequencesBase.forceNonSharedObjectArraySequence(oldValue.getElementType(), oldValue);
        arr.replace(oldSize, oldSize, newValue, true);
        return arr;
    }

    public static <T> void insert(FXObject instance, int varNum, T newValue) {
        if (newValue == null) {
            return;
        }
        instance.varChangeBits$(varNum, 24, 24);
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 24, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        int newLength = newValue == null ? 0 : 1;
        Sequence<T> arr = SequencesBase.insert(oldValue, newValue);
        instance.invalidate$(varNum, oldSize, oldSize, newLength, 65);
        instance.seq$(varNum, arr);
        instance.invalidate$(varNum, oldSize, oldSize, newLength, 92);
    }

    public static <T> Sequence<? extends T> insert(Sequence<? extends T> oldValue, Sequence<? extends T> values) {
        int inserted = values.size();
        if (inserted == 0) {
            return oldValue;
        }
        int oldSize = oldValue.size();
        ArraySequence<T> arr = SequencesBase.forceNonSharedArraySequence(oldValue.getElementType(), oldValue);
        arr.replace(oldSize, oldSize, values, 0, inserted, true);
        return arr;
    }

    public static <T> void insert(FXObject instance, int varNum, Sequence<? extends T> values) {
        int inserted = values.size();
        if (inserted == 0) {
            return;
        }
        instance.varChangeBits$(varNum, 24, 24);
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 24, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        int newLength = values == null ? 0 : values.size();
        Sequence<? extends T> arr = SequencesBase.insert(oldValue, values);
        instance.invalidate$(varNum, oldSize, oldSize, newLength, 65);
        instance.seq$(varNum, arr);
        instance.invalidate$(varNum, oldSize, oldSize, newLength, 92);
    }

    public static <T> void insertBefore(FXObject instance, int varNum, T value, int position) {
        SequencesBase.replaceSlice(instance, varNum, value, position, position);
    }

    public static <T> void insertBefore(FXObject instance, int varNum, Sequence<? extends T> values, int position) {
        SequencesBase.replaceSlice(instance, varNum, values, position, position);
    }

    public static <T> Sequence<? extends T> insertBefore(Sequence<? extends T> oldValue, T value, int position) {
        return SequencesBase.replaceSlice(oldValue, value, position, position);
    }

    public static <T> Sequence<? extends T> insertBefore(Sequence<? extends T> oldValue, Sequence<? extends T> values, int position) {
        return SequencesBase.replaceSlice(oldValue, values, position, position);
    }

    public static <T> void deleteIndexed(FXObject instance, int varNum, int position) {
        SequencesBase.replaceSlice(instance, varNum, (Sequence)null, position, position + 1);
    }

    public static <T> Sequence<? extends T> deleteIndexed(Sequence<? extends T> oldValue, int position) {
        return SequencesBase.replaceSlice(oldValue, (Sequence)null, position, position + 1);
    }

    public static <T> void deleteSlice(FXObject instance, int varNum, int begin, int end) {
        SequencesBase.replaceSlice(instance, varNum, (Sequence)null, begin, end);
    }

    public static <T> Sequence<? extends T> deleteSlice(Sequence<? extends T> oldValue, int begin, int end) {
        return SequencesBase.replaceSlice(oldValue, (Sequence)null, begin, end);
    }

    public static <T> void deleteValue(FXObject instance, int varNum, T value) {
        if (instance.varTestBits$(varNum, 768, 768)) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            oldValue = (Sequence)instance.get$(varNum);
        }
        int hi = -1;
        int i = oldValue.size();
        do {
            boolean matches;
            boolean bl = matches = --i < 0 ? false : oldValue.get(i).equals(value);
            if (matches) {
                if (hi >= 0) continue;
                hi = i;
                continue;
            }
            if (hi < 0) continue;
            SequencesBase.deleteSlice(instance, varNum, i + 1, hi + 1);
            oldValue = (Sequence)instance.get$(varNum);
            hi = -1;
        } while (i >= 0);
    }

    public static <T> Sequence<? extends T> deleteValue(Sequence<? extends T> oldValue, T value) {
        int hi = -1;
        int i = oldValue.size();
        do {
            boolean matches;
            boolean bl = matches = --i < 0 ? false : oldValue.get(i).equals(value);
            if (matches) {
                if (hi >= 0) continue;
                hi = i;
                continue;
            }
            if (hi < 0) continue;
            oldValue = SequencesBase.deleteSlice(oldValue, i + 1, hi + 1);
            hi = -1;
        } while (i >= 0);
        return oldValue;
    }

    public static <T> Sequence<? extends T> deleteAll(Sequence<? extends T> oldValue) {
        return oldValue.getEmptySequence();
    }

    public static <T> void deleteAll(FXObject instance, int varNum) {
        int oldSize = instance.size$(varNum);
        SequencesBase.replaceSlice(instance, varNum, (Sequence)null, 0, oldSize);
    }

    public static boolean withinBounds(FXObject obj, int varNum, int position) {
        return position >= 0 && position < obj.size$(varNum);
    }
}

