/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.AssignToBoundException;
import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.runtime.sequence.BooleanArraySequence;
import com.sun.javafx.runtime.sequence.ByteArraySequence;
import com.sun.javafx.runtime.sequence.CharArraySequence;
import com.sun.javafx.runtime.sequence.DoubleArraySequence;
import com.sun.javafx.runtime.sequence.FloatArraySequence;
import com.sun.javafx.runtime.sequence.IntArraySequence;
import com.sun.javafx.runtime.sequence.LongArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequenceProxy;
import com.sun.javafx.runtime.sequence.SequencesBase;
import com.sun.javafx.runtime.sequence.ShortArraySequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sequences
extends SequencesBase {
    private Sequences() {
    }

    public static int getAsIntFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsInt$(varNum, k);
    }

    private static Sequence<? extends Integer> replaceSlice(Sequence<? extends Integer> oldValue, int newValue, int startPos, int endPos) {
        IntArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof IntArraySequence) || (arr = (IntArraySequence)oldValue).isShared()) {
            arr = new IntArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, int newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsInt(startPos) || wasUninitialized) {
            IntArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof IntArraySequence) || (arr = (IntArraySequence)oldValue).isShared()) {
                arr = new IntArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Integer> set(Sequence<? extends Integer> oldValue, int newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static int set(FXObject instance, int varNum, int newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Integer> insert(Sequence<? extends Integer> oldValue, int newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, int newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Integer> insertBefore(Sequence<? extends Integer> oldValue, int value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, int value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }

    public static double getAsDoubleFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsDouble$(varNum, k);
    }

    private static Sequence<? extends Double> replaceSlice(Sequence<? extends Double> oldValue, double newValue, int startPos, int endPos) {
        DoubleArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof DoubleArraySequence) || (arr = (DoubleArraySequence)oldValue).isShared()) {
            arr = new DoubleArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, double newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsDouble(startPos) || wasUninitialized) {
            DoubleArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof DoubleArraySequence) || (arr = (DoubleArraySequence)oldValue).isShared()) {
                arr = new DoubleArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Double> set(Sequence<? extends Double> oldValue, double newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static double set(FXObject instance, int varNum, double newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Double> insert(Sequence<? extends Double> oldValue, double newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, double newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Double> insertBefore(Sequence<? extends Double> oldValue, double value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, double value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }

    public static float getAsFloatFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsFloat$(varNum, k);
    }

    private static Sequence<? extends Float> replaceSlice(Sequence<? extends Float> oldValue, float newValue, int startPos, int endPos) {
        FloatArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof FloatArraySequence) || (arr = (FloatArraySequence)oldValue).isShared()) {
            arr = new FloatArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, float newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsFloat(startPos) || wasUninitialized) {
            FloatArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof FloatArraySequence) || (arr = (FloatArraySequence)oldValue).isShared()) {
                arr = new FloatArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Float> set(Sequence<? extends Float> oldValue, float newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static float set(FXObject instance, int varNum, float newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Float> insert(Sequence<? extends Float> oldValue, float newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, float newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Float> insertBefore(Sequence<? extends Float> oldValue, float value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, float value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }

    public static short getAsShortFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsShort$(varNum, k);
    }

    private static Sequence<? extends Short> replaceSlice(Sequence<? extends Short> oldValue, short newValue, int startPos, int endPos) {
        ShortArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof ShortArraySequence) || (arr = (ShortArraySequence)oldValue).isShared()) {
            arr = new ShortArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, short newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsShort(startPos) || wasUninitialized) {
            ShortArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof ShortArraySequence) || (arr = (ShortArraySequence)oldValue).isShared()) {
                arr = new ShortArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Short> set(Sequence<? extends Short> oldValue, short newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static short set(FXObject instance, int varNum, short newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Short> insert(Sequence<? extends Short> oldValue, short newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, short newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Short> insertBefore(Sequence<? extends Short> oldValue, short value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, short value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }

    public static char getAsCharFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsChar$(varNum, k);
    }

    private static Sequence<? extends Character> replaceSlice(Sequence<? extends Character> oldValue, char newValue, int startPos, int endPos) {
        CharArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof CharArraySequence) || (arr = (CharArraySequence)oldValue).isShared()) {
            arr = new CharArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, char newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsChar(startPos) || wasUninitialized) {
            CharArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof CharArraySequence) || (arr = (CharArraySequence)oldValue).isShared()) {
                arr = new CharArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Character> set(Sequence<? extends Character> oldValue, char newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static char set(FXObject instance, int varNum, char newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Character> insert(Sequence<? extends Character> oldValue, char newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, char newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Character> insertBefore(Sequence<? extends Character> oldValue, char value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, char value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }

    public static long getAsLongFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsLong$(varNum, k);
    }

    private static Sequence<? extends Long> replaceSlice(Sequence<? extends Long> oldValue, long newValue, int startPos, int endPos) {
        LongArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof LongArraySequence) || (arr = (LongArraySequence)oldValue).isShared()) {
            arr = new LongArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, long newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsLong(startPos) || wasUninitialized) {
            LongArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof LongArraySequence) || (arr = (LongArraySequence)oldValue).isShared()) {
                arr = new LongArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Long> set(Sequence<? extends Long> oldValue, long newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static long set(FXObject instance, int varNum, long newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Long> insert(Sequence<? extends Long> oldValue, long newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, long newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Long> insertBefore(Sequence<? extends Long> oldValue, long value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, long value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }

    public static boolean getAsBooleanFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsBoolean$(varNum, k);
    }

    private static Sequence<? extends Boolean> replaceSlice(Sequence<? extends Boolean> oldValue, boolean newValue, int startPos, int endPos) {
        BooleanArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof BooleanArraySequence) || (arr = (BooleanArraySequence)oldValue).isShared()) {
            arr = new BooleanArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, boolean newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsBoolean(startPos) || wasUninitialized) {
            BooleanArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof BooleanArraySequence) || (arr = (BooleanArraySequence)oldValue).isShared()) {
                arr = new BooleanArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Boolean> set(Sequence<? extends Boolean> oldValue, boolean newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static boolean set(FXObject instance, int varNum, boolean newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Boolean> insert(Sequence<? extends Boolean> oldValue, boolean newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, boolean newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Boolean> insertBefore(Sequence<? extends Boolean> oldValue, boolean value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, boolean value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }

    public static byte getAsByteFromNewElements(FXObject instance, int varNum, int loIndex, int inserted, int k) {
        if (k >= inserted) {
            k = -1;
        } else if (k >= 0) {
            k += loIndex;
        }
        return instance.getAsByte$(varNum, k);
    }

    private static Sequence<? extends Byte> replaceSlice(Sequence<? extends Byte> oldValue, byte newValue, int startPos, int endPos) {
        ByteArraySequence arr;
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (!(oldValue instanceof ByteArraySequence) || (arr = (ByteArraySequence)oldValue).isShared()) {
            arr = new ByteArraySequence(oldValue);
            arr.incrementSharing();
        }
        arr.replace(startPos, endPos, newValue, false);
        return arr;
    }

    public static void replaceSlice(FXObject instance, int varNum, byte newValue, int startPos, int endPos) {
        int flags = instance.getFlags$(varNum);
        boolean wasUninitialized = (flags & 0x10) == 0;
        instance.setFlags$(varNum, flags | 0x18);
        if ((flags & 0x300) == 768) {
            throw new AssignToBoundException("Cannot mutate bound sequence");
        }
        Sequence oldValue = (Sequence)instance.get$(varNum);
        while (oldValue instanceof SequenceProxy) {
            SequenceProxy sp = (SequenceProxy)oldValue;
            instance = sp.instance();
            varNum = sp.varNum();
            instance.varChangeBits$(varNum, 0, 24);
            oldValue = (Sequence)instance.get$(varNum);
        }
        int oldSize = oldValue.size();
        if (startPos < 0) {
            startPos = 0;
        } else if (startPos > oldSize) {
            startPos = oldSize;
        }
        if (endPos > oldSize) {
            endPos = oldSize;
        } else if (endPos < startPos) {
            endPos = startPos;
        }
        if (endPos != startPos + 1 || newValue != oldValue.getAsByte(startPos) || wasUninitialized) {
            ByteArraySequence arr;
            instance.invalidate$(varNum, startPos, endPos, 1, 65);
            if (!(oldValue instanceof ByteArraySequence) || (arr = (ByteArraySequence)oldValue).isShared()) {
                arr = new ByteArraySequence(oldValue);
                arr.incrementSharing();
            }
            arr.replace(startPos, endPos, newValue, true);
            if (arr != oldValue) {
                instance.seq$(varNum, arr);
            }
            instance.invalidate$(varNum, startPos, endPos, 1, 92);
        }
    }

    public static Sequence<? extends Byte> set(Sequence<? extends Byte> oldValue, byte newValue, int index) {
        return Sequences.replaceSlice(oldValue, newValue, index, index + 1);
    }

    public static byte set(FXObject instance, int varNum, byte newValue, int index) {
        Sequences.replaceSlice(instance, varNum, newValue, index, index + 1);
        return newValue;
    }

    public static Sequence<? extends Byte> insert(Sequence<? extends Byte> oldValue, byte newValue) {
        int oldSize = oldValue.size();
        return Sequences.replaceSlice(oldValue, newValue, oldSize, oldSize);
    }

    public static void insert(FXObject instance, int varNum, byte newValue) {
        int oldSize = instance.size$(varNum);
        Sequences.replaceSlice(instance, varNum, newValue, oldSize, oldSize);
    }

    public static <T> Sequence<? extends Byte> insertBefore(Sequence<? extends Byte> oldValue, byte value, int position) {
        return Sequences.replaceSlice(oldValue, value, position, position);
    }

    public static void insertBefore(FXObject instance, int varNum, byte value, int position) {
        Sequences.replaceSlice(instance, varNum, value, position, position);
    }
}

