/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArraySequence<T>
extends ArraySequence<T>
implements Sequence<T> {
    T[] array;

    public ObjectArraySequence(int initialSize, TypeInfo<T> ti) {
        super(ti);
        this.array = Util.newObjectArray(initialSize);
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public ObjectArraySequence(TypeInfo<T> ti) {
        this(16, ti);
    }

    public ObjectArraySequence(TypeInfo<T> ti, T ... values) {
        this(ti, values, false);
    }

    public ObjectArraySequence(TypeInfo<T> ti, T[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = Util.newObjectArray(values.length);
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
        this.checkForNulls();
    }

    public ObjectArraySequence(TypeInfo<T> ti, T[] values, int startPos, int size) {
        super(ti);
        this.array = Util.newObjectArray(size);
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
        this.checkForNulls();
    }

    public ObjectArraySequence(TypeInfo<T> ti, List<? extends T> values) {
        super(ti);
        this.array = values.toArray();
        this.gapStart = this.gapEnd = this.array.length;
        this.checkForNulls();
    }

    public ObjectArraySequence(TypeInfo<T> ti, Sequence<? extends T> seq) {
        super(ti);
        int size = seq.size();
        this.array = Util.newObjectArray(size);
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    private void checkForNulls() {
        int limit = this.gapStart;
        for (int i = 0; i != limit || limit == this.gapStart && (i = this.gapEnd) != (limit = this.array.length); ++i) {
            if (this.array[i] != null) continue;
            throw new IllegalArgumentException("cannot create sequence with null values");
        }
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return Util.newObjectArray(size);
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (Object[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected T getRawArrayElementAsObject(int index) {
        return this.array[index];
    }

    @Override
    protected ObjectArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        ObjectArraySequence copy = new ObjectArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    @Override
    public T get(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return this.getDefaultValue();
        }
        return this.array[position];
    }

    @Override
    public BitSet getBits(SequencePredicate<? super T> predicate) {
        int sz = this.size();
        BitSet bits = new BitSet(sz);
        for (int i = 0; i < sz; ++i) {
            int j = i;
            if (j >= this.gapStart) {
                j += this.gapEnd - this.gapStart;
            }
            if (!predicate.matches(this, i, this.array[j])) continue;
            bits.set(i);
        }
        return bits;
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length < 0 || sourceOffset + length > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                if (this.index == ObjectArraySequence.this.gapStart) {
                    this.index = ObjectArraySequence.this.gapEnd;
                }
                return this.index < ObjectArraySequence.this.array.length;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return ObjectArraySequence.this.array[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void add(T element) {
        if (element != null) {
            this.gapReserve(this.size(), 1);
            this.array[this.gapStart++] = element;
        }
    }

    @Override
    public void add(Sequence<? extends T> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    public void add(T[] data, int loIndex, int hiIndex) {
        this.addFromArray(data, loIndex, hiIndex);
    }

    public void replace(int position, T value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, T value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
        if (!hasTrigger) {
            this.clearOldValues(removed);
        }
    }

    @Override
    protected void replaceRaw(Sequence<? extends T> values, int sourceOffset, int length, int destPos) {
        values.toArray(sourceOffset, length, this.array, destPos);
    }

    protected <T> void insert(Sequence<? extends T> values, int vsize, int where) {
        this.gapReserve(where, vsize);
        values.toArray(this.array, where);
        this.gapStart += vsize;
    }

    @Override
    public void clearOldValues(int oldLength) {
        for (int i = this.gapEnd - oldLength; i < this.gapEnd; ++i) {
            this.array[i] = null;
        }
    }
}

