/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NumberRangeSequence
extends AbstractSequence<Float>
implements Sequence<Float> {
    private final float start;
    private final float step;
    private final int size;

    public NumberRangeSequence(float start, float bound, float step, boolean exclusive) {
        super(TypeInfo.Float);
        if (step == 0.0f) {
            throw new IllegalArgumentException("Range step of zero");
        }
        this.start = start;
        this.step = step;
        this.size = Sequences.calculateFloatRangeSize(start, bound, step, exclusive);
    }

    public NumberRangeSequence(float start, float bound, float step) {
        this(start, bound, step, false);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Float get(int position) {
        if (position < 0 || position >= this.size) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(this.start + (float)position * this.step);
    }

    @Override
    public float getAsFloat(int position) {
        if (position < 0 || position >= this.size) {
            return 0.0f;
        }
        return this.start + (float)position * this.step;
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        float value = this.start + (float)sourceOffset * this.step;
        for (int index = destOffset; index < destOffset + length; ++index) {
            dest[index] = Float.valueOf(value);
            value += this.step;
        }
    }
}

