/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArraySequence
extends ArraySequence<Long> {
    long[] array;

    public LongArraySequence(int initialSize, TypeInfo<Long> ti) {
        super(ti);
        this.array = new long[initialSize];
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public LongArraySequence(int initialSize) {
        this(initialSize, TypeInfo.Long);
    }

    public LongArraySequence() {
        this(16, TypeInfo.Long);
    }

    public LongArraySequence(TypeInfo<Long> ti, long ... values) {
        this(ti, values, false);
    }

    public LongArraySequence(TypeInfo<Long> ti, long[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = new long[values.length];
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
    }

    public LongArraySequence(long[] values, int startPos, int size) {
        super(TypeInfo.Long);
        this.array = new long[size];
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
    }

    public LongArraySequence(Sequence<? extends Long> seq) {
        super(TypeInfo.Long);
        int size = seq.size();
        this.array = new long[size];
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return new long[size];
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (long[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Long getRawArrayElementAsObject(int index) {
        return this.array[index];
    }

    public LongArraySequence makeNew(int initializeSize) {
        return new LongArraySequence(initializeSize, this.getElementType());
    }

    @Override
    public long getAsLong(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return 0L;
        }
        return this.array[position];
    }

    public void add(long element) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = element;
    }

    @Override
    public void add(Sequence<? extends Long> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, long[] dest, int destOffset) {
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    protected LongArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        LongArraySequence copy = new LongArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    public void replace(int position, long value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, long value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Long> values, int sourceOffset, int length, int startPos) {
        values.toArray(sourceOffset, length, this.array, startPos);
    }

    public static long extractOldElement(ArraySequence<Long> buffer, Sequence<? extends Long> oldValue, int startPos, int endPos, int k) {
        if (oldValue != null) {
            return oldValue.get(k);
        }
        if (k >= 0) {
            int alen;
            if (k >= startPos) {
                k += buffer.gapEnd - endPos;
            }
            if (k < (alen = buffer.getRawArrayLength())) {
                return buffer.getRawArrayElementAsObject(k);
            }
        }
        return (Long)buffer.getDefaultValue();
    }

    public static long extractNewElement(ArraySequence<Long> buffer, int loIndex, Sequence<? extends Long> newElements, int k) {
        if (newElements != null) {
            return newElements.get(k);
        }
        if (k >= 0 && (k += loIndex) < buffer.gapStart) {
            return buffer.get(k);
        }
        return (Long)buffer.getDefaultValue();
    }
}

