/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntRangeSequence
extends AbstractSequence<Integer>
implements Sequence<Integer> {
    private final int start;
    private final int step;
    private final int size;

    public IntRangeSequence(int start, int bound, int step, boolean exclusive) {
        super(TypeInfo.Integer);
        if (step == 0) {
            throw new IllegalArgumentException("Range step of zero");
        }
        this.start = start;
        this.step = step;
        this.size = Sequences.calculateIntRangeSize(start, bound, step, exclusive);
    }

    public IntRangeSequence(int start, int bound, int step) {
        this(start, bound, step, false);
    }

    public IntRangeSequence(int start, int bound) {
        this(start, bound, 1, false);
    }

    public IntRangeSequence(int start, int bound, boolean exclusive) {
        this(start, bound, 1, exclusive);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getAsInt(int position) {
        if (position < 0 || position >= this.size) {
            return 0;
        }
        return this.start + position * this.step;
    }

    @Override
    public Integer get(int position) {
        if (position < 0 || position >= this.size) {
            return 0;
        }
        return this.start + position * this.step;
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        if (sourceOffset < 0 || length > 0 && sourceOffset + length > this.size) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int value = this.start + sourceOffset * this.step;
        for (int index = destOffset; index < destOffset + length; ++index) {
            dest[index] = value;
            value += this.step;
        }
    }
}

