/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArraySequence
extends ArraySequence<Integer> {
    int[] array;

    public IntArraySequence(int initialSize, TypeInfo<Integer> ti) {
        super(ti);
        this.array = new int[initialSize];
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public IntArraySequence(int initialSize) {
        this(initialSize, TypeInfo.Integer);
    }

    public IntArraySequence() {
        this(16, TypeInfo.Integer);
    }

    public IntArraySequence(TypeInfo<Integer> ti, int ... values) {
        this(ti, values, false);
    }

    public IntArraySequence(TypeInfo<Integer> ti, int[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = new int[values.length];
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
    }

    public IntArraySequence(int[] values, int startPos, int size) {
        super(TypeInfo.Integer);
        this.array = new int[size];
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
    }

    public IntArraySequence(Sequence<? extends Integer> seq) {
        super(TypeInfo.Integer);
        int size = seq.size();
        this.array = new int[size];
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return new int[size];
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (int[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Integer getRawArrayElementAsObject(int index) {
        return this.array[index];
    }

    public IntArraySequence makeNew(int initializeSize) {
        return new IntArraySequence(initializeSize, this.getElementType());
    }

    @Override
    public int getAsInt(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return 0;
        }
        return this.array[position];
    }

    public void add(int element) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = element;
    }

    @Override
    public void add(Sequence<? extends Integer> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, int[] dest, int destOffset) {
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    protected IntArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        IntArraySequence copy = new IntArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    public void replace(int position, int value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, int value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Integer> values, int sourceOffset, int length, int startPos) {
        values.toArray(sourceOffset, length, this.array, startPos);
    }

    public static int extractOldElement(ArraySequence<Integer> buffer, Sequence<? extends Integer> oldValue, int startPos, int endPos, int k) {
        if (oldValue != null) {
            return oldValue.get(k);
        }
        if (k >= 0) {
            int alen;
            if (k >= startPos) {
                k += buffer.gapEnd - endPos;
            }
            if (k < (alen = buffer.getRawArrayLength())) {
                return buffer.getRawArrayElementAsObject(k);
            }
        }
        return (Integer)buffer.getDefaultValue();
    }

    public static int extractNewElement(ArraySequence<Integer> buffer, int loIndex, Sequence<? extends Integer> newElements, int k) {
        if (newElements != null) {
            return newElements.get(k);
        }
        if (k >= 0 && (k += loIndex) < buffer.gapStart) {
            return buffer.get(k);
        }
        return (Integer)buffer.getDefaultValue();
    }
}

