/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatArraySequence
extends ArraySequence<Float> {
    float[] array;

    public FloatArraySequence(int initialSize, TypeInfo<Float> ti) {
        super(ti);
        this.array = new float[initialSize];
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public FloatArraySequence(int initialSize) {
        this(initialSize, TypeInfo.Float);
    }

    public FloatArraySequence() {
        this(16, TypeInfo.Float);
    }

    public FloatArraySequence(TypeInfo<Float> ti, float ... values) {
        this(ti, values, false);
    }

    public FloatArraySequence(TypeInfo<Float> ti, float[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = new float[values.length];
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
    }

    public FloatArraySequence(float[] values, int startPos, int size) {
        super(TypeInfo.Float);
        this.array = new float[size];
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
    }

    public FloatArraySequence(Sequence<? extends Float> seq) {
        super(TypeInfo.Float);
        int size = seq.size();
        this.array = new float[size];
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return new float[size];
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (float[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Float getRawArrayElementAsObject(int index) {
        return Float.valueOf(this.array[index]);
    }

    public FloatArraySequence makeNew(int initializeSize) {
        return new FloatArraySequence(initializeSize, this.getElementType());
    }

    @Override
    public float getAsFloat(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return 0.0f;
        }
        return this.array[position];
    }

    public void add(float element) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = element;
    }

    @Override
    public void add(Sequence<? extends Float> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, float[] dest, int destOffset) {
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    protected FloatArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        FloatArraySequence copy = new FloatArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    public void replace(int position, float value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, float value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Float> values, int sourceOffset, int length, int startPos) {
        values.toArray(sourceOffset, length, this.array, startPos);
    }

    public static float extractOldElement(ArraySequence<Float> buffer, Sequence<? extends Float> oldValue, int startPos, int endPos, int k) {
        if (oldValue != null) {
            return oldValue.get(k).floatValue();
        }
        if (k >= 0) {
            int alen;
            if (k >= startPos) {
                k += buffer.gapEnd - endPos;
            }
            if (k < (alen = buffer.getRawArrayLength())) {
                return buffer.getRawArrayElementAsObject(k).floatValue();
            }
        }
        return ((Float)buffer.getDefaultValue()).floatValue();
    }

    public static float extractNewElement(ArraySequence<Float> buffer, int loIndex, Sequence<? extends Float> newElements, int k) {
        if (newElements != null) {
            return newElements.get(k).floatValue();
        }
        if (k >= 0 && (k += loIndex) < buffer.gapStart) {
            return buffer.get(k).floatValue();
        }
        return ((Float)buffer.getDefaultValue()).floatValue();
    }
}

