/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.Util;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DumbMutableSequence<T>
implements Iterable<T> {
    private T[] array;
    private int size;

    public DumbMutableSequence(T[] initialValues) {
        this(initialValues.length);
        System.arraycopy(initialValues, 0, this.array, 0, initialValues.length);
        this.size = initialValues.length;
    }

    public DumbMutableSequence(int initialSize) {
        this.array = Util.newObjectArray(Util.powerOfTwo(1, initialSize));
        this.size = 0;
    }

    public DumbMutableSequence() {
        this(8);
    }

    public T get(int i) {
        return i < 0 || i >= this.size ? null : (T)this.array[i];
    }

    public void set(int i, T value) {
        if (i < 0 && i > this.size) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        if (i == this.size && this.size + 1 < this.array.length) {
            T[] temp = Util.newObjectArray(Util.powerOfTwo(this.size, this.size + 1));
            System.arraycopy(this.array, 0, temp, 0, this.size);
            this.array[this.size++] = value;
        } else {
            this.array[i] = value;
        }
    }

    public void replaceSlice(int startPos, int endPos, T[] newElements) {
        int insertedCount = newElements.length;
        int deletedCount = endPos - startPos;
        int netAdded = insertedCount - deletedCount;
        if (netAdded == 0) {
            System.arraycopy(newElements, 0, this.array, startPos, insertedCount);
        } else if (this.size + netAdded < this.array.length) {
            System.arraycopy(this.array, endPos, this.array, endPos + netAdded, this.size - endPos);
            System.arraycopy(newElements, 0, this.array, startPos, insertedCount);
            if (netAdded < 0) {
                Arrays.fill(this.array, this.size + netAdded, this.size, null);
            }
            this.size += netAdded;
        } else {
            int newSize = this.size + netAdded;
            T[] temp = Util.newObjectArray(Util.powerOfTwo(this.size, newSize));
            System.arraycopy(this.array, 0, temp, 0, startPos);
            System.arraycopy(newElements, 0, temp, startPos, insertedCount);
            System.arraycopy(this.array, endPos, temp, startPos + insertedCount, this.size - endPos);
            this.array = temp;
            this.size = newSize;
        }
    }

    public Sequence<? extends T> replaceSlice(int startPos, int endPos, Sequence<? extends T> newElements) {
        int length = Sequences.size(newElements);
        Object[] temp = Util.newObjectArray(length);
        newElements.toArray(0, length, temp, 0);
        this.replaceSlice(startPos, endPos, temp);
        return newElements;
    }

    public Sequence<T> get(Class<T> clazz) {
        return Sequences.make(TypeInfo.getTypeInfo(clazz), this.array, this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DumbMutableSequence.this.size;
            }

            @Override
            public T next() {
                if (this.hasNext()) {
                    return DumbMutableSequence.this.array[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    void testValid() {
        int i;
        for (i = 0; i < this.size; ++i) {
            if (this.array[i] == null) {
                throw new AssertionError((Object)("Null element at " + i));
            }
        }
        for (i = this.size; i < this.array.length; ++i) {
            if (this.array[i] != null) {
                throw new AssertionError((Object)("Non-null element at " + i));
            }
        }
    }
}

