/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharArraySequence
extends ArraySequence<Character> {
    char[] array;

    public CharArraySequence(int initialSize, TypeInfo<Character> ti) {
        super(ti);
        this.array = new char[initialSize];
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public CharArraySequence(int initialSize) {
        this(initialSize, TypeInfo.Character);
    }

    public CharArraySequence() {
        this(16, TypeInfo.Character);
    }

    public CharArraySequence(TypeInfo<Character> ti, char ... values) {
        this(ti, values, false);
    }

    public CharArraySequence(TypeInfo<Character> ti, char[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = new char[values.length];
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
    }

    public CharArraySequence(char[] values, int startPos, int size) {
        super(TypeInfo.Character);
        this.array = new char[size];
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
    }

    public CharArraySequence(Sequence<? extends Character> seq) {
        super(TypeInfo.Character);
        int size = seq.size();
        this.array = new char[size];
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return new char[size];
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (char[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Character getRawArrayElementAsObject(int index) {
        return Character.valueOf(this.array[index]);
    }

    public CharArraySequence makeNew(int initializeSize) {
        return new CharArraySequence(initializeSize, this.getElementType());
    }

    @Override
    public char getAsChar(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return '\u0000';
        }
        return this.array[position];
    }

    public void add(char element) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = element;
    }

    @Override
    public void add(Sequence<? extends Character> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, char[] dest, int destOffset) {
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    protected CharArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        CharArraySequence copy = new CharArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    public void replace(int position, char value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, char value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Character> values, int sourceOffset, int length, int startPos) {
        values.toArray(sourceOffset, length, this.array, startPos);
    }

    public static char extractOldElement(ArraySequence<Character> buffer, Sequence<? extends Character> oldValue, int startPos, int endPos, int k) {
        if (oldValue != null) {
            return oldValue.get(k).charValue();
        }
        if (k >= 0) {
            int alen;
            if (k >= startPos) {
                k += buffer.gapEnd - endPos;
            }
            if (k < (alen = buffer.getRawArrayLength())) {
                return buffer.getRawArrayElementAsObject(k).charValue();
            }
        }
        return ((Character)buffer.getDefaultValue()).charValue();
    }

    public static char extractNewElement(ArraySequence<Character> buffer, int loIndex, Sequence<? extends Character> newElements, int k) {
        if (newElements != null) {
            return newElements.get(k).charValue();
        }
        if (k >= 0 && (k += loIndex) < buffer.gapStart) {
            return buffer.get(k).charValue();
        }
        return ((Character)buffer.getDefaultValue()).charValue();
    }
}

