/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArraySequence
extends ArraySequence<Byte> {
    byte[] array;

    public ByteArraySequence(int initialSize, TypeInfo<Byte> ti) {
        super(ti);
        this.array = new byte[initialSize];
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public ByteArraySequence(int initialSize) {
        this(initialSize, TypeInfo.Byte);
    }

    public ByteArraySequence() {
        this(16, TypeInfo.Byte);
    }

    public ByteArraySequence(TypeInfo<Byte> ti, byte ... values) {
        this(ti, values, false);
    }

    public ByteArraySequence(TypeInfo<Byte> ti, byte[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = new byte[values.length];
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
    }

    public ByteArraySequence(byte[] values, int startPos, int size) {
        super(TypeInfo.Byte);
        this.array = new byte[size];
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
    }

    public ByteArraySequence(Sequence<? extends Byte> seq) {
        super(TypeInfo.Byte);
        int size = seq.size();
        this.array = new byte[size];
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return new byte[size];
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (byte[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Byte getRawArrayElementAsObject(int index) {
        return this.array[index];
    }

    public ByteArraySequence makeNew(int initializeSize) {
        return new ByteArraySequence(initializeSize, this.getElementType());
    }

    @Override
    public byte getAsByte(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return 0;
        }
        return this.array[position];
    }

    public void add(byte element) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = element;
    }

    @Override
    public void add(Sequence<? extends Byte> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, byte[] dest, int destOffset) {
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    protected ByteArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        ByteArraySequence copy = new ByteArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    public void replace(int position, byte value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, byte value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Byte> values, int sourceOffset, int length, int startPos) {
        values.toArray(sourceOffset, length, this.array, startPos);
    }

    public static byte extractOldElement(ArraySequence<Byte> buffer, Sequence<? extends Byte> oldValue, int startPos, int endPos, int k) {
        if (oldValue != null) {
            return oldValue.get(k);
        }
        if (k >= 0) {
            int alen;
            if (k >= startPos) {
                k += buffer.gapEnd - endPos;
            }
            if (k < (alen = buffer.getRawArrayLength())) {
                return buffer.getRawArrayElementAsObject(k);
            }
        }
        return (Byte)buffer.getDefaultValue();
    }

    public static byte extractNewElement(ArraySequence<Byte> buffer, int loIndex, Sequence<? extends Byte> newElements, int k) {
        if (newElements != null) {
            return newElements.get(k);
        }
        if (k >= 0 && (k += loIndex) < buffer.gapStart) {
            return buffer.get(k);
        }
        return (Byte)buffer.getDefaultValue();
    }
}

