/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.FXBase;
import com.sun.javafx.runtime.FXObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BoundFor<T, PT>
extends FXBase {
    protected static final int BOUND_FOR_STATE_UNINITIALIZED = 0;
    protected static final int BOUND_FOR_STATE_PARTS_STABLE = 1;
    protected static final int BOUND_FOR_STATE_PARTS_INVALID = 2;
    protected static final int BOUND_FOR_STATE_PARTS_UPDATED = 3;
    protected byte state = 0;
    protected final boolean dependsOnIndex;
    protected boolean inWholesaleUpdate = true;
    protected final FXObject container;
    protected final int forVarNum;
    protected final int inductionSeqVarNum;
    public int partResultVarNum;
    protected FXForPart<PT>[] parts;
    protected int numParts;
    protected int lowestInvalidPart;
    protected int highestInvalidPart = -1;
    protected int pendingTriggers = 0;
    protected int sizeAtLastTrigger = 0;
    protected static final boolean DEBUG = false;

    public BoundFor(FXObject container, int forVarNum, int inductionSeqVarNum, boolean dependsOnIndex) {
        this.container = container;
        this.forVarNum = forVarNum;
        this.inductionSeqVarNum = inductionSeqVarNum;
        this.dependsOnIndex = dependsOnIndex;
    }

    public abstract FXForPart makeForPart$(int var1);

    @Override
    public boolean update$(FXObject src, int depNum, int startPos, int endPos, int newLength, int phase) {
        if (this.state == 0 || this.inWholesaleUpdate) {
            return true;
        }
        int ipart = ((FXForPart)src).getIndex$();
        if ((phase & 8) == 0) {
            if (this.highestInvalidPart < 0) {
                this.highestInvalidPart = this.lowestInvalidPart = ipart;
                this.pendingTriggers = 1;
                if (this.state == 1) {
                    this.blanketInvalidationOfBoundFor();
                }
            } else {
                ++this.pendingTriggers;
                if (ipart < this.lowestInvalidPart) {
                    this.lowestInvalidPart = ipart;
                }
                if (ipart > this.highestInvalidPart) {
                    this.highestInvalidPart = ipart;
                }
            }
            return true;
        }
        if (this.highestInvalidPart < 0) {
            return true;
        }
        --this.pendingTriggers;
        if (this.pendingTriggers <= 0) {
            assert (this.pendingTriggers == 0);
            if (this.state == 2) {
                return true;
            }
            if (this.state == 3) {
                this.triggerAll();
                return true;
            }
            return this.trigger(ipart, startPos, endPos, newLength);
        }
        return true;
    }

    protected boolean trigger(int ignoreIpart, int ignoreStartPos, int ignoreEndPos, int ignoreNewLength) {
        int oldStartPos = this.cachedCumLength(this.lowestInvalidPart);
        int oldEndPos = this.cachedCumLength(this.highestInvalidPart + 1);
        this.restoreValidState(this.lowestInvalidPart, this.highestInvalidPart + 1);
        this.decacheLengths();
        int newEndPos = this.cumLength(this.highestInvalidPart + 1);
        this.fireTrigger(oldStartPos, oldEndPos, newEndPos);
        return true;
    }

    protected final void triggerAll() {
        assert (this.pendingTriggers == 0);
        int previousSize = this.decacheLengths();
        this.restoreValidState(0, this.numParts);
        this.fireTrigger(0, previousSize, this.sizeAtLastTrigger);
    }

    protected final void fireTrigger(int invStartPos, int invEndPos, int newEndPos) {
        this.state = 1;
        this.highestInvalidPart = -1;
        this.inWholesaleUpdate = false;
        this.pendingTriggers = 0;
        this.container.invalidate$(this.forVarNum, invStartPos, invEndPos, newEndPos - invStartPos, 92);
    }

    public void replaceParts(int startPart, int endPart, int insertedParts, int phase) {
        int trailingLength;
        int oldEndPos;
        int oldStartPos;
        boolean outstandingInvalidations;
        if (this.state == 0) {
            return;
        }
        boolean bl = outstandingInvalidations = this.highestInvalidPart >= 0;
        if ((phase & 8) == 0) {
            if (this.state == 1 && !outstandingInvalidations) {
                this.blanketInvalidationOfBoundFor();
            }
            this.state = (byte)2;
            return;
        }
        if (startPart < 0) {
            if (outstandingInvalidations) {
                startPart = this.lowestInvalidPart;
                endPart = this.highestInvalidPart;
                insertedParts = this.highestInvalidPart - this.lowestInvalidPart;
            } else {
                this.container.invalidate$(this.forVarNum, -1000, -1000, 0, 65);
                return;
            }
        }
        int newEndPart = startPart + insertedParts;
        int deltaParts = newEndPart - endPart;
        int newNumParts = this.numParts + deltaParts;
        this.inWholesaleUpdate = true;
        if (this.parts == null) {
            assert (startPart == 0);
            assert (endPart == 0);
            oldStartPos = 0;
            oldEndPos = 0;
            trailingLength = 0;
            FXForPart[] newParts = new FXForPart[newNumParts];
            this.parts = newParts;
            this.numParts = newNumParts;
            this.buildParts(0, insertedParts);
        } else {
            int ips;
            oldStartPos = this.cachedCumLength(startPart);
            oldEndPos = this.cachedCumLength(endPart);
            trailingLength = this.numParts - endPart;
            int endPartCopy = newEndPart < endPart ? newEndPart : endPart;
            for (ips = startPart; ips < endPartCopy; ++ips) {
                this.syncInductionVar(ips);
            }
            if (newNumParts != this.numParts) {
                for (ips = endPartCopy; ips < endPart; ++ips) {
                    BoundFor.removeDependent$(this.parts[ips], this.partResultVarNum, this);
                }
                FXForPart[] newParts = new FXForPart[newNumParts];
                System.arraycopy(this.parts, 0, newParts, 0, endPartCopy);
                System.arraycopy(this.parts, endPart, newParts, newEndPart, trailingLength);
                this.parts = newParts;
                this.numParts = newNumParts;
                this.buildParts(endPartCopy, newEndPart);
            }
        }
        assert (startPart + insertedParts + trailingLength == this.numParts);
        for (int ips = newEndPart; ips < this.numParts; ++ips) {
            this.getPart(ips).adjustIndex$(deltaParts);
        }
        this.state = (byte)3;
        this.inWholesaleUpdate = false;
        if (this.pendingTriggers == 0) {
            assert (this.pendingTriggers == 0);
            if (outstandingInvalidations) {
                this.triggerAll();
            } else {
                int previousSize = this.decacheLengths();
                if (this.dependsOnIndex) {
                    this.restoreValidState(startPart, this.numParts);
                    this.fireTrigger(oldStartPos, previousSize, this.sizeAtLastTrigger);
                } else {
                    this.restoreValidState(startPart, newEndPart);
                    this.fireTrigger(oldStartPos, oldEndPos, this.cumLength(newEndPart));
                }
            }
        }
    }

    protected abstract int decacheLengths();

    void showStates(String label) {
        for (int ips = 0; ips < this.numParts; ++ips) {
            System.err.print(this.getPart(ips).getFlags$(this.partResultVarNum) & 7);
        }
        System.err.println(" - " + label);
    }

    protected abstract int cumLength(int var1);

    protected abstract int cachedCumLength(int var1);

    protected abstract void restoreValidState(int var1, int var2);

    protected void initializeIfNeeded() {
        if (this.state == 0) {
            int sz = this.container.size$(this.inductionSeqVarNum);
            this.state = 1;
            this.sizeAtLastTrigger = 0;
            this.replaceParts(0, 0, sz, 65);
            this.replaceParts(0, 0, sz, 92);
        }
    }

    protected FXForPart<PT> getPart(int ipart) {
        return this.parts[ipart];
    }

    protected final void blanketInvalidationOfBoundFor() {
        this.container.invalidate$(this.forVarNum, 0, -1000, -1000, 65);
    }

    protected void syncInductionVar(int ipart) {
        FXForPart<Object> part = this.getPart(ipart);
        part.setInductionVar$(this.container.elem$(this.inductionSeqVarNum, ipart));
    }

    protected void buildParts(int ipFrom, int ipTo) {
        for (int ips = ipFrom; ips < ipTo; ++ips) {
            FXForPart part;
            this.parts[ips] = part = this.makeForPart$(ips);
            this.syncInductionVar(ips);
            BoundFor.addDependent$(part, this.partResultVarNum, this, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FXForPart<PT>
    extends FXObject {
        public int getIndex$();

        public void adjustIndex$(int var1);

        public void setInductionVar$(PT var1);
    }
}

