/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanArraySequence
extends ArraySequence<Boolean> {
    boolean[] array;

    public BooleanArraySequence(int initialSize, TypeInfo<Boolean> ti) {
        super(ti);
        this.array = new boolean[initialSize];
        this.gapStart = 0;
        this.gapEnd = initialSize;
    }

    public BooleanArraySequence(int initialSize) {
        this(initialSize, TypeInfo.Boolean);
    }

    public BooleanArraySequence() {
        this(16, TypeInfo.Boolean);
    }

    public BooleanArraySequence(TypeInfo<Boolean> ti, boolean ... values) {
        this(ti, values, false);
    }

    public BooleanArraySequence(TypeInfo<Boolean> ti, boolean[] values, boolean handoff) {
        super(ti);
        if (handoff) {
            this.array = values;
        } else {
            this.array = new boolean[values.length];
            System.arraycopy(values, 0, this.array, 0, values.length);
        }
        this.gapStart = this.gapEnd = values.length;
    }

    public BooleanArraySequence(boolean[] values, int startPos, int size) {
        super(TypeInfo.Boolean);
        this.array = new boolean[size];
        System.arraycopy(values, startPos, this.array, 0, size);
        this.gapStart = this.gapEnd = size;
    }

    public BooleanArraySequence(Sequence<? extends Boolean> seq) {
        super(TypeInfo.Boolean);
        int size = seq.size();
        this.array = new boolean[size];
        seq.toArray(0, size, this.array, 0);
        this.gapStart = this.gapEnd = size;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int size) {
        return new boolean[size];
    }

    @Override
    protected void setRawArray(Object array) {
        this.array = (boolean[])array;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Boolean getRawArrayElementAsObject(int index) {
        return this.array[index];
    }

    public BooleanArraySequence makeNew(int initializeSize) {
        return new BooleanArraySequence(initializeSize, this.getElementType());
    }

    @Override
    public boolean getAsBoolean(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return false;
        }
        return this.array[position];
    }

    public void add(boolean element) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = element;
    }

    @Override
    public void add(Sequence<? extends Boolean> elements) {
        int length = Sequences.size(elements);
        if (length > 0) {
            int size = this.size();
            this.gapReserve(size, length);
            elements.toArray(0, length, this.array, size);
            this.gapStart += length;
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, boolean[] dest, int destOffset) {
        int beforeGap = this.gapStart - sourceOffset;
        if (beforeGap >= 0) {
            if (length <= beforeGap) {
                beforeGap = length;
            }
            System.arraycopy(this.array, sourceOffset, dest, destOffset, beforeGap);
            length -= beforeGap;
            destOffset += beforeGap;
            sourceOffset = this.gapEnd;
        } else {
            sourceOffset += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, sourceOffset, dest, destOffset, length);
    }

    @Override
    protected BooleanArraySequence extractOldValue(int startPos, int endPos) {
        int oldSize = this.array.length - this.gapEnd + endPos;
        BooleanArraySequence copy = new BooleanArraySequence(oldSize, this.getElementType());
        copy.addFromArray(this.array, 0, startPos);
        copy.addFromArray(this.array, this.gapEnd - endPos + startPos, this.array.length);
        return copy;
    }

    public void replace(int position, boolean value) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.array.length) {
            return;
        }
        this.array[position] = value;
    }

    public void replace(int startPos, int endPos, boolean value, boolean hasTrigger) {
        if (endPos == startPos + 1 && !hasTrigger) {
            this.replace(startPos, value);
            return;
        }
        int size = this.size();
        int removed = endPos - startPos;
        this.gapReserve(startPos, removed == 0 || hasTrigger ? 1 : 0);
        this.gapEnd = startPos + this.array.length - size + removed;
        this.array[startPos++] = value;
        this.gapStart = startPos;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Boolean> values, int sourceOffset, int length, int startPos) {
        values.toArray(sourceOffset, length, this.array, startPos);
    }

    public static boolean extractOldElement(ArraySequence<Boolean> buffer, Sequence<? extends Boolean> oldValue, int startPos, int endPos, int k) {
        if (oldValue != null) {
            return oldValue.get(k);
        }
        if (k >= 0) {
            int alen;
            if (k >= startPos) {
                k += buffer.gapEnd - endPos;
            }
            if (k < (alen = buffer.getRawArrayLength())) {
                return buffer.getRawArrayElementAsObject(k);
            }
        }
        return (Boolean)buffer.getDefaultValue();
    }

    public static boolean extractNewElement(ArraySequence<Boolean> buffer, int loIndex, Sequence<? extends Boolean> newElements, int k) {
        if (newElements != null) {
            return newElements.get(k);
        }
        if (k >= 0 && (k += loIndex) < buffer.gapStart) {
            return buffer.get(k);
        }
        return (Boolean)buffer.getDefaultValue();
    }
}

