/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.ObjectArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArraySequence<T>
extends AbstractSequence<T> {
    int gapStart;
    int gapEnd;
    protected static final int DEFAULT_SIZE = 16;
    private int sharing;

    protected ArraySequence(TypeInfo<T> ti) {
        super(ti);
    }

    @Override
    public void incrementSharing() {
        int sh = this.sharing + 1;
        if (sh >= 0) {
            this.sharing = sh;
        }
    }

    @Override
    public void decrementSharing() {
        int sh = this.sharing;
        if (sh > 0) {
            this.sharing = sh - 1;
        }
    }

    public void setMaxShared() {
        this.sharing = Integer.MAX_VALUE;
    }

    public boolean isShared() {
        return this.sharing > 1;
    }

    protected abstract Object getRawArray();

    protected abstract Object newRawArray(int var1);

    protected abstract void setRawArray(Object var1);

    protected abstract int getRawArrayLength();

    protected abstract T getRawArrayElementAsObject(int var1);

    public ArraySequence<T> makeNew(int initializeSize) {
        return new ObjectArraySequence(initializeSize, this.getElementType());
    }

    protected abstract ArraySequence extractOldValue(int var1, int var2);

    public abstract void add(Sequence<? extends T> var1);

    public void addFromArray(Object data, int loIndex, int hiIndex) {
        int length = hiIndex - loIndex;
        int size = this.size();
        this.gapReserve(size, length);
        System.arraycopy(data, loIndex, this.getRawArray(), size, length);
        this.gapStart += length;
    }

    protected void shiftGap(int newGapStart) {
        int delta = newGapStart - this.gapStart;
        Object array = this.getRawArray();
        if (delta > 0) {
            System.arraycopy(array, this.gapEnd, array, this.gapStart, delta);
        } else if (delta < 0) {
            System.arraycopy(array, newGapStart, array, this.gapEnd + delta, -delta);
        }
        this.gapEnd += delta;
        this.gapStart = newGapStart;
        int gapSize = this.gapEnd - this.gapStart;
        if (delta > 0) {
            if (gapSize < delta) {
                this.clearOldValues(gapSize);
            } else {
                this.clearOldValues(delta);
            }
        } else if (gapSize < -delta) {
            this.clearOldValues(gapSize);
        } else {
            int tmpGapEnd = this.gapEnd;
            this.gapEnd = this.gapStart - delta;
            this.clearOldValues(-delta);
            this.gapEnd = tmpGapEnd;
        }
    }

    protected void gapReserve(int where, int needed) {
        if (needed > this.gapEnd - this.gapStart) {
            int startLength;
            int minLength;
            int oldLength = this.getRawArrayLength();
            int newLength = oldLength < 16 ? 16 : 2 * oldLength;
            if (newLength < (minLength = oldLength - (this.gapEnd - this.gapStart) + needed)) {
                newLength = minLength;
            }
            Object newArray = this.newRawArray(newLength);
            int oldGapSize = this.gapEnd - this.gapStart;
            int size = oldLength - oldGapSize;
            int newGapEnd = newLength - size + where;
            int gapDelta = this.gapStart - where;
            Object oldArray = this.getRawArray();
            if (gapDelta >= 0) {
                startLength = where;
                int endLength = oldLength - this.gapEnd;
                System.arraycopy(oldArray, this.gapEnd, newArray, newLength - endLength, endLength);
                if (gapDelta > 0) {
                    System.arraycopy(oldArray, where, newArray, newGapEnd, gapDelta);
                }
            } else {
                startLength = this.gapStart;
                int endLength = newLength - newGapEnd;
                System.arraycopy(oldArray, oldLength - endLength, newArray, newGapEnd, endLength);
                System.arraycopy(oldArray, this.gapEnd, newArray, this.gapStart, -gapDelta);
            }
            System.arraycopy(oldArray, 0, newArray, 0, startLength);
            this.setRawArray(newArray);
            this.gapStart = where;
            this.gapEnd = newGapEnd;
        } else if (where != this.gapStart) {
            this.shiftGap(where);
        }
    }

    @Override
    public int size() {
        return this.getRawArrayLength() - (this.gapEnd - this.gapStart);
    }

    @Override
    public T get(int position) {
        if (position >= this.gapStart) {
            position += this.gapEnd - this.gapStart;
        }
        if (position < 0 || position >= this.getRawArrayLength()) {
            return this.getDefaultValue();
        }
        return this.getRawArrayElementAsObject(position);
    }

    public void replace(int startPos, int endPos, Sequence<? extends T> source, int sourceStart, int sourceEnd, boolean hasTrigger) {
        int size = this.size();
        int nsize = sourceEnd - sourceStart;
        int delta = nsize - (endPos - startPos);
        this.gapReserve(startPos, hasTrigger ? nsize : (delta >= 0 ? delta : 0));
        if (nsize != 0) {
            this.replaceRaw(source, sourceStart, nsize, startPos);
        }
        this.gapStart = startPos += nsize;
        this.gapEnd = startPos + (this.getRawArrayLength() - size - delta);
    }

    protected abstract void replaceRaw(Sequence<? extends T> var1, int var2, int var3, int var4);

    public void clearOldValues(int oldLength) {
    }
}

