/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.SequencePredicate;
import com.sun.javafx.runtime.sequence.Sequences;
import java.util.BitSet;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSequence<T>
implements Sequence<T>,
Formattable {
    protected TypeInfo<T> ti;

    protected AbstractSequence(TypeInfo<T> ti) {
        this.ti = ti;
    }

    @Override
    public abstract int size();

    public boolean isNumeric() {
        return this.ti.isNumeric();
    }

    @Override
    public abstract T get(int var1);

    @Override
    public boolean getAsBoolean(int position) {
        return (Boolean)this.get(position);
    }

    @Override
    public char getAsChar(int position) {
        return ((Character)this.get(position)).charValue();
    }

    @Override
    public byte getAsByte(int position) {
        return ((Number)this.get(position)).byteValue();
    }

    @Override
    public short getAsShort(int position) {
        return ((Number)this.get(position)).shortValue();
    }

    @Override
    public int getAsInt(int position) {
        return ((Number)this.get(position)).intValue();
    }

    @Override
    public long getAsLong(int position) {
        return ((Number)this.get(position)).longValue();
    }

    @Override
    public float getAsFloat(int position) {
        return ((Number)this.get(position)).floatValue();
    }

    @Override
    public double getAsDouble(int position) {
        return ((Number)this.get(position)).doubleValue();
    }

    @Override
    public Sequence<T> getSlice(int startPos, int endPos) {
        return Sequences.subsequence(this, startPos, endPos);
    }

    @Override
    public BitSet getBits(SequencePredicate<? super T> predicate) {
        int length = this.size();
        BitSet bits = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            if (!predicate.matches(this, i, this.get(i))) continue;
            bits.set(i);
        }
        return bits;
    }

    @Override
    public TypeInfo<T> getElementType() {
        return this.ti;
    }

    @Override
    public T getDefaultValue() {
        return this.ti.defaultValue;
    }

    @Override
    public Sequence<T> getEmptySequence() {
        return this.ti.emptySequence;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void toArray(Object[] dest, int destOffset) {
        this.toArray(0, this.size(), dest, destOffset);
    }

    @Override
    public void toArray(int sourceOffset, int length, Object[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.get(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, int[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsInt(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, double[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsDouble(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, float[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsFloat(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, short[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsShort(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, char[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsChar(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, long[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsLong(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, boolean[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsBoolean(i + sourceOffset);
        }
    }

    @Override
    public void toArray(int sourceOffset, int length, byte[] dest, int destOffset) {
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.getAsByte(i + sourceOffset);
        }
    }

    @Override
    public Sequence<T> get(SequencePredicate<? super T> predicate) {
        return Sequences.filter(this, this.getBits(predicate));
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(0, this.size() - 1);
    }

    @Override
    public final Iterator<T> iterator(final int startPos, final int lastPos) {
        return new Iterator<T>(){
            private int cur;
            private final int last;
            {
                this.cur = Math.min(Math.max(0, startPos), AbstractSequence.this.size());
                this.last = Math.min(Math.max(this.cur, lastPos + 1), AbstractSequence.this.size());
            }

            @Override
            public boolean hasNext() {
                return this.cur < this.last;
            }

            @Override
            public T next() {
                if (this.cur >= this.last) {
                    throw new NoSuchElementException();
                }
                return AbstractSequence.this.get(this.cur++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof Sequence && Sequences.isEqual(this, (Sequence)obj);
    }

    public int hashCode() {
        int hash = 0;
        for (T val : this) {
            hash = 31 * hash + (val != null ? val.hashCode() : 0);
        }
        return hash;
    }

    @Override
    public void incrementSharing() {
    }

    @Override
    public void decrementSharing() {
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[ ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        for (T val : this) {
            sb.append(val);
            sb.append(", ");
        }
        int length = sb.length();
        if (length > 1) {
            sb.delete(length - 2, length);
        }
        sb.append(" ]");
        return sb.toString();
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        for (T val : this) {
            formatter.format("%s", val);
        }
    }
}

