/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.liveconnect;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.ConversionDelegate;
import java.util.List;
import javafx.reflect.FXClassType;
import javafx.reflect.FXLocal;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceType;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class FXConversionDelegate
implements ConversionDelegate {
    private FXLocal.Context context = FXLocal.getContext();
    private Bridge bridge;
    private static final int TOSTRING_CONVERSION_PENALTY = 50;
    private static final int JSOBJECT_CONVERSION_PENALTY = 2500;
    private FXType booleanType;
    private FXType charType;
    private FXType byteType;
    private FXType shortType;
    private FXType integerType;
    private FXType longType;
    private FXType floatType;
    private FXType doubleType;

    public FXConversionDelegate(Bridge bridge) {
        this.bridge = bridge;
        this.booleanType = this.context.getBooleanType();
        this.charType = this.context.getCharacterType();
        this.byteType = this.context.getByteType();
        this.shortType = this.context.getShortType();
        this.integerType = this.context.getIntegerType();
        this.longType = this.context.getLongType();
        this.floatType = this.context.getFloatType();
        this.doubleType = this.context.getDoubleType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int conversionCost(Object arg, Object toType) {
        FXClassType argType;
        if (!(toType instanceof FXType)) {
            return -1;
        }
        FXType targetType = (FXType)toType;
        if (arg == null) {
            if (!(targetType instanceof FXPrimitiveType)) return 0;
            return -1;
        }
        if (targetType instanceof FXPrimitiveType) {
            if (targetType.equals(this.floatType) ? arg instanceof Float : (targetType.equals(this.doubleType) ? arg instanceof Double : (targetType.equals(this.booleanType) ? arg instanceof Boolean : (targetType.equals(this.integerType) ? arg instanceof Integer : (targetType.equals(this.longType) ? arg instanceof Long : (targetType.equals(this.shortType) ? arg instanceof Short : (targetType.equals(this.byteType) ? arg instanceof Byte : targetType.equals(this.charType) && arg instanceof Character))))))) {
                return 0;
            }
            if (!(arg instanceof String) && !(arg instanceof Number) && !(arg instanceof Character) && !(arg instanceof Boolean)) return -1;
            return 1;
        }
        if (arg instanceof JSObject) {
            if (!this.canConvert((JSObject)arg, targetType)) return -1;
            return 2500;
        }
        if (!(targetType instanceof FXClassType)) {
            return -1;
        }
        if (arg instanceof FXValue) {
            if (!(arg instanceof FXObjectValue)) return -1;
            argType = ((FXObjectValue)arg).getClassType();
        } else {
            argType = this.context.makeClassRef(arg.getClass());
        }
        if (!argType.equals(targetType)) return this.conversionDistance(argType, (FXClassType)targetType);
        return 0;
    }

    private int conversionDistance(FXClassType fromType, FXClassType toType) {
        int res = this.conversionDistance(fromType, toType, 0);
        if (res == Integer.MAX_VALUE) {
            return -1;
        }
        return res;
    }

    private int conversionDistance(FXClassType fromType, FXClassType toType, int depth) {
        if (fromType.equals(toType)) {
            return depth;
        }
        List<FXClassType> supers = fromType.getSuperClasses(false);
        int minDepth = Integer.MAX_VALUE;
        for (FXClassType type : supers) {
            minDepth = Math.min(minDepth, this.conversionDistance(type, toType, 1 + depth));
        }
        return minDepth;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean convert(Object obj, Object toType, Object[] result) throws Exception {
        void var5_10;
        if (!(toType instanceof FXType)) {
            return false;
        }
        FXType targetType = (FXType)toType;
        if (obj == null) {
            return true;
        }
        if (targetType instanceof FXPrimitiveType) {
            boolean bl = obj instanceof Number;
            if (targetType.equals(this.floatType)) {
                if (bl) {
                    result[0] = this.context.mirrorOf(((Number)obj).floatValue());
                    return true;
                }
                if (obj instanceof String) {
                    result[0] = this.context.mirrorOf(Float.valueOf((String)obj));
                    return true;
                }
                if (obj instanceof Boolean) {
                    result[0] = this.context.mirrorOf((Boolean)obj != false ? 1.0f : 0.0f);
                    return true;
                }
                if (!(obj instanceof Character)) throw FXConversionDelegate.inconvertible(obj, targetType);
                result[0] = this.context.mirrorOf((float)((Character)obj).charValue());
                return true;
            }
            if (targetType.equals(this.doubleType)) {
                if (bl) {
                    result[0] = this.context.mirrorOf(((Number)obj).doubleValue());
                    return true;
                }
                if (obj instanceof String) {
                    result[0] = this.context.mirrorOf(Double.valueOf((String)obj));
                    return true;
                }
                if (obj instanceof Boolean) {
                    result[0] = this.context.mirrorOf((Boolean)obj != false ? 1.0 : 0.0);
                    return true;
                }
                if (!(obj instanceof Character)) throw FXConversionDelegate.inconvertible(obj, targetType);
                result[0] = this.context.mirrorOf((double)((Character)obj).charValue());
                return true;
            }
            if (targetType.equals(this.integerType)) {
                if (bl) {
                    result[0] = this.context.mirrorOf(((Number)obj).intValue());
                    return true;
                }
                if (obj instanceof String) {
                    result[0] = this.context.mirrorOf(Integer.valueOf((String)obj));
                    return true;
                }
                if (obj instanceof Boolean) {
                    result[0] = this.context.mirrorOf((Boolean)obj != false ? 1 : 0);
                    return true;
                }
                if (!(obj instanceof Character)) throw FXConversionDelegate.inconvertible(obj, targetType);
                result[0] = this.context.mirrorOf((int)((Character)obj).charValue());
                return true;
            }
            if (targetType.equals(this.longType)) {
                if (bl) {
                    result[0] = this.context.mirrorOf(((Number)obj).longValue());
                    return true;
                }
                if (obj instanceof String) {
                    result[0] = this.context.mirrorOf(Long.valueOf((String)obj));
                    return true;
                }
                if (obj instanceof Boolean) {
                    result[0] = this.context.mirrorOf((Boolean)obj != false ? 1L : 0L);
                    return true;
                }
                if (!(obj instanceof Character)) throw FXConversionDelegate.inconvertible(obj, targetType);
                result[0] = this.context.mirrorOf((long)((Character)obj).charValue());
                return true;
            }
            if (targetType.equals(this.shortType)) {
                if (bl) {
                    result[0] = this.context.mirrorOf(((Number)obj).shortValue());
                    return true;
                }
                if (obj instanceof String) {
                    result[0] = this.context.mirrorOf(Short.valueOf((String)obj));
                    return true;
                }
                if (obj instanceof Boolean) {
                    result[0] = this.context.mirrorOf((Boolean)obj != false ? (short)1 : 0);
                    return true;
                }
                if (!(obj instanceof Character)) throw FXConversionDelegate.inconvertible(obj, targetType);
                result[0] = this.context.mirrorOf((short)((Character)obj).charValue());
                return true;
            }
            if (targetType.equals(this.byteType)) {
                if (bl) {
                    result[0] = this.context.mirrorOf(((Number)obj).byteValue());
                    return true;
                }
                if (obj instanceof String) {
                    result[0] = this.context.mirrorOf(Byte.valueOf((String)obj));
                    return true;
                }
                if (obj instanceof Boolean) {
                    result[0] = this.context.mirrorOf((Boolean)obj != false ? (byte)1 : 0);
                    return true;
                }
                if (!(obj instanceof Character)) throw FXConversionDelegate.inconvertible(obj, targetType);
                result[0] = this.context.mirrorOf((byte)((Character)obj).charValue());
                return true;
            }
            if (!targetType.equals(this.booleanType)) throw FXConversionDelegate.inconvertible(obj, targetType);
            if (obj instanceof Boolean) {
                result[0] = this.context.mirrorOf((Boolean)obj);
                return true;
            }
            if (bl) {
                double d = ((Number)obj).doubleValue();
                result[0] = this.context.mirrorOf(!Double.isNaN(d) && d != 0.0);
                return true;
            }
            if (obj instanceof String) {
                result[0] = this.context.mirrorOf(((String)obj).length() != 0);
                return true;
            }
            if (!(obj instanceof Character)) throw FXConversionDelegate.inconvertible(obj, targetType);
            result[0] = this.context.mirrorOf(((Character)obj).charValue() != '\u0000');
            return true;
        }
        if (obj instanceof JSObject) {
            if (this.isStringType(targetType)) {
                result[0] = this.context.mirrorOf(obj.toString());
            } else {
                if (!(targetType instanceof FXSequenceType)) throw FXConversionDelegate.inconvertible(obj, targetType);
                try {
                    JSObject jSObject = (JSObject)obj;
                    FXType componentType = ((FXSequenceType)targetType).getComponentType();
                    int length = ((Number)jSObject.getMember("length")).intValue();
                    FXValue[] values = new FXValue[length];
                    Object[] tmp = new Object[1];
                    for (int i = 0; i < length; ++i) {
                        Object element = null;
                        try {
                            element = jSObject.getSlot(i);
                        }
                        catch (JSException e) {
                            // empty catch block
                        }
                        if (element == null) continue;
                        this.convert(element, componentType, tmp);
                        values[i] = (FXValue)tmp[0];
                    }
                    result[0] = this.context.makeSequence(componentType, values);
                    return true;
                }
                catch (Exception exception) {
                    throw FXConversionDelegate.inconvertible(obj, targetType, exception);
                }
            }
        }
        if (!(targetType instanceof FXClassType)) {
            throw FXConversionDelegate.inconvertible(obj, targetType);
        }
        if (obj instanceof FXValue) {
            if (!(obj instanceof FXObjectValue)) throw FXConversionDelegate.inconvertible(obj, targetType);
            FXClassType fXClassType = ((FXObjectValue)obj).getClassType();
        } else {
            FXLocal.ClassType classType = this.context.makeClassRef(obj.getClass());
        }
        if (!targetType.isAssignableFrom((FXType)var5_10)) {
            throw FXConversionDelegate.inconvertible((FXType)var5_10, targetType);
        }
        result[0] = obj instanceof FXValue ? (FXValue)obj : this.context.mirrorOf(obj);
        return true;
    }

    private boolean isStringType(FXType targetType) {
        return targetType instanceof FXLocal.ClassType && ((FXLocal.ClassType)targetType).getJavaImplementationClass() == String.class;
    }

    private boolean canConvert(JSObject obj, FXType targetType) {
        if (this.isStringType(targetType)) {
            return true;
        }
        if (targetType instanceof FXSequenceType) {
            try {
                obj.getMember("length");
                return true;
            }
            catch (JSException jSException) {
                // empty catch block
            }
        }
        return false;
    }

    private static IllegalArgumentException inconvertible(Object object, FXType toType) {
        return FXConversionDelegate.inconvertible(object, toType, null);
    }

    private static IllegalArgumentException inconvertible(Object object, FXType toType, Exception cause) {
        IllegalArgumentException exc = new IllegalArgumentException("Object " + object + " can not be converted to " + toType);
        if (cause != null) {
            exc.initCause(cause);
        }
        return exc;
    }

    private static IllegalArgumentException inconvertible(FXType objectType, FXType targetType) {
        return FXConversionDelegate.inconvertible(objectType, targetType, null);
    }

    private static IllegalArgumentException inconvertible(FXType objectType, FXType targetType, Exception cause) {
        IllegalArgumentException exc = new IllegalArgumentException("FXType " + objectType.getName() + " can not be converted to " + targetType.getName());
        if (cause != null) {
            exc.initCause(cause);
        }
        return exc;
    }
}

