/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.liveconnect;

import com.sun.java.browser.plugin2.liveconnect.v1.Bridge;
import com.sun.java.browser.plugin2.liveconnect.v1.Result;
import com.sun.javafx.runtime.liveconnect.FXTypeDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.reflect.FXClassType;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXFunctionType;
import javafx.reflect.FXObjectValue;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;
import javafx.reflect.FXVarMember;

public class FXClassDelegate
extends FXTypeDelegate {
    private FXClassType clazz;
    private Bridge bridge;
    private Map<String, FXVarMember> varMap;
    private Map<String, FXVarMember> lowerCaseVarMap;
    private Map<String, FunctionBundle> functionMap;
    private Map<String, FunctionBundle> lowerCaseFunctionMap;

    public FXClassDelegate(FXClassType clazz, Bridge bridge) {
        this.clazz = clazz;
        this.bridge = bridge;
    }

    public boolean invoke(String methodName, Object receiver, Object[] arguments, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
        FunctionBundle bundle;
        if (this.functionMap == null) {
            this.collectFunctions();
        }
        if ((bundle = this.functionMap.get(methodName)) == null) {
            bundle = this.lowerCaseFunctionMap.get(methodName.toLowerCase());
        }
        if (bundle == null) {
            throw new NoSuchMethodException(methodName + " in class: " + this.clazz.getName());
        }
        result[0] = bundle.invoke(receiver, arguments);
        return true;
    }

    public boolean getField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, Result[] result) throws Exception {
        FXValue val = this.getField0(fieldName, receiver, isStatic, objectIsApplet);
        if (val != null) {
            result[0] = new Result(this.unbox(val), false);
        }
        return true;
    }

    private FXValue getField0(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet) throws Exception {
        FXVarMember var;
        if (this.varMap == null) {
            this.collectVariables();
        }
        if ((var = this.varMap.get(fieldName)) == null) {
            var = this.lowerCaseVarMap.get(fieldName);
        }
        if (var == null) {
            throw new NoSuchFieldException(fieldName);
        }
        return var.getValue((FXObjectValue)receiver);
    }

    public boolean setField(String fieldName, Object receiver, Object value, boolean isStatic, boolean objectIsApplet) throws Exception {
        this.setField0(fieldName, (FXObjectValue)receiver, value, isStatic, objectIsApplet);
        return true;
    }

    private void setField0(String fieldName, FXObjectValue receiver, Object value, boolean isStatic, boolean objectIsApplet) throws Exception {
        FXVarMember var;
        if (this.varMap == null) {
            this.collectVariables();
        }
        if ((var = this.varMap.get(fieldName)) == null) {
            var = this.lowerCaseVarMap.get(fieldName);
        }
        if (var == null) {
            throw new NoSuchFieldException(fieldName);
        }
        var.setValue(receiver, (FXValue)this.bridge.convert(value, (Object)var.getType()));
    }

    public boolean hasField(String fieldName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        result[0] = this.hasField0(fieldName, (FXValue)receiver, objectIsApplet);
        return true;
    }

    private boolean hasField0(String fieldName, FXValue receiver, boolean objectIsApplet) {
        FXVarMember var;
        if (this.varMap == null) {
            this.collectVariables();
        }
        if ((var = this.varMap.get(fieldName)) == null) {
            var = this.lowerCaseVarMap.get(fieldName);
        }
        return var != null;
    }

    public boolean hasMethod(String methodName, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        result[0] = this.hasMethod0(methodName, (FXObjectValue)receiver, objectIsApplet);
        return true;
    }

    private boolean hasMethod0(String methodName, FXObjectValue receiver, boolean objectIsApplet) {
        FunctionBundle bundle;
        if (this.functionMap == null) {
            this.collectFunctions();
        }
        if ((bundle = this.functionMap.get(methodName)) != null) {
            return true;
        }
        bundle = this.lowerCaseFunctionMap.get(methodName.toLowerCase());
        return bundle != null;
    }

    public boolean hasFieldOrMethod(String name, Object receiver, boolean isStatic, boolean objectIsApplet, boolean[] result) {
        boolean res;
        result[0] = res = this.hasField0(name, (FXObjectValue)receiver, objectIsApplet) || this.hasMethod0(name, (FXObjectValue)receiver, objectIsApplet);
        return true;
    }

    public Object findClass(String name) {
        return null;
    }

    public Object newInstance(Object clazz, Object[] arguments) throws Exception {
        return null;
    }

    private void collectVariables() {
        List<FXVarMember> vars = this.clazz.getVariables(true);
        HashMap<String, FXVarMember> varMap = new HashMap<String, FXVarMember>();
        HashMap<String, FXVarMember> lowerCaseVarMap = new HashMap<String, FXVarMember>();
        for (FXVarMember var : vars) {
            varMap.put(var.getName(), var);
            lowerCaseVarMap.put(var.getName().toLowerCase(), var);
        }
        this.varMap = varMap;
        this.lowerCaseVarMap = lowerCaseVarMap;
    }

    private void collectFunctions() {
        List<FXFunctionMember> funcs = this.clazz.getFunctions(true);
        HashMap<String, FunctionBundle> funcMap = new HashMap<String, FunctionBundle>();
        HashMap<String, FunctionBundle> lowerCaseFuncMap = new HashMap<String, FunctionBundle>();
        for (FXFunctionMember func : funcs) {
            FunctionBundle bundle = (FunctionBundle)funcMap.get(func.getName());
            if (bundle == null) {
                bundle = new FunctionBundle();
                funcMap.put(func.getName(), bundle);
            }
            bundle.add(func);
            String lowerCaseName = func.getName().toLowerCase();
            bundle = (FunctionBundle)lowerCaseFuncMap.get(lowerCaseName);
            if (bundle == null) {
                bundle = new FunctionBundle();
                lowerCaseFuncMap.put(lowerCaseName, bundle);
            }
            bundle.add(func);
        }
        this.functionMap = funcMap;
        this.lowerCaseFunctionMap = lowerCaseFuncMap;
    }

    private static String argsToString(Object[] arguments) {
        StringBuffer buf = new StringBuffer("[");
        if (arguments != null) {
            for (int i = 0; i < arguments.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                Object arg = arguments[i];
                String className = null;
                if (arg != null) {
                    className = arg.getClass().getName();
                }
                buf.append(className);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    private class FunctionBundle {
        protected List<FunctionInfo> functions = new ArrayList<FunctionInfo>();

        private FunctionBundle() {
        }

        public void add(FXFunctionMember function) {
            FunctionInfo info = new FunctionInfo(function);
            if (!this.functions.contains(info)) {
                this.functions.add(info);
            }
        }

        public Result invoke(Object target, Object[] arguments) throws Exception {
            FunctionInfo chosenInfo = null;
            FunctionInfo ambiguousInfo = null;
            FXType[] chosenParameterTypes = null;
            int minNumConversions = 0;
            boolean ambiguous = false;
            for (FunctionInfo info : this.functions) {
                FXType[] parameterTypes = info.getArgumentTypes();
                if (arguments == null ? parameterTypes.length != 0 : parameterTypes.length != arguments.length) continue;
                int numConversions = 0;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Object arg = arguments[i];
                    FXType expectedType = parameterTypes[i];
                    int cost = FXClassDelegate.this.bridge.conversionCost(arg, (Object)expectedType);
                    if (cost < 0) {
                        numConversions = -1;
                        break;
                    }
                    numConversions += cost;
                }
                if (numConversions < 0) continue;
                if (chosenInfo == null || numConversions < minNumConversions) {
                    chosenInfo = info;
                    chosenParameterTypes = info.getArgumentTypes();
                    minNumConversions = numConversions;
                    ambiguous = false;
                    continue;
                }
                if (numConversions != minNumConversions) continue;
                ambiguous = true;
                ambiguousInfo = info;
            }
            if (chosenInfo == null) {
                throw new IllegalArgumentException("No method found matching name " + this.functions.get(0).getName() + " and arguments " + FXClassDelegate.argsToString(arguments));
            }
            if (ambiguous) {
                throw new IllegalArgumentException("More than one method matching name " + this.functions.get(0).getName() + " and arguments " + FXClassDelegate.argsToString(arguments) + "\n  Method 1: " + chosenInfo.getFunction().toString() + "\n  Method 2: " + ambiguousInfo.getFunction().toString());
            }
            Object[] newArgs = null;
            if (arguments != null) {
                newArgs = new FXValue[arguments.length];
                for (int i = 0; i < arguments.length; ++i) {
                    newArgs[i] = (FXValue)FXClassDelegate.this.bridge.convert(arguments[i], (Object)chosenParameterTypes[i]);
                }
            } else {
                newArgs = new FXValue[]{};
            }
            Object ret = chosenInfo.invoke(target, newArgs);
            return new Result(FXClassDelegate.this.unbox(ret), false);
        }
    }

    private class FunctionInfo {
        private FXFunctionMember function;
        private FXType[] argumentTypes;
        private boolean returnsVoid;

        public FunctionInfo(FXFunctionMember function) {
            this.function = function;
            FXFunctionType type = function.getType();
            this.argumentTypes = new FXType[type.minArgs()];
            for (int i = 0; i < this.argumentTypes.length; ++i) {
                this.argumentTypes[i] = type.getArgumentType(i);
            }
            FXType retType = this.getReturnType();
            if (retType.equals(FXClassDelegate.this.voidType)) {
                this.returnsVoid = true;
            }
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            FunctionInfo self = this;
            FunctionInfo other = (FunctionInfo)o;
            return self.getName().equals(other.getName()) && self.getReturnType().equals(other.getReturnType()) && this.arraysEqual(self.getArgumentTypes(), other.getArgumentTypes());
        }

        private boolean arraysEqual(FXType[] params1, FXType[] params2) {
            if (params1 == null != (params2 == null)) {
                return false;
            }
            if (params1 == null) {
                return true;
            }
            if (params1.length != params2.length) {
                return false;
            }
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i].equals(params2[i])) continue;
                return false;
            }
            return true;
        }

        public FXFunctionMember getFunction() {
            return this.function;
        }

        public String getName() {
            return this.getFunction().getName();
        }

        public FXType[] getArgumentTypes() {
            return this.argumentTypes;
        }

        public Object invoke(Object target, Object[] args) throws Exception {
            FXValue res = this.function.invoke((FXObjectValue)target, (FXValue[])args);
            if (res == null && this.returnsVoid) {
                return Void.TYPE;
            }
            return res;
        }

        public FXType getReturnType() {
            return this.function.getType().getReturnType();
        }

        public String toString() {
            return this.function.toString();
        }
    }
}

