/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.date;

import com.sun.javafx.runtime.date.BaseCalendar;
import com.sun.javafx.runtime.date.DateTimeEngine;
import com.sun.javafx.runtime.date.Gregorian;
import java.util.TimeZone;

class DateTimeEngineImpl
extends DateTimeEngine {
    static final Gregorian gcal = Gregorian.getInstance();
    private BaseCalendar.Date gdate;

    DateTimeEngineImpl() {
        this.gdate = gcal.newCalendarDate(null);
    }

    DateTimeEngineImpl(long instant, TimeZone tz) {
        this.gdate = gcal.getCalendarDate(instant, tz);
    }

    public long getInstant() {
        return gcal.getTime(this.gdate);
    }

    public int getYear() {
        int year = this.gdate.getYear();
        if (year <= 0) {
            --year;
        }
        return year;
    }

    public void setYear(int year) {
        if (year < 0) {
            ++year;
        }
        this.gdate.setYear(year);
    }

    public int getMonth() {
        return this.gdate.getMonth();
    }

    public void setMonth(int month) {
        this.gdate.setMonth(month);
    }

    public int getDayOfMonth() {
        return this.gdate.getDayOfMonth();
    }

    public void setDayOfMonth(int dayOfMonth) {
        this.gdate.setDayOfMonth(dayOfMonth);
    }

    public int getDayOfWeek() {
        return this.gdate.getDayOfWeek();
    }

    public int getHours() {
        return this.gdate.getHours();
    }

    public void setHours(int hours) {
        this.gdate.setHours(hours);
    }

    public int getMinutes() {
        return this.gdate.getMinutes();
    }

    public void setMinutes(int minutes) {
        this.gdate.setMinutes(minutes);
    }

    public int getSeconds() {
        return this.gdate.getSeconds();
    }

    public void setSeconds(int seconds) {
        this.gdate.setSeconds(seconds);
    }

    public int getMillis() {
        return this.gdate.getMillis();
    }

    public void setMillis(int millis) {
        this.gdate.setMillis(millis);
    }

    public void setDate(int year, int month, int dayOfMonth) {
        if (year < 0) {
            ++year;
        }
        this.gdate.setDate(year, month, dayOfMonth);
    }

    public void setTimeOfDay(int hours, int minutes, int seconds, int millis) {
        this.gdate.setTimeOfDay(hours, minutes, seconds, millis);
    }

    public int getZoneOffset() {
        return this.gdate.getZoneOffset();
    }

    public int getDaylightSaving() {
        return this.gdate.getDaylightSaving();
    }

    public void setDaylightSaving(int saving) {
        this.gdate.setDaylightSaving(saving);
    }

    public void setDaylightTime(boolean flag) {
        this.gdate.setDaylightTime(flag);
    }

    public TimeZone getZone() {
        return this.gdate.getZone();
    }

    public void setZone(TimeZone tz) {
        this.gdate.setZone(tz);
    }

    public boolean validate() {
        return gcal.validate(this.gdate);
    }

    public boolean isNormalized() {
        return this.gdate.isNormalized();
    }

    public void resetNormalized() {
        this.gdate.setNormalized(false);
    }

    public String toString() {
        return this.gdate.toString();
    }
}

