/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.date;

import com.sun.javafx.runtime.date.CalendarUtils;
import com.sun.javafx.runtime.date.DateTimeEngine;
import java.util.Locale;
import java.util.TimeZone;

public class DateTimeConverter {
    private static final String DELIMITERS = "--T::";
    private static int FIELD_YEAR = 0;
    private static int FIELD_MONTH = 1;
    private static int FIELD_DAY_OF_MONTH = 2;
    private static int FIELD_HOUR = 3;
    private static int FIELD_MINUTE = 4;
    private static int FIELD_SECOND = 5;
    static final String[] DAY_ABBRS = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    static final String[] MONTH_ABBRS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final int NAME_STD = 0;
    private static final int NAME_DST = 1;
    private static final String[][] RFC822ZONE_NAMES = new String[][]{{"EST", "EDT"}, {"CST", "CDT"}, {"MST", "MDT"}, {"PST", "PDT"}, {"GMT", null}, {"UT", null}};
    private static final int OFFSET_STD = 0;
    private static final int OFFSET_DST = 1;
    private static final int[][] RFC822ZONE_OFFSETS = new int[][]{{-18000000, -14400000}, {-21600000, -18000000}, {-25200000, -21600000}, {-28800000, -25200000}, {0, 0}, {0, 0}};
    private static final int ZONE_ID = 0;
    private static final int ZONE_ALTSTD = 1;
    private static final int ZONE_ALTDST = 2;
    private static final String[][] RFC822ZONE_IDS = new String[][]{{"America/New_York", "GMT-05:00", "GMT-04:00"}, {"America/Chicago", "GMT-06:00", "GMT-05:00"}, {"America/Denver", "America/Phoenix", "GMT-06:00"}, {"America/Los_Angeles", "GMT-08:00", "GMT-07:00"}, {"GMT", null, null}, {"GMT", null, null}};

    public static DateTimeEngine parseXMLDateTime(String input) {
        char c;
        int index = 0;
        int[] value = new int[]{0};
        int inputlen = input.length();
        int len = DELIMITERS.length();
        int[] fields = new int[len + 1];
        for (int i = 0; i <= len; ++i) {
            int x = DateTimeConverter.parseInt(input, index, value);
            int digits = x - index;
            int val = value[0];
            if (i == FIELD_YEAR) {
                if (val == 0) {
                    DateTimeConverter.syntaxError(index);
                }
                if (val < 0) {
                    --digits;
                    ++index;
                }
                if (digits < 4 || digits > 4 && input.charAt(index) == '0') {
                    DateTimeConverter.syntaxError(index);
                }
            } else if (digits != 2 || val < 0) {
                DateTimeConverter.syntaxError(index);
            }
            index = x;
            if (i != len && index < inputlen && input.charAt(index++) != DELIMITERS.charAt(i)) {
                DateTimeConverter.syntaxError(index - 1);
            }
            fields[i] = val;
        }
        int ms = 0;
        if (index < inputlen && (c = input.charAt(index)) == '.') {
            int start = index++;
            while (index < inputlen && (c = input.charAt(index)) >= '0' && c <= '9') {
                ++index;
            }
            try {
                float fraction = Float.parseFloat(input.substring(start, index));
                ms = (int)(fraction * 1000.0f);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
        boolean handle24hour = false;
        if (fields[FIELD_HOUR] == 24) {
            if (fields[FIELD_MINUTE] != 0 || fields[FIELD_SECOND] != 0 || ms != 0) {
                throw new IllegalArgumentException("invalid hour of day value");
            }
            handle24hour = true;
            fields[DateTimeConverter.FIELD_HOUR] = 0;
        }
        DateTimeEngine engine = DateTimeEngine.getInstance();
        if (index < inputlen) {
            char c2;
            if ((c2 = input.charAt(index++)) == 'Z') {
                engine.setZone(TimeZone.getTimeZone("UTC"));
            } else if (c2 == '-' || c2 == '+') {
                int start = index - 1;
                int x = DateTimeConverter.parseInt(input, index, value);
                if (x - index != 2) {
                    DateTimeConverter.syntaxError(index);
                }
                int val = value[0] * 60;
                index = x;
                if (input.charAt(index++) != ':') {
                    DateTimeConverter.syntaxError(index - 1);
                }
                if ((x = DateTimeConverter.parseInt(input, index, value)) - index != 2 || value[0] > 59) {
                    DateTimeConverter.syntaxError(index);
                }
                index = x;
                if ((val += value[0]) > 840) {
                    DateTimeConverter.syntaxError(index);
                }
                if (val == 0) {
                    engine.setZone(TimeZone.getTimeZone("UTC"));
                } else {
                    TimeZone tz = TimeZone.getTimeZone("GMT" + input.substring(start, start + 6));
                    if (tz.getRawOffset() == 0) {
                        throw new InternalError("No custom time zone support");
                    }
                    engine.setZone(tz);
                }
            }
        }
        if (index != inputlen) {
            DateTimeConverter.syntaxError(index);
        }
        engine.setDate(fields[FIELD_YEAR], fields[FIELD_MONTH], fields[FIELD_DAY_OF_MONTH]);
        engine.setTimeOfDay(fields[FIELD_HOUR], fields[FIELD_MINUTE], fields[FIELD_SECOND], ms);
        if (!engine.validate()) {
            throw new IllegalArgumentException("invalid date-time");
        }
        if (handle24hour) {
            engine.setHours(24);
        }
        engine.resetNormalized();
        return engine;
    }

    public static String toRFC822String(DateTimeEngine engine) {
        engine.getInstant();
        StringBuilder sb = new StringBuilder();
        sb.append(DAY_ABBRS[engine.getDayOfWeek() - 1]).append(", ");
        CalendarUtils.sprintf0d(sb, engine.getDayOfMonth(), 2).append(' ');
        sb.append(MONTH_ABBRS[engine.getMonth() - 1]).append(' ');
        CalendarUtils.sprintf0d(sb, engine.getYear(), 4).append(' ');
        CalendarUtils.sprintf0d(sb, engine.getHours(), 2).append(':');
        CalendarUtils.sprintf0d(sb, engine.getMinutes(), 2).append(':');
        CalendarUtils.sprintf0d(sb, engine.getSeconds(), 2);
        TimeZone tz = engine.getZone();
        if (tz != null) {
            sb.append(' ');
            try {
                String tzabbr = tz.getDisplayName(false, 0, Locale.US);
                int rawOffset = tz.getRawOffset();
                if (DateTimeConverter.isRFC822ZoneName(tzabbr, rawOffset)) {
                    DateTimeConverter.appendRFC822ZoneName(sb, engine.getZoneOffset(), engine.getDaylightSaving() > 0);
                } else {
                    DateTimeConverter.appendRFC822ZoneNumeric(sb, engine.getZoneOffset());
                }
            }
            catch (LinkageError e) {
                DateTimeConverter.appendRFC822ZoneNumeric(sb, engine.getZoneOffset());
            }
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DateTimeEngine parseRFC822DateTime(String input) {
        try {
            DateTimeEngine e;
            int defaultCenturyStart;
            int[] value;
            int x;
            DateTimeEngine engine = DateTimeEngine.getInstance();
            int index = 0;
            int dayOfWeek = 0;
            if (input.charAt(3) == ',') {
                for (int i = 0; i < DAY_ABBRS.length; ++i) {
                    if (!input.startsWith(DAY_ABBRS[i])) continue;
                    dayOfWeek = i + 1;
                    break;
                }
                if (dayOfWeek == 0) {
                    DateTimeConverter.parseError("invalid day name");
                }
                DateTimeConverter.checkDelimiter(input, 4, ' ');
                index = 5;
            }
            if ((x = DateTimeConverter.parseInt(input, index, value = new int[]{0})) - index > 2) {
                DateTimeConverter.syntaxError(index);
            }
            engine.setDayOfMonth(value[0]);
            DateTimeConverter.checkDelimiter(input, x++, ' ');
            index = x;
            for (int i = 0; i < MONTH_ABBRS.length; ++i) {
                if (!input.startsWith(MONTH_ABBRS[i], index)) continue;
                engine.setMonth(i + 1);
                index += 3;
                break;
            }
            if (index == x) {
                DateTimeConverter.parseError("invalid month name");
            }
            DateTimeConverter.checkDelimiter(input, index++, ' ');
            x = DateTimeConverter.parseInt(input, index, value);
            int year = value[0];
            if (year >= 0 && x - index == 2 && (year += (defaultCenturyStart = (e = DateTimeEngine.getInstance(System.currentTimeMillis(), TimeZone.getDefault())).getYear() - 80) / 100 * 100) < defaultCenturyStart) {
                year += 100;
            }
            if (year == 0) {
                DateTimeConverter.parseError("invalid year value");
            }
            if (year < 0) {
                ++year;
            }
            engine.setYear(year);
            index = x;
            DateTimeConverter.checkDelimiter(input, index++, ' ');
            int hours = 0;
            block9: for (int i = 0; i < 3; ++i) {
                x = DateTimeConverter.parseInt(input, index, value);
                if (x - index != 2) {
                    DateTimeConverter.syntaxError(index);
                }
                int val = value[0];
                boolean foundColon = input.charAt(x) == ':';
                switch (i) {
                    case 0: {
                        if (!foundColon) {
                            DateTimeConverter.syntaxError(x);
                        }
                        engine.setHours(val);
                        hours = val;
                        break;
                    }
                    case 1: {
                        engine.setMinutes(val);
                        if (!foundColon) {
                            index = x;
                            break block9;
                        }
                        ++x;
                        break;
                    }
                    case 2: {
                        engine.setSeconds(val);
                    }
                }
                index = ++x;
            }
            DateTimeConverter.checkDelimiter(input, index++, ' ');
            boolean[] isDST = new boolean[]{false};
            String tzid = DateTimeConverter.parseRFC822Zone(input, index, isDST);
            if (tzid == null) {
                throw new IllegalArgumentException("invalid time zone");
            }
            TimeZone tz = TimeZone.getTimeZone(tzid);
            engine.setZone(tz);
            if (!engine.validate()) {
                DateTimeConverter.parseError("invalid date-time");
            }
            boolean expectDST = isDST[0];
            engine.setDaylightTime(expectDST);
            long instant = engine.getInstant();
            if (engine.getDaylightSaving() > 0 != expectDST) {
                String altTzid = null;
                for (String[] ids : RFC822ZONE_IDS) {
                    if (!tzid.equals(ids[0])) continue;
                    altTzid = ids[expectDST ? 2 : 1];
                }
                if (altTzid == null) {
                    DateTimeConverter.parseError("invalid local time");
                }
                tz = TimeZone.getTimeZone(altTzid);
                if (hours == engine.getHours()) {
                    instant += (long)engine.getDaylightSaving();
                }
                engine = DateTimeEngine.getInstance(instant, tz);
            }
            if (dayOfWeek != 0 && engine.getDayOfWeek() != dayOfWeek) {
                DateTimeConverter.parseError("incorrect day of week");
            }
            engine.resetNormalized();
            return engine;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    private static boolean isRFC822ZoneName(String abbr, int offset) {
        for (int i = 0; i < RFC822ZONE_OFFSETS.length; ++i) {
            if (offset != RFC822ZONE_OFFSETS[i][0] || !abbr.equals(RFC822ZONE_NAMES[i][0])) continue;
            return true;
        }
        return false;
    }

    private static void appendRFC822ZoneName(StringBuilder sb, int offset, boolean daylight) {
        int index = daylight ? 1 : 0;
        for (int i = 0; i < RFC822ZONE_OFFSETS.length; ++i) {
            if (offset != RFC822ZONE_OFFSETS[i][index]) continue;
            sb.append(RFC822ZONE_NAMES[i][index]);
            return;
        }
        DateTimeConverter.appendRFC822ZoneNumeric(sb, offset);
    }

    private static void appendRFC822ZoneNumeric(StringBuilder sb, int offset) {
        char sign = '+';
        if (offset < 0) {
            offset = -offset;
            sign = '-';
        }
        sb.append(sign);
        CalendarUtils.sprintf0d(sb, (offset /= 60000) / 60, 2);
        CalendarUtils.sprintf0d(sb, offset % 60, 2);
    }

    private static String parseRFC822Zone(String input, int index, boolean[] isDST) {
        String tzid = null;
        char c = input.charAt(index);
        if (c == '+' || c == '-') {
            int[] val = new int[]{0};
            int x = DateTimeConverter.parseInt(input, ++index, val);
            int value = val[0];
            if (x - index != 4 || x != input.length() || value % 100 >= 60) {
                throw new IllegalArgumentException();
            }
            if (value != 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("GMT").append(c);
                CalendarUtils.sprintf0d(sb, value / 100, 2).append(':');
                CalendarUtils.sprintf0d(sb, value % 100, 2);
                tzid = sb.toString();
            } else {
                tzid = "GMT";
            }
        } else {
            String name = input.substring(index);
            if (name.length() == 1) {
                char sign;
                int offset = 0;
                if (c >= 'A' && c < 'J') {
                    offset = c - 65 + 1;
                    sign = '-';
                } else if (c >= 'K' && c <= 'M') {
                    offset = c - 65;
                    sign = '-';
                } else if (c >= 'N' && c <= 'Y') {
                    offset = c - 78 + 1;
                    sign = '+';
                } else if (c == 'Z') {
                    sign = '+';
                } else {
                    throw new IllegalArgumentException();
                }
                StringBuilder sb = new StringBuilder();
                sb.append("GMT").append(sign);
                CalendarUtils.sprintf0d(sb, offset, 2).append(":00");
                tzid = sb.toString();
            } else {
                int len = RFC822ZONE_NAMES.length;
                for (int i = 0; i < RFC822ZONE_NAMES.length; ++i) {
                    if (name.equals(RFC822ZONE_NAMES[i][0])) {
                        tzid = RFC822ZONE_IDS[i][0];
                        break;
                    }
                    if (!name.equals(RFC822ZONE_NAMES[i][1])) continue;
                    tzid = RFC822ZONE_IDS[i][0];
                    isDST[0] = true;
                    break;
                }
            }
        }
        return tzid;
    }

    private static int parseInt(String input, int index, int[] value) {
        char c;
        int length = input.length();
        int sign = 1;
        if (index < length && input.charAt(index) == '-') {
            sign = -1;
            ++index;
        }
        int val = 0;
        while (index < length && (c = input.charAt(index)) >= '0' && c <= '9') {
            val = val * 10 + (c - 48);
            ++index;
        }
        value[0] = val * sign;
        return index;
    }

    private static void checkDelimiter(String input, int index, char delimiter) {
        if (input.charAt(index) != delimiter) {
            DateTimeConverter.syntaxError(index);
        }
    }

    private static void syntaxError(int index) {
        throw new IllegalArgumentException("syntax error at " + index);
    }

    private static void parseError(String msg) {
        throw new IllegalArgumentException(msg);
    }
}

