/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import com.sun.javafx.runtime.NumericTypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.BooleanArraySequence;
import com.sun.javafx.runtime.sequence.ByteArraySequence;
import com.sun.javafx.runtime.sequence.CharArraySequence;
import com.sun.javafx.runtime.sequence.DoubleArraySequence;
import com.sun.javafx.runtime.sequence.FloatArraySequence;
import com.sun.javafx.runtime.sequence.IntArraySequence;
import com.sun.javafx.runtime.sequence.LongArraySequence;
import com.sun.javafx.runtime.sequence.ObjectArraySequence;
import com.sun.javafx.runtime.sequence.ShortArraySequence;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfo<T> {
    public final T defaultValue;
    public final Types type;
    public final ArraySequence<T> emptySequence;
    private static final Object[] emptyArray = new Object[0];
    public static final TypeInfo<Object> Object = new TypeInfo<Object>(null, Types.OBJECT);
    public static final TypeInfo<Boolean> Boolean = new TypeInfo<Boolean>(false, Types.BOOLEAN);
    public static final TypeInfo<Character> Character = new TypeInfo<Character>(java.lang.Character.valueOf('\u0000'), Types.CHAR);
    public static final TypeInfo<String> String = new TypeInfo<String>("", Types.OTHER);
    public static final NumericTypeInfo<Byte> Byte = new NumericTypeInfo<Byte>((byte)0, Types.BYTE);
    public static final NumericTypeInfo<Short> Short = new NumericTypeInfo<Short>((short)0, Types.SHORT);
    public static final NumericTypeInfo<Integer> Integer = new NumericTypeInfo<Integer>(0, Types.INT);
    public static final NumericTypeInfo<Long> Long = new NumericTypeInfo<Long>(0L, Types.LONG);
    public static final NumericTypeInfo<Float> Float = new NumericTypeInfo<Float>(java.lang.Float.valueOf(0.0f), Types.FLOAT);
    public static final NumericTypeInfo<Double> Double = new NumericTypeInfo<Double>(0.0, Types.DOUBLE);
    private static final Map<Class<?>, TypeInfo<?>> map = new HashMap();

    protected TypeInfo(T defaultValue, Types type) {
        ArraySequence empty;
        this.defaultValue = defaultValue;
        this.type = type;
        switch (type) {
            case BOOLEAN: {
                empty = new BooleanArraySequence(0, this);
                break;
            }
            case CHAR: {
                empty = new CharArraySequence(0, this);
                break;
            }
            case BYTE: {
                empty = new ByteArraySequence(0, this);
                break;
            }
            case SHORT: {
                empty = new ShortArraySequence(0, this);
                break;
            }
            case INT: {
                empty = new IntArraySequence(0, this);
                break;
            }
            case LONG: {
                empty = new LongArraySequence(0, this);
                break;
            }
            case FLOAT: {
                empty = new FloatArraySequence(0, this);
                break;
            }
            case DOUBLE: {
                empty = new DoubleArraySequence(0, this);
                break;
            }
            default: {
                empty = new ObjectArraySequence<Object>(this, emptyArray, true);
            }
        }
        empty.setMaxShared();
        this.emptySequence = empty;
    }

    public boolean isNumeric() {
        return false;
    }

    public static <T> TypeInfo<T> getTypeInfo() {
        return Object;
    }

    public static <T> TypeInfo<T> getTypeInfo(Class<T> clazz) {
        TypeInfo<Object> ti = map.get(clazz);
        if (ti == null) {
            ti = TypeInfo.getTypeInfo();
        }
        return ti;
    }

    public static <T> TypeInfo<T> makeTypeInfo(T defaultValue) {
        return new TypeInfo<T>(defaultValue, Types.OTHER);
    }

    public static <T> TypeInfo<T> makeAndRegisterTypeInfo(Class clazz, T defaultValue) {
        TypeInfo<T> ti = new TypeInfo<T>(defaultValue, Types.OTHER);
        map.put(clazz, ti);
        return ti;
    }

    public static <T> TypeInfo<T> makeAndRegisterTypeInfo(T defaultValue) {
        return TypeInfo.makeAndRegisterTypeInfo(defaultValue.getClass(), defaultValue);
    }

    static {
        map.put(Byte.class, Byte);
        map.put(Short.class, Short);
        map.put(Integer.class, Integer);
        map.put(Long.class, Long);
        map.put(Float.class, Float);
        map.put(Double.class, Double);
        map.put(Boolean.class, Boolean);
        map.put(Character.class, Character);
        map.put(String.class, String);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Types {
        INT,
        FLOAT,
        OBJECT,
        DOUBLE,
        BOOLEAN,
        LONG,
        SHORT,
        BYTE,
        CHAR,
        OTHER;

    }
}

