/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime;

import java.io.InputStream;
import java.util.Hashtable;

public class SystemProperties {
    private static String[] sysprop_table = new String[]{"application.codebase", "jfx_specific"};
    private static String[] jfxprop_table = new String[]{"application.codebase", ""};
    private static Hashtable sysprop_list = new Hashtable();
    private static Hashtable jfxprop_list = new Hashtable();
    private static final String versionResourceName = "/com/sun/javafx/runtime/resources/version.properties";
    private static String codebase_value;
    public static final String codebase = "javafx.application.codebase";

    private static void setVersions() {
        InputStream is = SystemProperties.class.getResourceAsStream(versionResourceName);
        try {
            int size = is.available();
            byte[] b = new byte[size];
            int n = is.read(b);
            String inStr = new String(b, "utf-8");
            SystemProperties.setFXProperty("javafx.version", SystemProperties.getValue(inStr, "release="));
            SystemProperties.setFXProperty("javafx.runtime.version", SystemProperties.getValue(inStr, "full="));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getValue(String toSearch, String name) {
        String s = toSearch;
        int index = s.indexOf(name);
        if (index != -1) {
            if ((index = (s = s.substring(index)).indexOf(10)) != -1) {
                return s.substring(name.length(), index).trim();
            }
            return s.substring(name.length(), s.length()).trim();
        }
        return "unknown";
    }

    public static void addProperties(String[] table, boolean jfx_specific) {
        if (table == null) {
            return;
        }
        Hashtable props = jfx_specific ? jfxprop_list : sysprop_list;
        for (int i = 0; i < table.length; i += 2) {
            props.put(table[i], table[i + 1]);
        }
    }

    public static String getProperty(String key) {
        Hashtable props = sysprop_list;
        String prefix = "javafx.";
        if (key == null) {
            return null;
        }
        if (!key.startsWith("javafx.".toString())) {
            return null;
        }
        key = key.substring("javafx.".length());
        String found = (String)props.get(key);
        if (found == null || found.equals("")) {
            return null;
        }
        if (found.equals("jfx_specific")) {
            props = jfxprop_list;
            return (String)props.get(key);
        }
        return System.getProperty(found);
    }

    public static void clearProperty(String key) {
        if (key == null) {
            return;
        }
        Hashtable props = sysprop_list;
        String prefix = "javafx.";
        if (!key.startsWith("javafx.".toString())) {
            return;
        }
        key = key.substring("javafx.".length());
        String value = (String)props.get(key);
        if (value == null) {
            return;
        }
        props.remove(key);
        if (value.equals("jfx_specific")) {
            props = jfxprop_list;
            props.remove(key);
        }
    }

    public static void setFXProperty(String key, String value) {
        Hashtable props = sysprop_list;
        String prefix = "javafx.";
        if (key.startsWith("javafx.")) {
            String k = (String)props.get(key = key.substring("javafx.".length()));
            if (k == null) {
                props.put(key, "jfx_specific");
                props = jfxprop_list;
                props.put(key, value);
            } else if (k.equals("jfx_specific")) {
                props = jfxprop_list;
                props.put(key, value);
                if (codebase.equals("javafx." + key)) {
                    codebase_value = value;
                }
            }
        }
    }

    public static String getCodebase() {
        return codebase_value;
    }

    public static void setCodebase(String value) {
        if (value == null) {
            value = "";
        }
        codebase_value = value;
        SystemProperties.setFXProperty(codebase, value);
    }

    static {
        SystemProperties.addProperties(sysprop_table, false);
        SystemProperties.addProperties(jfxprop_table, true);
        SystemProperties.setVersions();
    }
}

